/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;

class FSIteratorAggregate
extends FSIteratorImplBase {
    private final List iterators = new ArrayList();
    private int iteratorIndex = 0;

    private FSIteratorAggregate() {
    }

    public FSIteratorAggregate(Collection c) {
        this.iterators.addAll(c);
        this.moveToFirst();
    }

    public FSIterator copy() {
        ArrayList<FSIterator> itCopies = new ArrayList<FSIterator>(this.iterators.size());
        for (int i = 0; i < this.iterators.size(); ++i) {
            itCopies.add(((FSIterator)this.iterators.get(i)).copy());
        }
        FSIteratorAggregate copy = new FSIteratorAggregate(itCopies);
        copy.iteratorIndex = this.iteratorIndex;
        return copy;
    }

    public FeatureStructure get() throws NoSuchElementException {
        if (!this.isValid()) {
            throw new NoSuchElementException();
        }
        return ((FSIterator)this.iterators.get(this.iteratorIndex)).get();
    }

    public boolean isValid() {
        return this.iteratorIndex < this.iterators.size();
    }

    public void moveTo(FeatureStructure fs) {
        throw new UnsupportedOperationException("This operation is not supported on an aggregate iterator.");
    }

    public void moveToFirst() {
        this.iteratorIndex = 0;
        while (this.iteratorIndex < this.iterators.size()) {
            FSIterator it = (FSIterator)this.iterators.get(this.iteratorIndex);
            it.moveToFirst();
            if (it.isValid()) {
                return;
            }
            ++this.iteratorIndex;
        }
    }

    public void moveToLast() {
        this.iteratorIndex = this.iterators.size() - 1;
        while (this.iteratorIndex >= 0) {
            FSIterator it = (FSIterator)this.iterators.get(this.iteratorIndex);
            it.moveToLast();
            if (it.isValid()) {
                return;
            }
            --this.iteratorIndex;
        }
    }

    public void moveToNext() {
        if (!this.isValid()) {
            return;
        }
        FSIterator current = (FSIterator)this.iterators.get(this.iteratorIndex);
        current.moveToNext();
        if (current.isValid()) {
            return;
        }
        ++this.iteratorIndex;
        while (this.iteratorIndex < this.iterators.size()) {
            current = (FSIterator)this.iterators.get(this.iteratorIndex);
            current.moveToFirst();
            if (current.isValid()) {
                return;
            }
            ++this.iteratorIndex;
        }
    }

    public void moveToPrevious() {
        if (!this.isValid()) {
            return;
        }
        FSIterator current = (FSIterator)this.iterators.get(this.iteratorIndex);
        current.moveToPrevious();
        if (current.isValid()) {
            return;
        }
        --this.iteratorIndex;
        while (this.iteratorIndex >= 0) {
            current = (FSIterator)this.iterators.get(this.iteratorIndex);
            current.moveToLast();
            if (current.isValid()) {
                return;
            }
            --this.iteratorIndex;
        }
        this.iteratorIndex = this.iterators.size();
    }
}

