/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexComparatorImpl;
import org.apache.uima.cas.impl.FSIndexImpl;
import org.apache.uima.cas.impl.FSIteratorWrapper;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImpl;
import org.apache.uima.cas.impl.LowLevelIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntPointerIterator;

public abstract class FSLeafIndexImpl
implements IntComparator,
FSIndex,
FSIndexImpl {
    private final int indexType;
    protected CASImpl lowLevelCAS;
    private static final int STRING_CODE = 0;
    private static final int FLOAT_CODE = 1;
    private static final int INT_CODE = 2;
    private static final int TYPE_ORDER_CODE = 3;
    private static final int BOOLEAN_CODE = 4;
    private static final int BYTE_CODE = 5;
    private static final int SHORT_CODE = 6;
    private static final int LONG_CODE = 7;
    private static final int DOUBLE_CODE = 8;
    private FSIndexComparatorImpl comparator;
    private boolean isInitialized = false;
    private int[] keyType;
    private int[] keyOffset;
    private LinearTypeOrder[] typeOrder;
    private int[] keyComp;
    private int numKeys;
    private Type type;

    private FSLeafIndexImpl() {
        this.indexType = 0;
    }

    protected FSLeafIndexImpl(CASImpl cas, Type type, int indexType) {
        this.indexType = indexType;
        this.lowLevelCAS = cas;
        this.type = type;
    }

    abstract boolean insert(int var1);

    abstract void remove(int var1);

    public abstract ComparableIntPointerIterator pointerIterator(IntComparator var1, int[] var2, int var3);

    public FSIndexComparator getComparator() {
        return this.comparator;
    }

    IntComparator getIntComparator() {
        return this;
    }

    public int getIndexingStrategy() {
        return this.indexType;
    }

    boolean init(FSIndexComparator comp) {
        if (this.isInitialized) {
            return false;
        }
        FSIndexComparatorImpl comp1 = (FSIndexComparatorImpl)comp;
        this.comparator = comp1.copy();
        if (!this.comparator.isValid()) {
            return false;
        }
        int nKeys = this.comparator.getNumberOfKeys();
        this.keyType = new int[nKeys];
        this.keyOffset = new int[nKeys];
        this.keyComp = new int[nKeys];
        this.typeOrder = new LinearTypeOrder[nKeys];
        block4: for (int i = 0; i < nKeys; ++i) {
            switch (comp.getKeyType(i)) {
                case 0: {
                    Feature keyFeature = this.comparator.getKeyFeature(i);
                    this.keyType[i] = FSLeafIndexImpl.getKeyCode(keyFeature);
                    this.keyOffset[i] = this.getFeatureOffset(keyFeature);
                    this.keyComp[i] = this.comparator.getKeyComparator(i);
                    continue block4;
                }
                case 1: {
                    this.keyType[i] = 3;
                    this.keyComp[i] = this.comparator.getKeyComparator(i);
                    this.typeOrder[i] = this.comparator.getKeyTypeOrder(i);
                    this.keyOffset[i] = 0;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Assertion failed.");
                }
            }
        }
        this.numKeys = nKeys;
        this.isInitialized = true;
        return true;
    }

    private static final int getKeyCode(Feature feat) {
        String typeName = feat.getRange().getName();
        if (typeName.equals("uima.cas.String")) {
            return 0;
        }
        if (typeName.equals("uima.cas.Float")) {
            return 1;
        }
        if (typeName.equals("uima.cas.Boolean")) {
            return 4;
        }
        if (typeName.equals("uima.cas.Byte")) {
            return 5;
        }
        if (typeName.equals("uima.cas.Short")) {
            return 6;
        }
        if (typeName.equals("uima.cas.Long")) {
            return 7;
        }
        if (typeName.equals("uima.cas.Double")) {
            return 8;
        }
        return 2;
    }

    private final int getFeatureOffset(Feature feat) {
        return this.comparator.getLowLevelCAS().getFeatureOffset(((FeatureImpl)feat).getCode());
    }

    public int ll_compare(int ref1, int ref2) {
        return this.compare(ref1, ref2);
    }

    public int compare(int fs1, int fs2) {
        int[] heap = this.lowLevelCAS.getHeap().heap;
        block7: for (int i = 0; i < this.numKeys; ++i) {
            int val1 = heap[fs1 + this.keyOffset[i]];
            int val2 = heap[fs2 + this.keyOffset[i]];
            switch (this.keyType[i]) {
                case 0: {
                    String string1 = this.lowLevelCAS.getStringForCode(val1);
                    String string2 = this.lowLevelCAS.getStringForCode(val2);
                    int compVal = string1 == null ? (string2 == null ? 0 : -1) : (string2 == null ? 1 : string1.compareTo(string2));
                    if (compVal == 0) continue block7;
                    if (this.keyComp[i] == 0) {
                        return compVal;
                    }
                    return -compVal;
                }
                case 1: {
                    float float1 = CASImpl.int2float(val1);
                    float float2 = CASImpl.int2float(val2);
                    if (float1 < float2) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (!(float1 > float2)) continue block7;
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                case 3: {
                    if (val1 == val2) continue block7;
                    if (this.typeOrder[i].lessThan(val1, val2)) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                case 7: {
                    long long1 = this.lowLevelCAS.getLongHeap().getHeapValue(val1);
                    long long2 = this.lowLevelCAS.getLongHeap().getHeapValue(val2);
                    if (long1 < long2) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (long1 <= long2) continue block7;
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                case 8: {
                    double double1 = Double.longBitsToDouble(this.lowLevelCAS.getLongHeap().getHeapValue(val1));
                    double double2 = Double.longBitsToDouble(this.lowLevelCAS.getLongHeap().getHeapValue(val2));
                    if (double1 < double2) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (!(double1 > double2)) continue block7;
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
                default: {
                    if (val1 < val2) {
                        if (this.keyComp[i] == 0) {
                            return -1;
                        }
                        return 1;
                    }
                    if (val1 <= val2) continue block7;
                    if (this.keyComp[i] == 0) {
                        return 1;
                    }
                    return -1;
                }
            }
        }
        return 0;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.comparator.equals(o);
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public int compare(FeatureStructure fs1, FeatureStructure fs2) {
        return this.compare(((FeatureStructureImpl)fs1).getAddress(), ((FeatureStructureImpl)fs2).getAddress());
    }

    public Type getType() {
        return this.type;
    }

    protected abstract IntPointerIterator refIterator();

    public IntPointerIterator getIntIterator() {
        return this.refIterator();
    }

    protected abstract IntPointerIterator refIterator(int var1);

    public FSIterator iterator() {
        System.out.println(this.getClass().getName());
        return new FSIteratorWrapper(this.refIterator(), this.lowLevelCAS);
    }

    public FSIterator iterator(FeatureStructure fs) {
        return new FSIteratorWrapper(this.refIterator(((FeatureStructureImpl)fs).getAddress()), this.lowLevelCAS);
    }

    public abstract void deleteFS(FeatureStructure var1);

    public LowLevelIterator ll_iterator(boolean ambiguous) {
        if (ambiguous) {
            return this.ll_iterator();
        }
        return null;
    }
}

