/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;

class FSListIteratorImpl
implements ListIterator {
    private FSIterator forward;
    private FSIterator back;

    public FSListIteratorImpl(FSIterator it) {
        this.forward = it;
        this.back = it.copy();
        it.moveToPrevious();
    }

    public boolean hasNext() {
        return this.forward.isValid();
    }

    public boolean hasPrevious() {
        return this.back.isValid();
    }

    public void moveToEnd() {
        this.back.moveToLast();
        this.forward.moveToLast();
        this.forward.moveToNext();
    }

    public void moveToStart() {
        this.forward.moveToFirst();
        this.back.moveToFirst();
        this.back.moveToPrevious();
    }

    public Object next() throws NoSuchElementException {
        if (!this.forward.isValid()) {
            throw new NoSuchElementException();
        }
        this.forward.moveToNext();
        if (this.back.isValid()) {
            this.back.moveToNext();
        } else {
            this.back.moveToFirst();
        }
        return this.back.get();
    }

    public Object previous() throws NoSuchElementException {
        if (!this.back.isValid()) {
            throw new NoSuchElementException();
        }
        this.back.moveToPrevious();
        if (this.forward.isValid()) {
            this.forward.moveToPrevious();
        } else {
            this.forward.moveToLast();
        }
        return this.forward.get();
    }

    public void add(Object o) {
        throw new UnsupportedOperationException();
    }

    public int nextIndex() {
        throw new UnsupportedOperationException();
    }

    public int previousIndex() {
        throw new UnsupportedOperationException();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void set(Object o) {
        throw new UnsupportedOperationException();
    }
}

