/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;

class FilteredIterator
extends FSIteratorImplBase {
    private FSIterator it;
    private FSMatchConstraint cons;

    private FilteredIterator() {
    }

    FilteredIterator(FSIterator it, FSMatchConstraint cons) {
        this();
        this.it = it;
        this.cons = cons;
        this.moveToFirst();
    }

    public boolean isValid() {
        return this.it.isValid();
    }

    public void moveToFirst() {
        this.it.moveToFirst();
        while (this.it.isValid() && !this.cons.match(this.it.get())) {
            this.it.moveToNext();
        }
    }

    public void moveToLast() {
        this.it.moveToLast();
        while (this.it.isValid() && !this.cons.match(this.it.get())) {
            this.it.moveToPrevious();
        }
    }

    public void moveToNext() {
        this.it.moveToNext();
        while (this.it.isValid() && !this.cons.match(this.it.get())) {
            this.it.moveToNext();
        }
    }

    public void moveToPrevious() {
        this.it.moveToPrevious();
        while (this.it.isValid() && !this.cons.match(this.it.get())) {
            this.it.moveToPrevious();
        }
    }

    public FeatureStructure get() throws NoSuchElementException {
        return this.it.get();
    }

    public FSIterator copy() {
        return new FilteredIterator(this.it.copy(), this.cons);
    }

    public void moveTo(FeatureStructure fs) {
        this.it.moveTo(fs);
        if (!this.cons.match(this.it.get())) {
            this.moveToNext();
        }
    }
}

