/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.uima.internal.util.IntArrayUtils;

final class StringHeap {
    private static final int DEFAULT_REF_HEAP_BASE_SIZE = 5000;
    private static final int DEFAULT_REF_HEAP_MULT_LIMIT = 5120000;
    private static final int DEFAULT_STRING_HEAP_BASE_SIZE = 20000;
    private static final int DEFAULT_STRING_HEAP_MULT_LIMIT = 20480000;
    private static final int MIN_REF_HEAP_BASE_SIZE = 1024;
    private static final int MIN_STR_HEAP_BASE_SIZE = 32768;
    protected static final int REF_HEAP_CELL_SIZE = 3;
    protected static final int CHAR_HEAP_POINTER_OFFSET = 0;
    protected static final int CHAR_HEAP_STRLEN_OFFSET = 1;
    protected static final int STRING_LIST_ADDR_OFFSET = 2;
    private static final int GROWTH_FACTOR = 4;
    private static final int NULL = 0;
    protected static final int FIRST_CELL_REF = 3;
    private final int refHeapBaseSize;
    private final int refHeapMultLimit;
    private final int strHeapBaseSize;
    private final int strHeapMultLimit;
    protected int refHeapPos = 3;
    protected int[] refHeap;
    protected ArrayList stringList;
    protected int charHeapPos = 0;
    protected char[] stringHeap;

    StringHeap() {
        this(5000, 5120000, 20000, 20480000);
    }

    StringHeap(int refHeapBaseSize, int refHeapMultLimit, int strHeapBaseSize, int strHeapMultLimit) {
        this.refHeapBaseSize = refHeapBaseSize < 1024 ? 1024 : refHeapBaseSize;
        this.refHeapMultLimit = refHeapMultLimit < 5120000 ? 5120000 : refHeapMultLimit;
        this.strHeapBaseSize = strHeapBaseSize < 32768 ? 32768 : strHeapBaseSize;
        this.strHeapMultLimit = strHeapMultLimit < 20480000 ? 20480000 : strHeapMultLimit;
        this.initMemory();
    }

    private static final int cas2refHeapPointer(int i) {
        return i * 3;
    }

    private static final int refHeap2casPointer(int i) {
        return i / 3;
    }

    private final void initMemory() {
        this.refHeap = new int[this.refHeapBaseSize];
        this.stringHeap = new char[this.strHeapBaseSize];
        this.stringList = new ArrayList();
        this.stringList.add(null);
    }

    final void reset() {
        this.reset(false);
    }

    final void reset(boolean doFullReset) {
        if (doFullReset) {
            this.initMemory();
        } else {
            Arrays.fill(this.refHeap, 0, this.refHeapPos, 0);
            this.stringList = new ArrayList();
            this.stringList.add(null);
        }
        this.refHeapPos = 3;
        this.charHeapPos = 0;
    }

    String getStringForCode(int stringCode) {
        if (stringCode == 0) {
            return null;
        }
        int strInfoRef = StringHeap.cas2refHeapPointer(stringCode);
        int internalStringCode = this.refHeap[strInfoRef + 2];
        if (internalStringCode != 0) {
            return (String)this.stringList.get(internalStringCode);
        }
        int strOffset = this.refHeap[strInfoRef + 0];
        int strLen = this.refHeap[strInfoRef + 1];
        return new String(this.stringHeap, strOffset, strLen);
    }

    int copyCharsToBuffer(int stringCode, char[] buffer, int start) {
        int strInfoRef = StringHeap.cas2refHeapPointer(stringCode);
        int strCode = this.refHeap[strInfoRef + 2];
        int strOffset = this.refHeap[strInfoRef + 0];
        int bufMax = buffer.length - start;
        if (strCode == 0) {
            int strLen = this.refHeap[strInfoRef + 1];
            int max = strLen < bufMax ? strLen : bufMax;
            for (int i = 0; i < max; ++i) {
                buffer[start] = this.stringHeap[strOffset];
                ++start;
                ++strOffset;
            }
            return strLen;
        }
        int internalStringCode = this.refHeap[strInfoRef + 2];
        String str = (String)this.stringList.get(internalStringCode);
        int len = str.length();
        int max = len < bufMax ? len : bufMax;
        for (int i = 0; i < max; ++i) {
            buffer[start + i] = str.charAt(i);
        }
        return len;
    }

    int addString(String s) {
        int stringRef;
        if (s == null) {
            return 0;
        }
        int cellRef = this.refHeapPos;
        this.refHeapPos += 3;
        this.ensureRefHeapSize();
        this.refHeap[cellRef + 2] = stringRef = this.stringList.size();
        this.refHeap[cellRef + 1] = s.length();
        this.stringList.add(s);
        return StringHeap.refHeap2casPointer(cellRef);
    }

    int cloneStringReference(int stringCode) {
        int strInfoRef = StringHeap.cas2refHeapPointer(stringCode);
        int strRef = this.refHeap[strInfoRef + 2];
        int strLen = this.refHeap[strInfoRef + 1];
        int cellRef = this.refHeapPos;
        this.refHeapPos += 3;
        this.ensureRefHeapSize();
        this.refHeap[cellRef + 2] = strRef;
        this.refHeap[cellRef + 1] = strLen;
        return StringHeap.refHeap2casPointer(cellRef);
    }

    private final void ensureRefHeapSize() {
        this.refHeap = IntArrayUtils.ensure_size(this.refHeap, this.refHeapPos, 4, this.refHeapMultLimit);
    }

    int addCharBuffer(char[] buffer, int start, int length) {
        int charBufStart;
        int cellRef = this.refHeapPos;
        this.refHeapPos += 3;
        this.ensureRefHeapSize();
        this.refHeap[cellRef + 0] = charBufStart = this.charHeapPos;
        this.refHeap[cellRef + 1] = length;
        this.charHeapPos += length + 1;
        this.ensureCharHeapSize();
        System.arraycopy(buffer, start, this.stringHeap, charBufStart, length);
        return StringHeap.refHeap2casPointer(cellRef);
    }

    private void ensureCharHeapSize() {
        this.stringHeap = IntArrayUtils.ensure_size(this.stringHeap, this.charHeapPos, 4, this.strHeapMultLimit);
    }

    final boolean isStringCode(int stringCode) {
        int cellRef = StringHeap.cas2refHeapPointer(stringCode);
        return this.isValidRef(cellRef);
    }

    private final boolean isValidRef(int ref) {
        return ref >= 3 && ref < this.refHeapPos;
    }

    final boolean isJavaString(int stringCode) {
        int cellRef = StringHeap.cas2refHeapPointer(stringCode);
        if (!this.isValidRef(cellRef)) {
            return false;
        }
        return this.refHeap[cellRef + 2] != 0;
    }

    final boolean isCharArray(int stringCode) {
        int cellRef = StringHeap.cas2refHeapPointer(stringCode);
        if (!this.isValidRef(cellRef)) {
            return false;
        }
        return this.refHeap[cellRef + 0] != 0;
    }

    final int getCharArrayLength(int stringCode) {
        int cellRef = StringHeap.cas2refHeapPointer(stringCode);
        return this.refHeap[cellRef + 1];
    }

    final int getLeastStringCode() {
        return StringHeap.refHeap2casPointer(3);
    }

    final int getLargestStringCode() {
        return StringHeap.refHeap2casPointer(this.refHeapPos) - 1;
    }
}

