/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;

public class Subiterator
extends FSIteratorImplBase {
    private ArrayList list = new ArrayList();
    private int pos = 0;
    private Comparator annotationComparator = null;

    private Subiterator() {
    }

    Subiterator(FSIterator it) {
        this();
        it.moveToFirst();
        if (!it.isValid()) {
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (current.getEnd() <= next.getBegin()) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    Subiterator(FSIterator it, AnnotationFS annot, boolean ambiguous, boolean strict) {
        this();
        if (ambiguous) {
            this.initAmbiguousSubiterator(it, annot, strict);
        } else {
            this.initUnambiguousSubiterator(it, annot, strict);
        }
    }

    private void initAmbiguousSubiterator(FSIterator it, AnnotationFS annot, boolean strict) {
        AnnotationFS current;
        int start = annot.getBegin();
        int end = annot.getEnd();
        it.moveTo(annot);
        if (it.isValid() && ((Object)it.get()).equals(annot)) {
            it.moveToNext();
        }
        while (it.isValid() && ((AnnotationFS)it.get()).getBegin() < start) {
            it.moveToNext();
        }
        while (it.isValid() && (current = (AnnotationFS)it.get()).getBegin() <= end) {
            it.moveToNext();
            if (strict && current.getEnd() > end) continue;
            this.list.add(current);
        }
    }

    private void initUnambiguousSubiterator(FSIterator it, AnnotationFS annot, boolean strict) {
        int start = annot.getBegin();
        int end = annot.getEnd();
        it.moveTo(annot);
        if (it.isValid() && ((Object)it.get()).equals(annot)) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            return;
        }
        annot = (AnnotationFS)it.get();
        this.list = new ArrayList();
        while (it.isValid() && (start > annot.getBegin() || strict && annot.getEnd() > end)) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (next.getBegin() < current.getEnd()) {
                it.moveToNext();
                continue;
            }
            if (next.getBegin() > end) break;
            if (!strict || next.getEnd() <= end) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.list.size();
    }

    public FeatureStructure get() throws NoSuchElementException {
        if (this.isValid()) {
            return (FeatureStructure)this.list.get(this.pos);
        }
        throw new NoSuchElementException();
    }

    public void moveToNext() {
        ++this.pos;
    }

    public void moveToPrevious() {
        --this.pos;
    }

    public void moveToFirst() {
        this.pos = 0;
    }

    public void moveToLast() {
        this.pos = this.list.size() - 1;
    }

    private final Comparator getAnnotationComparator(FeatureStructure fs) {
        if (this.annotationComparator == null) {
            this.annotationComparator = new AnnotationComparator(fs.getCAS().getAnnotationIndex());
        }
        return this.annotationComparator;
    }

    public void moveTo(FeatureStructure fs) {
        int found = Collections.binarySearch(this.list, fs, this.getAnnotationComparator(fs));
        this.pos = found >= 0 ? found : -found - 1;
    }

    public FSIterator copy() {
        Subiterator copy = new Subiterator();
        copy.list = this.list;
        copy.pos = this.pos;
        return copy;
    }

    private static class AnnotationComparator
    implements Comparator {
        AnnotationIndex index;

        private AnnotationComparator(AnnotationIndex index) {
            this.index = index;
        }

        public int compare(Object fs1, Object fs2) {
            return this.index.compare((FeatureStructure)fs1, (FeatureStructure)fs2);
        }
    }
}

