/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.FSIteratorImplBase;
import org.apache.uima.cas.text.AnnotationFS;

public class UnambiguousIteratorImpl
extends FSIteratorImplBase {
    private ArrayList list;
    private int pos;

    private UnambiguousIteratorImpl() {
        this.pos = 0;
    }

    public UnambiguousIteratorImpl(FSIterator it) {
        this();
        this.list = new ArrayList();
        it.moveToFirst();
        if (!it.isValid()) {
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (current.getEnd() <= next.getBegin()) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    public UnambiguousIteratorImpl(FSIterator it, int start, int end, boolean strict) {
        this.initUnambiguousSubiterator(it, start, end, strict);
    }

    private void initUnambiguousSubiterator(FSIterator it, int start, int end, boolean strict) {
        this.list = new ArrayList();
        it.moveToFirst();
        while (it.isValid() && start > ((AnnotationFS)it.get()).getBegin()) {
            it.moveToNext();
        }
        if (!it.isValid()) {
            this.pos = 0;
            return;
        }
        AnnotationFS current = (AnnotationFS)it.get();
        this.list.add(current);
        it.moveToNext();
        while (it.isValid()) {
            AnnotationFS next = (AnnotationFS)it.get();
            if (next.getBegin() < current.getEnd()) {
                it.moveToNext();
                continue;
            }
            if (next.getBegin() > end) break;
            if (!strict || current.getEnd() <= end) {
                current = next;
                this.list.add(current);
            }
            it.moveToNext();
        }
    }

    public boolean isValid() {
        return this.pos >= 0 && this.pos < this.list.size();
    }

    public FeatureStructure get() throws NoSuchElementException {
        if (this.isValid()) {
            return (FeatureStructure)this.list.get(this.pos);
        }
        throw new NoSuchElementException();
    }

    public void moveToNext() {
        ++this.pos;
    }

    public void moveToPrevious() {
        --this.pos;
    }

    public void moveToFirst() {
        this.pos = 0;
    }

    public void moveToLast() {
        this.pos = this.list.size() - 1;
    }

    public void moveTo(FeatureStructure fs) {
        int found = Collections.binarySearch(this.list, fs);
        this.pos = found >= 0 ? found : -found - 1;
    }

    public FSIterator copy() {
        UnambiguousIteratorImpl copy = new UnambiguousIteratorImpl();
        copy.list = this.list;
        copy.pos = this.pos;
        return copy;
    }
}

