/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.container.deployer;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.collection.impl.base_cpm.container.CasProcessorConfiguration;
import org.apache.uima.collection.impl.cpm.container.deployer.RunnableApplication;
import org.apache.uima.collection.impl.cpm.utils.Execute;
import org.apache.uima.collection.metadata.CasProcessorExecArg;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.util.Level;

public class JavaApplication
extends RunnableApplication {
    public JavaApplication(CasProcessorConfiguration aCasProcessorConfiguration, CpeCasProcessor aJaxbCasProcessorConfig) throws ResourceConfigurationException {
        this.addApplicationInfo(aCasProcessorConfiguration, aJaxbCasProcessorConfig);
    }

    protected void addApplicationInfo(CasProcessorConfiguration aCasProcessorConfiguration, CpeCasProcessor aCasProcessor) throws ResourceConfigurationException {
        super.addApplicationInfo(aCasProcessorConfiguration, aCasProcessor);
        String[] cmdLine = this.addApplicationCmdLineArguments(aCasProcessorConfiguration, this.argList, this.executable);
        this.exec.setCmdLine(cmdLine);
    }

    protected String[] addApplicationCmdLineArguments(CasProcessorConfiguration aCasProcessorConfiguration, List argList, String aExecutable) throws ResourceConfigurationException {
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(aExecutable);
        cmdArgs.add("-DVNS_HOST=localhost");
        cmdArgs.add("-DVNS_PORT=9005");
        for (int i = 0; i < argList.size(); ++i) {
            Object arg = argList.get(i);
            if (!(arg instanceof CasProcessorExecArg)) continue;
            String argValue = null;
            try {
                argValue = ((CasProcessorExecArg)arg).getArgValue();
            }
            catch (Exception e) {
                continue;
            }
            if (argValue == null || argValue.trim().length() == 0 || argValue.startsWith("-DVNS_HOST") || argValue.startsWith("-DVNS_PORT")) continue;
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cmd_arg__FINEST", new Object[]{Thread.currentThread().getName(), String.valueOf(i), arg});
            }
            if (argValue.trim().equalsIgnoreCase("-cp") && argValue.trim().length() > 3) {
                String systemClasspath = this.getSysEnvVarValue("CLASSPATH");
                if (systemClasspath == null) {
                    systemClasspath = "";
                }
                String classpath = argValue.trim().substring(3);
                argList.add(i, "-cp");
                cmdArgs.add((String)arg);
                argList.add(i + 1, classpath + System.getProperty("path.separator") + systemClasspath);
                if (!UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "initialize", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_show_cmd_classpath__FINEST", new Object[]{Thread.currentThread().getName(), classpath});
                continue;
            }
            if ("${descriptor}".equals(argValue.trim())) {
                String descriptorPath;
                URL descriptorUrl = aCasProcessorConfiguration.getDescriptorUrl();
                try {
                    descriptorPath = new URI(descriptorUrl.toString()).getPath();
                }
                catch (URISyntaxException e) {
                    throw new ResourceConfigurationException(e);
                }
                if (System.getProperty("os.name") != null && System.getProperty("os.name").toLowerCase().startsWith("linux")) {
                    cmdArgs.add(descriptorPath);
                    continue;
                }
                cmdArgs.add("\"" + descriptorPath + "\"");
                continue;
            }
            cmdArgs.add(argValue);
        }
        String[] cmdLine = null;
        if (cmdArgs.size() > 0) {
            cmdLine = new String[cmdArgs.size()];
            cmdArgs.toArray(cmdLine);
        }
        return cmdLine;
    }

    public Execute getExecSpec() {
        return this.exec;
    }
}

