/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.naming.ConfigurationException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.vinci.util.Descriptor;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.collection.impl.cpm.CPMException;
import org.apache.uima.collection.impl.cpm.utils.ChunkMetadata;
import org.apache.uima.collection.impl.cpm.utils.ConfigurableFeature;
import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.cpm.utils.TimerFactory;
import org.apache.uima.collection.impl.cpm.utils.ValuePair;
import org.apache.uima.internal.util.JavaTimer;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.UimaTimer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CPMUtils {
    public static final String CPM_LOG_RESOURCE_BUNDLE = "org.apache.uima.collection.impl.cpm.cpm_messages";
    private static UimaTimer timer = null;

    public static String[] getKeys2Drop(String aKeyDropMapFile) throws ResourceConfigurationException {
        return new String[]{"", ""};
    }

    public static void setTimer(UimaTimer aTimer) {
        timer = aTimer;
    }

    public static UimaTimer getTimer() {
        return timer;
    }

    public static String convertToAbsolutePath(String aSystemVar, String aExpr, String aPathToConvert) {
        if (aPathToConvert == null || aSystemVar == null || !aPathToConvert.startsWith(aExpr)) {
            return aPathToConvert;
        }
        return aSystemVar + aPathToConvert.substring(aExpr.length());
    }

    public static UimaTimer getTimer(String aTimerClass) throws Exception {
        if (aTimerClass != null) {
            new TimerFactory(aTimerClass);
            return TimerFactory.getTimer();
        }
        return new JavaTimer();
    }

    public static synchronized long extractTime(ProcessTrace aPT, String eventName) {
        List aList = aPT.getEvents();
        int counter = 0;
        while (aList != null && aList.size() > 0 && counter < aList.size()) {
            ProcessTraceEvent pte;
            if ((pte = (ProcessTraceEvent)aList.get(counter++)) == null) {
                return 0L;
            }
            if (eventName == null || eventName.equals(pte.getDescription())) {
                return pte.getDurationExcludingSubEvents();
            }
            List subEvents = pte.getSubEvents();
            for (int i = 0; subEvents != null && i < subEvents.size(); ++i) {
                if (!eventName.equals(((ProcessTraceEvent)subEvents.get(i)).getType())) continue;
                return ((ProcessTraceEvent)subEvents.get(i)).getDurationExcludingSubEvents();
            }
        }
        return 0L;
    }

    public static void dumpEvents(ProcessTrace aPTr) {
        List aList = aPTr.getEvents();
        for (int i = 0; i < aList.size(); ++i) {
            ProcessTraceEvent prEvent = (ProcessTraceEvent)aList.get(i);
            String aEvType = prEvent.getType();
            if (System.getProperty("DEBUG_EVENTS") == null || !UIMAFramework.getLogger().isLoggable(Level.FINEST)) continue;
            UIMAFramework.getLogger(CPMUtils.class).log(Level.FINEST, "Returning Report With Event::" + aEvType + " For Component:::" + prEvent.getComponentName() + " Duration:::" + prEvent.getDurationExcludingSubEvents());
        }
    }

    public static String scrubThePath(String value) {
        String rootPath;
        if (value != null && value.indexOf("##CPM_HOME") > -1 && (rootPath = System.getProperty("CPM_HOME")) != null) {
            return rootPath + value.substring("##CPM_HOME".length());
        }
        return value;
    }

    private static String extractText(Node aNode) throws Exception {
        String text = null;
        NodeList children = aNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node achild = children.item(i);
            if (achild.getNodeType() != 3) continue;
            text = achild.getNodeValue().trim();
        }
        return text;
    }

    private static ConfigurableFeature getConfigurableFeature(Node entityNode) throws ConfigurationException {
        ConfigurableFeature featureStructure = null;
        try {
            String from = null;
            String to = null;
            ArrayList featureList = null;
            NodeList children = entityNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node achild = children.item(i);
                if (achild.getNodeType() != 1) continue;
                if (achild.getNodeName().equals("from")) {
                    from = CPMUtils.getTextValue(achild.getChildNodes());
                    continue;
                }
                if (achild.getNodeName().equals("to")) {
                    to = CPMUtils.getTextValue(achild.getChildNodes());
                    continue;
                }
                if (!achild.getNodeName().equals("features")) continue;
                featureList = CPMUtils.getFeatures(achild);
            }
            featureStructure = new ConfigurableFeature(from, to);
            featureStructure.addAttributes(featureList);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.getMessage());
        }
        return featureStructure;
    }

    private static String getTextValue(NodeList aList) {
        for (int i = 0; i < aList.getLength(); ++i) {
            Node achild = aList.item(i);
            if (achild.getNodeType() != 3) continue;
            return achild.getNodeValue();
        }
        return null;
    }

    private static ArrayList getFeatures(Node attributesNode) throws ConfigurationException {
        ArrayList<ValuePair> attributeList = new ArrayList<ValuePair>();
        try {
            String from = null;
            String to = null;
            NodeList children = attributesNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node achild = children.item(i);
                if (achild.getNodeType() != 1 || !achild.getNodeName().equals("name")) continue;
                NodeList atts = achild.getChildNodes();
                for (int j = 0; j < atts.getLength(); ++j) {
                    Node attribute = atts.item(j);
                    if (attribute.getNodeType() != 1) continue;
                    if (attribute.getNodeName().equals("from")) {
                        from = CPMUtils.getTextValue(attribute.getChildNodes());
                        continue;
                    }
                    if (!attribute.getNodeName().equals("to")) continue;
                    to = CPMUtils.getTextValue(attribute.getChildNodes());
                }
                ValuePair value = new ValuePair(from, to);
                attributeList.add(value);
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.getMessage());
        }
        return attributeList;
    }

    public static File findDeployDirectory(String aServiceName) throws Exception {
        if (aServiceName == null) {
            throw new Exception(CpmLocalizedMessage.getLocalizedMessage(CPM_LOG_RESOURCE_BUNDLE, "UIMA_CPM_EXP_service_not_defined__WARNING", new Object[]{Thread.currentThread().getName(), "NULL"}));
        }
        File[] dirList = CPMUtils.getDirectories();
        for (int i = 0; dirList != null && i < dirList.length; ++i) {
            String taeDescriptor = dirList[i].getAbsolutePath() + System.getProperty("file.separator") + "bin" + System.getProperty("file.separator") + "desc.xml";
            Descriptor descriptor = null;
            try {
                descriptor = new Descriptor(taeDescriptor);
                if (!aServiceName.equals(descriptor.getServiceName().trim())) continue;
                return dirList[i];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static File[] getDirectories() throws Exception {
        String appRoot;
        String rootPath = System.getProperty("CPM_HOME");
        File rootDir = new File(rootPath, appRoot = "annotators");
        if (!rootDir.isDirectory()) {
            throw new Exception(CpmLocalizedMessage.getLocalizedMessage(CPM_LOG_RESOURCE_BUNDLE, "UIMA_CPM_EXP_not_directory__WARNING", new Object[]{Thread.currentThread().getName(), appRoot}));
        }
        String[] list = rootDir.list();
        Vector<File> dirList = new Vector<File>();
        File aFile = null;
        for (int i = 0; i < list.length; ++i) {
            String currentFile = list[i];
            aFile = new File(rootDir.getAbsolutePath() + System.getProperty("file.separator") + currentFile);
            if (!aFile.isDirectory()) continue;
            dirList.add(aFile);
        }
        Object[] dirs = new File[dirList.size()];
        dirList.copyInto(dirs);
        return dirs;
    }

    public static int getFeatureAsInt(CAS aCas, Feature aFeature, String aName) throws Exception {
        Feature seqNo2 = aFeature.getRange().getFeatureByBaseName(aName);
        FeatureStructure documentMetaData = aCas.getView("_InitialView").getDocumentAnnotation().getFeatureValue(aFeature);
        return documentMetaData.getIntValue(seqNo2);
    }

    public static String getFeatureAsString(CAS aCas, Feature aFeature, String aName) throws Exception {
        Feature seqNo2 = aFeature.getRange().getFeatureByBaseName(aName);
        FeatureStructure documentMetaData = aCas.getView("_InitialView").getDocumentAnnotation().getFeatureValue(aFeature);
        return documentMetaData.getStringValue(seqNo2);
    }

    public static synchronized ChunkMetadata getChunkMetadata(CAS aCas) {
        block8: {
            Feature feat = aCas.getTypeSystem().getFeatureByFullName("uima.tcas.DocumentAnnotation:esDocumentMetaData");
            if (feat != null) {
                try {
                    int sequenceNo = CPMUtils.getFeatureAsInt(aCas, feat, "sequenceNumber");
                    int docId = CPMUtils.getFeatureAsInt(aCas, feat, "documentId");
                    int isCompleted = CPMUtils.getFeatureAsInt(aCas, feat, "isCompleted");
                    String throttleID = CPMUtils.getFeatureAsString(aCas, feat, "throttleID");
                    String url = CPMUtils.getFeatureAsString(aCas, feat, "url");
                    if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                        UIMAFramework.getLogger(CPMUtils.class).log(Level.FINEST, Thread.currentThread().getName() + "===========================>SeqNo::" + sequenceNo + " docId::" + docId + " isComplete::" + isCompleted + " ThrottleID:" + throttleID + " Document URL:" + url);
                    }
                    ChunkMetadata cm = new ChunkMetadata(String.valueOf(docId), sequenceNo, isCompleted == 1);
                    if (throttleID != null && throttleID.trim().length() > 0) {
                        cm.setThrottleID(throttleID);
                    }
                    if (url != null && url.trim().length() > 0) {
                        cm.setURL(url);
                    }
                    return cm;
                }
                catch (NullPointerException e) {
                    if (UIMAFramework.getLogger().isLoggable(Level.WARNING)) {
                        CPMException newE = new CPMException("Possible misconfiguration. CPM configured to use chunking but chunk metadata is not present in the CAS. Check if the CAS has been properly initialized by the CollectionReader.");
                        UIMAFramework.getLogger(CPMUtils.class).log(Level.WARNING, Thread.currentThread().getName(), newE);
                    }
                }
                catch (Exception e) {
                    if (!UIMAFramework.getLogger().isLoggable(Level.WARNING)) break block8;
                    UIMAFramework.getLogger(CPMUtils.class).log(Level.WARNING, Thread.currentThread().getName(), e);
                }
            }
        }
        return null;
    }
}

