/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples;

import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;

public class SofaExampleAnnotator
extends CasAnnotator_ImplBase {
    static char[] wThis = new char[]{'t', 'h', 'i', 's'};
    static char[] wBeer = new char[]{'b', 'e', 'e', 'r'};
    static char[] wIs = new char[]{'i', 's'};

    public void process(CAS aCas) throws AnalysisEngineProcessException {
        CAS englishView = aCas.getView("EnglishDocument");
        CAS germanView = aCas.createView("GermanDocument");
        Type annot = englishView.getAnnotationType();
        Type cross = englishView.getTypeSystem().getType("sofa.test.CrossAnnotation");
        Feature other = cross.getFeatureByBaseName("otherAnnotation");
        String engText = englishView.getDocumentText();
        int engEnd = 0;
        int germBegin = 0;
        int germEnd = 0;
        StringBuffer translation = new StringBuffer();
        StringTokenizer st = new StringTokenizer(engText);
        while (st.hasMoreTokens()) {
            String thisTok = st.nextToken();
            int engBegin = engText.indexOf(thisTok, engEnd);
            engEnd = engBegin + thisTok.length();
            AnnotationFS engAnnot = englishView.createAnnotation(annot, engBegin, engEnd);
            englishView.addFsToIndexes(engAnnot);
            String germWord = this.translate(thisTok);
            if (germBegin > 0) {
                translation.append(' ');
                ++germBegin;
            }
            translation.append(germWord);
            germEnd = germBegin + germWord.length();
            AnnotationFS germAnnot = germanView.createAnnotation(cross, germBegin, germEnd);
            germanView.addFsToIndexes(germAnnot);
            germAnnot.setFeatureValue(other, engAnnot);
            germBegin = germEnd;
        }
        germanView.setDocumentText(translation.toString());
    }

    private String translate(String word) {
        String lword = word.toLowerCase();
        if (Arrays.equals(wThis, lword.toCharArray())) {
            return new String("das");
        }
        if (Arrays.equals(wBeer, lword.toCharArray())) {
            return new String("bier");
        }
        if (Arrays.equals(wIs, lword.toCharArray())) {
            return new String("ist");
        }
        return new String("gut");
    }
}

