/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.cas;

import java.util.Arrays;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class PersonTitleAnnotator
extends CasAnnotator_ImplBase {
    private Type mPersonTitleType;
    private Type mContainingType;
    private Feature mPersonTitleKindFeature;
    private String[] mCivilianTitles;
    private String[] mMilitaryTitles;
    private String[] mGovernmentTitles;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.mCivilianTitles = (String[])this.getContext().getConfigParameterValue("CivilianTitles");
        this.mMilitaryTitles = (String[])this.getContext().getConfigParameterValue("MilitaryTitles");
        this.mGovernmentTitles = (String[])this.getContext().getConfigParameterValue("GovernmentTitles");
        Logger logger = this.getContext().getLogger();
        logger.log(Level.CONFIG, "PersonTitleAnnotator initialized");
        logger.log(Level.CONFIG, "CivilianTitles = " + Arrays.asList(this.mCivilianTitles));
        logger.log(Level.CONFIG, "MilitaryTitles = " + Arrays.asList(this.mMilitaryTitles));
        logger.log(Level.CONFIG, "GovernmentTitles = " + Arrays.asList(this.mGovernmentTitles));
    }

    public void typeSystemInit(TypeSystem aTypeSystem) throws AnalysisEngineProcessException {
        this.mPersonTitleType = aTypeSystem.getType("example.PersonTitle");
        if (this.mPersonTitleType == null) {
            throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{this.getClass().getName(), "example.PersonTitle"});
        }
        this.mPersonTitleKindFeature = this.mPersonTitleType.getFeatureByBaseName("Kind");
        if (this.mPersonTitleKindFeature == null) {
            throw new AnalysisEngineProcessException("annotator_ex_feature_not_found", new Object[]{this.getClass().getName(), "example.PersonTitle:Kind"});
        }
        String containingTypeName = (String)this.getContext().getConfigParameterValue("ContainingAnnotationType");
        if (containingTypeName != null) {
            this.mContainingType = aTypeSystem.getType(containingTypeName);
            if (this.mContainingType == null) {
                throw new AnalysisEngineProcessException("annotator_ex_type_not_found", new Object[]{this.getClass().getName(), containingTypeName});
            }
        }
    }

    public void process(CAS aCAS) throws AnalysisEngineProcessException {
        try {
            if (!this.getResultSpecification().containsType("example.PersonTitle", aCAS.getDocumentLanguage())) {
                return;
            }
            if (this.mContainingType == null) {
                String text = aCAS.getDocumentText();
                this.annotateRange(aCAS, text, 0);
            } else {
                FSIterator it = aCAS.getAnnotationIndex(this.mContainingType).iterator();
                while (it.isValid()) {
                    AnnotationFS annot = (AnnotationFS)it.get();
                    String coveredText = annot.getCoveredText();
                    int annotBegin = annot.getBegin();
                    this.annotateRange(aCAS, coveredText, annotBegin);
                    it.moveToNext();
                }
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    protected void annotateRange(CAS aCAS, String aText, int aBeginPos) {
        this.annotateRange(aCAS, aText, aBeginPos, "Civilian", this.mCivilianTitles);
        this.annotateRange(aCAS, aText, aBeginPos, "Military", this.mMilitaryTitles);
        this.annotateRange(aCAS, aText, aBeginPos, "Government", this.mGovernmentTitles);
    }

    protected void annotateRange(CAS aCAS, String aText, int aBeginPos, String aTitleType, String[] aTitles) {
        for (int i = 0; i < aTitles.length; ++i) {
            int start = aText.indexOf(aTitles[i]);
            while (start >= 0) {
                int end = start + aTitles[i].length();
                int absStart = aBeginPos + start;
                int absEnd = aBeginPos + end;
                this.getContext().getLogger().log(Level.FINER, "Found \"" + aTitles[i] + "\" at (" + absStart + "," + absEnd + ")");
                this.createAnnotation(aCAS, absStart, absEnd, aTitleType);
                start = aText.indexOf(aTitles[i], end);
            }
        }
    }

    protected void createAnnotation(CAS aCAS, int aBeginPos, int aEndPos, String aTitleType) {
        AnnotationFS title = aCAS.createAnnotation(this.mPersonTitleType, aBeginPos, aEndPos);
        if (this.getResultSpecification().containsFeature("example.PersonTitle:Kind", aCAS.getDocumentLanguage())) {
            title.setStringValue(this.mPersonTitleKindFeature, aTitleType);
        }
        aCAS.getIndexRepository().addFS(title);
    }
}

