/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.IOException;

public class BrowserUtil {
    private static int __osId;
    private static String __browserLauncher;
    private static final int WINDOWS_NT = 0;
    private static final int WINDOWS_9x = 1;
    private static final int LINUX = 2;
    private static final int OTHER = -1;
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String MOZILLA_REMOTE_PARAMETER = "-remote";
    private static final String MOZILLA_OPEN_PARAMETER_START = "openURL(";
    private static final String MOZILLA_OPEN_PARAMETER_END = ")";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";

    public static void main(String[] args) {
        String url = args.length > 0 ? args[0] : "http://apache.org";
        try {
            Process process = BrowserUtil.openUrlInDefaultBrowser(url);
            process.waitFor();
        }
        catch (Exception e) {
            System.err.println("Error in BrowserUtil.main():");
            e.printStackTrace(System.err);
        }
    }

    private BrowserUtil() {
    }

    public static Process openUrlInDefaultBrowser(String url) throws IOException {
        Process process = null;
        switch (__osId) {
            case 0: 
            case 1: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, '\"' + url + '\"'});
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case 2: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, "-remote", MOZILLA_OPEN_PARAMETER_START + url + MOZILLA_OPEN_PARAMETER_END});
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    process = Runtime.getRuntime().exec(new String[]{__browserLauncher, url});
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case -1: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, "-remote", NETSCAPE_OPEN_PARAMETER_START + url + NETSCAPE_OPEN_PARAMETER_END});
                try {
                    int exitCode = process.waitFor();
                    if (exitCode == 0) break;
                    Runtime.getRuntime().exec(new String[]{__browserLauncher, url});
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            default: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, url});
            }
        }
        return process;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            if (osName.indexOf("9") > -1) {
                __osId = 1;
                __browserLauncher = "command.com";
            } else {
                __osId = 0;
                __browserLauncher = "cmd.exe";
            }
        } else if (osName.startsWith("Linux")) {
            __osId = 2;
            __browserLauncher = "mozilla";
        } else {
            __osId = -1;
            __browserLauncher = "netscape";
        }
    }
}

