/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.util.ArrayList;
import org.apache.uima.internal.util.CharArrayString;

public class CharArraySpanMap {
    private static final int MIN_ARRAY_SIZE = 1024;
    private static final int MIN_MAP_SIZE = 5003;
    private char[] charArray;
    private int pos;
    private ArrayList[] map;

    public CharArraySpanMap() {
        this(1024);
    }

    public CharArraySpanMap(int initialArraySize) {
        this(initialArraySize, 5003);
    }

    public CharArraySpanMap(int initialArraySize, int initialMapSize) {
        if (initialArraySize < 1024) {
            initialArraySize = 1024;
        }
        if (initialMapSize < 5003) {
            initialMapSize = 5003;
        }
        this.charArray = new char[initialArraySize];
        this.map = new ArrayList[initialMapSize];
        for (int i = 0; i < initialMapSize; ++i) {
            this.map[i] = new ArrayList();
        }
        this.pos = 0;
    }

    private final int isInList(String s, ArrayList entryList) {
        int listLen = entryList.size();
        int strLen = s.length();
        boolean found = false;
        int i = 0;
        while (i < listLen) {
            Entry entry = (Entry)entryList.get(i);
            if (strLen != entry.length) {
                ++i;
                continue;
            }
            found = true;
            for (int j = 0; j < strLen; ++j) {
                if (s.charAt(j) == this.charArray[j + entry.start]) continue;
                found = false;
                break;
            }
            if (found) break;
            ++i;
        }
        return found ? i : -1;
    }

    private final int isInList(char[] inputArray, int start, int strLen, ArrayList entryList) {
        int listLen = entryList.size();
        boolean found = false;
        int i = 0;
        while (i < listLen) {
            Entry entry = (Entry)entryList.get(i);
            if (strLen != entry.length) {
                ++i;
                continue;
            }
            found = true;
            int k = entry.start;
            int max = start + strLen;
            for (int count = start; count < max; ++count) {
                if (inputArray[count] != this.charArray[k]) {
                    found = false;
                    break;
                }
                ++k;
            }
            if (found) break;
            ++i;
        }
        return found ? i : -1;
    }

    public void put(String s, Object value) {
        int hashCode = CharArrayString.hashCode(s);
        ArrayList list = this.map[hashCode % this.map.length];
        int listPos = this.isInList(s, list);
        if (listPos >= 0) {
            Entry entry = (Entry)list.get(listPos);
            entry.value = value;
            return;
        }
        int start = this.pos;
        this.addString(s);
        Entry entry = new Entry();
        entry.start = start;
        entry.length = this.pos - start;
        entry.value = value;
        list.add(entry);
    }

    public final boolean containsKey(char[] characterArray, int start, int length) {
        int hashCode = CharArrayString.hashCode(characterArray, start, start + length);
        ArrayList list = this.map[hashCode % this.map.length];
        int listPos = this.isInList(characterArray, start, length, list);
        return listPos >= 0;
    }

    public final Object get(char[] characterArray, int start, int length) {
        int hashCode = CharArrayString.hashCode(characterArray, start, start + length);
        ArrayList list = this.map[hashCode % this.map.length];
        int listPos = this.isInList(characterArray, start, length, list);
        return listPos >= 0 ? ((Entry)list.get(listPos)).value : null;
    }

    private final void addString(String s) {
        int newLength;
        int strLen = s.length();
        int newMinLength = this.pos + strLen;
        boolean needToCopy = false;
        for (newLength = this.charArray.length; newLength < newMinLength; newLength += 1024) {
            needToCopy = true;
        }
        if (needToCopy) {
            char[] newCharArray = new char[newLength];
            System.arraycopy(this.charArray, 0, newCharArray, 0, this.pos);
            this.charArray = newCharArray;
        }
        for (int i = 0; i < strLen; ++i) {
            this.charArray[this.pos] = s.charAt(i);
            ++this.pos;
        }
    }

    private static final class Entry {
        private int start = 0;
        private int length = 0;
        private Object value = null;

        private Entry() {
        }
    }
}

