/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class SymbolTable {
    private static final int DEFAULT_START = 0;
    private int start;
    private HashMap hashtable = new HashMap();
    private Vector symbols = new Vector();

    public SymbolTable(int start) {
        this.start = start;
    }

    public SymbolTable() {
        this(0);
    }

    public SymbolTable(String[] names) {
        this(0);
        for (int i = 0; i < names.length; ++i) {
            this.set(names[i]);
        }
    }

    public boolean contains(String symbol) {
        return this.getStart() <= this.get(symbol);
    }

    public int getStart() {
        return this.start;
    }

    public SymbolTable copy() {
        SymbolTable copy = new SymbolTable(this.start);
        int max = this.symbols.size();
        for (int i = 0; i < max; ++i) {
            copy.set((String)this.symbols.get(i));
        }
        return copy;
    }

    private final int rel2abs(int i) {
        return i - this.start;
    }

    private final int abs2rel(int i) {
        return i + this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(String symbol) {
        int rel;
        if (this.hashtable.containsKey(symbol)) {
            return (Integer)this.hashtable.get(symbol);
        }
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            int abs = this.hashtable.size();
            rel = this.abs2rel(abs);
            this.hashtable.put(symbol, rel);
            this.symbols.insertElementAt(symbol, abs);
        }
        return rel;
    }

    public int get(String symbol) {
        if (this.hashtable.containsKey(symbol)) {
            return (Integer)this.hashtable.get(symbol);
        }
        return this.start - 1;
    }

    public String getSymbol(int i) {
        int abs = this.rel2abs(i);
        if (abs < 0 || abs >= this.symbols.size()) {
            return null;
        }
        return (String)this.symbols.get(abs);
    }

    public int size() {
        return this.symbols.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        int max = this.getStart() + this.size();
        for (int i = this.getStart(); i < max; ++i) {
            buf.append(i + ":" + this.getSymbol(i));
            if (i + 1 >= max) continue;
            buf.append(", ");
        }
        buf.append(" }");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SymbolTable readFromFile(String filename) throws IOException {
        File stf = new File(filename);
        FileReader fr = null;
        BufferedReader in = null;
        try {
            String word;
            fr = new FileReader(stf);
            in = new BufferedReader(fr);
            SymbolTable st = new SymbolTable();
            while ((word = in.readLine()) != null) {
                if (word.equals("")) continue;
                st.set(word);
            }
            SymbolTable symbolTable = st;
            return symbolTable;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

