/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.uima.pear.util.StringUtil;
import org.apache.uima.pear.util.XMLUtil;

public class FileUtil {
    public static int cleanUpDirectoryContent(File directory) throws IOException {
        int counter = 0;
        File[] allDirFiles = directory.listFiles();
        if (allDirFiles != null) {
            for (int i = 0; i < allDirFiles.length; ++i) {
                File aFile = allDirFiles[i];
                if (aFile.isDirectory()) {
                    counter += FileUtil.cleanUpDirectoryContent(aFile);
                    if (aFile.delete()) {
                        ++counter;
                        continue;
                    }
                    aFile.deleteOnExit();
                    continue;
                }
                if (!aFile.isFile()) continue;
                if (aFile.delete()) {
                    ++counter;
                    continue;
                }
                aFile.deleteOnExit();
            }
        }
        return counter;
    }

    public static int cleanUpDirectoryFiles(File directory) throws IOException {
        int counter = 0;
        File[] allDirFiles = directory.listFiles();
        if (allDirFiles != null) {
            for (int i = 0; i < allDirFiles.length; ++i) {
                File aFile = allDirFiles[i];
                if (!aFile.isFile()) continue;
                if (aFile.delete()) {
                    ++counter;
                    continue;
                }
                aFile.deleteOnExit();
            }
        }
        return counter;
    }

    public static int cleanUpDirectoryFiles(File directory, int maxLimit) throws IOException {
        int counter = 0;
        Collection fileList = FileUtil.createFileList(directory, false);
        SortedSet sortedFileSet = FileUtil.sortFileListByTime(fileList);
        if (sortedFileSet.size() > maxLimit) {
            Iterator list = sortedFileSet.iterator();
            int no = 0;
            while (list.hasNext()) {
                File file = (File)list.next();
                if (++no <= maxLimit) continue;
                if (file.delete()) {
                    ++counter;
                    continue;
                }
                file.deleteOnExit();
            }
        }
        return counter;
    }

    public static String computeRelativePath(File referenceDir, File file) throws IOException {
        String refPath = referenceDir.getCanonicalPath().replace('\\', '/');
        String filePath = file.getCanonicalPath().replace('\\', '/');
        StringBuffer relBuffer = new StringBuffer();
        while (refPath != null && !filePath.startsWith(refPath)) {
            relBuffer.append("../");
            if ((refPath = new File(refPath).getParent()) == null) continue;
            refPath = refPath.replace('\\', '/');
        }
        if (refPath != null) {
            String subPath = filePath.substring(refPath.length());
            if (relBuffer.length() == 0) {
                relBuffer.append("./");
            }
            if (subPath.startsWith("/")) {
                relBuffer.append(subPath.substring(1));
            } else {
                relBuffer.append(subPath);
            }
            return relBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File source, File destination) throws IOException {
        boolean completed = false;
        BufferedInputStream iStream = null;
        FilterOutputStream oStream = null;
        try {
            iStream = new BufferedInputStream(new FileInputStream(source));
            oStream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] block = new byte[4096];
            int bCount = 0;
            while ((bCount = iStream.read(block)) > 0) {
                ((BufferedOutputStream)oStream).write(block, 0, bCount);
            }
            iStream.close();
            oStream.close();
            completed = true;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (Exception e) {}
            }
        }
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(URL sourceUrl, File destination) throws IOException {
        boolean completed = false;
        BufferedInputStream iStream = null;
        FilterOutputStream oStream = null;
        try {
            iStream = new BufferedInputStream(sourceUrl.openStream());
            oStream = new BufferedOutputStream(new FileOutputStream(destination));
            byte[] block = new byte[4096];
            int bCount = 0;
            while ((bCount = iStream.read(block)) > 0) {
                ((BufferedOutputStream)oStream).write(block, 0, bCount);
            }
            iStream.close();
            oStream.close();
            completed = true;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (Exception e) {}
            }
        }
        return completed;
    }

    public static Collection createDirList(File rootDir) throws IOException {
        return FileUtil.createDirList(rootDir, true);
    }

    public static Collection createDirList(File rootDir, boolean includeSubdirs) throws IOException {
        ArrayList<File> listOfDirs = new ArrayList<File>();
        File[] allDirFiles = rootDir.listFiles();
        if (allDirFiles == null) {
            throw new FileNotFoundException("invalid directory specified");
        }
        for (int i = 0; i < allDirFiles.length; ++i) {
            File aFile = allDirFiles[i];
            if (!aFile.isDirectory()) continue;
            listOfDirs.add(aFile);
            if (!includeSubdirs) continue;
            listOfDirs.addAll(FileUtil.createDirList(aFile, includeSubdirs));
        }
        return listOfDirs;
    }

    public static Collection createDirList(JarFile archive) throws IOException {
        ArrayList<File> listOfDirs = new ArrayList<File>();
        int nameEndIndex = archive.getName().lastIndexOf(46);
        String rootDirPath = nameEndIndex > 0 ? archive.getName().substring(0, nameEndIndex) : archive.getName();
        File rootDir = new File(rootDirPath);
        Enumeration<JarEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File file = new File(rootDir, entry.getName());
            if (entry.isDirectory()) {
                listOfDirs.add(file);
                continue;
            }
            File parentDir = file.getParentFile();
            while (!parentDir.equals(rootDir)) {
                if (!listOfDirs.contains(parentDir)) {
                    listOfDirs.add(parentDir);
                }
                parentDir = parentDir.getParentFile();
            }
        }
        return listOfDirs;
    }

    public static Collection createFileList(File filesDir) throws IOException {
        return FileUtil.createFileList(filesDir, true);
    }

    public static Collection createFileList(File filesDir, boolean includeSubdirs) throws IOException {
        ArrayList<File> listOfFiles = new ArrayList<File>();
        File[] allDirFiles = filesDir.listFiles();
        if (allDirFiles == null) {
            throw new FileNotFoundException("invalid directory specified");
        }
        for (int i = 0; i < allDirFiles.length; ++i) {
            File aFile = allDirFiles[i];
            if (aFile.isDirectory() && includeSubdirs) {
                listOfFiles.addAll(FileUtil.createFileList(aFile, includeSubdirs));
                continue;
            }
            if (aFile.isDirectory()) continue;
            listOfFiles.add(aFile);
        }
        return listOfFiles;
    }

    public static Collection createFileList(JarFile archive) throws IOException {
        ArrayList<File> listOfFiles = new ArrayList<File>();
        int nameEndIndex = archive.getName().lastIndexOf(46);
        String rootDirPath = nameEndIndex > 0 ? archive.getName().substring(0, nameEndIndex) : archive.getName();
        File rootDir = new File(rootDirPath);
        Enumeration<JarEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File file = new File(rootDir, entry.getName());
            if (entry.isDirectory()) continue;
            listOfFiles.add(file);
        }
        return listOfFiles;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        String tempDirPath = System.getProperty("java.io.tmpdir");
        if (tempDirPath == null) {
            tempDirPath = System.getProperty("user.home");
        }
        if (tempDirPath == null) {
            throw new IOException("could not find temporary directory");
        }
        File tempDir = new File(tempDirPath);
        if (!tempDir.isDirectory()) {
            throw new IOException("temporary directory not available");
        }
        return File.createTempFile(prefix, suffix, tempDir);
    }

    public static boolean deleteDirectory(File dir) throws IOException {
        boolean done = true;
        File[] fileList = dir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            File entry = fileList[i];
            if (entry.isDirectory()) {
                done = FileUtil.deleteDirectory(entry);
                continue;
            }
            if (entry.delete()) continue;
            entry.deleteOnExit();
            done = false;
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
            done = false;
        }
        return done;
    }

    public static long extractDirectoryFromJar(JarFile jarFile, String dirPath, File targetDir) throws IOException {
        return FileUtil.extractFilesFromJar(jarFile, targetDir, new DirFileFilter(dirPath, null));
    }

    public static long extractFilesWithExtFromJar(JarFile jarFile, String fileExt, File targetDir) throws IOException {
        return FileUtil.extractFilesFromJar(jarFile, targetDir, new DirFileFilter(null, fileExt));
    }

    public static long extractFilesFromJar(JarFile jarFile, File targetDir) throws IOException {
        return FileUtil.extractFilesFromJar(jarFile, targetDir, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long extractFilesFromJar(JarFile jarFile, File targetDir, FileFilter filter) throws IOException {
        long totalBytes = 0L;
        byte[] block = new byte[4096];
        Enumeration<JarEntry> jarList = jarFile.entries();
        while (jarList.hasMoreElements()) {
            JarEntry jarEntry = jarList.nextElement();
            if (jarEntry.isDirectory() || filter != null && !filter.accept(new File(jarEntry.getName()))) continue;
            File file = new File(targetDir, jarEntry.getName());
            File dir = file.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("could not create directory " + dir.getAbsolutePath());
            }
            BufferedInputStream iStream = null;
            FilterOutputStream oStream = null;
            try {
                iStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                oStream = new BufferedOutputStream(new FileOutputStream(file));
                int bCount = 0;
                while ((bCount = iStream.read(block)) > 0) {
                    totalBytes += (long)bCount;
                    ((BufferedOutputStream)oStream).write(block, 0, bCount);
                }
                iStream.close();
                oStream.close();
            }
            finally {
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (Exception e) {}
                }
                if (oStream == null) continue;
                try {
                    oStream.close();
                }
                catch (Exception e) {}
            }
        }
        return totalBytes;
    }

    public static String getAbsolutePath(File rootDir, String relativePath) {
        File object = new File(rootDir, relativePath);
        return object.getAbsolutePath();
    }

    public static String getFileNameExtension(String fileName) {
        StringBuffer buffer = new StringBuffer();
        int begIndex = fileName.lastIndexOf(46);
        if (begIndex > 0) {
            char ch;
            buffer.append('.');
            for (int i = begIndex + 1; i < fileName.length() && Character.isLetterOrDigit(ch = fileName.charAt(i)); ++i) {
                buffer.append(ch);
            }
        }
        return buffer.toString();
    }

    public static long getFileSize(String fileLocation) {
        long fileSize = 0L;
        File file = new File(fileLocation);
        if (file.isFile()) {
            fileSize = file.length();
        } else {
            try {
                URL fileUrl = new URL(fileLocation);
                URLConnection urlConn = fileUrl.openConnection();
                fileSize = urlConn.getContentLength();
            }
            catch (IOException e) {
                fileSize = -1L;
            }
        }
        return fileSize;
    }

    public static String getRelativePath(File rootDir, String absolutePath) {
        String rootDirPath = rootDir.getAbsolutePath().replace('\\', '/');
        String objectPath = absolutePath.replace('\\', '/');
        if (objectPath.startsWith(rootDirPath)) {
            objectPath = objectPath.substring(rootDirPath.length());
        }
        if (objectPath.startsWith("/")) {
            objectPath = objectPath.substring(1);
        }
        return objectPath;
    }

    public static String identifyUtfSignature(int[] prefix, int length) {
        String utfSignature = null;
        if (length == 3) {
            if (prefix[0] == 239 && prefix[1] == 187 && prefix[2] == 191) {
                utfSignature = "UTF-8";
            }
        } else if (length == 2) {
            if (prefix[0] == 254 && prefix[1] == 255) {
                utfSignature = "UTF-16BE";
            } else if (prefix[0] == 255 && prefix[1] == 254) {
                utfSignature = "UTF-16LE";
            }
        } else if (length == 4) {
            if (prefix[0] == 0 && prefix[1] == 0 && prefix[2] == 254 && prefix[3] == 255) {
                utfSignature = "UTF-32BE";
            } else if (prefix[0] == 255 && prefix[1] == 254 && prefix[2] == 0 && prefix[3] == 0) {
                utfSignature = "UTF-32LE";
            }
        }
        return utfSignature;
    }

    public static boolean isAsciiFile(File textFile) throws IOException {
        boolean isAscii = true;
        FileInputStream iStream = null;
        try {
            iStream = new FileInputStream(textFile);
            isAscii = FileUtil.isAsciiStream(iStream);
            iStream.close();
        }
        catch (IOException exc) {
            isAscii = false;
            throw exc;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
        return isAscii;
    }

    public static boolean isAsciiStream(InputStream iStream) throws IOException {
        boolean isAscii = true;
        try {
            int nextByte = 0;
            while ((nextByte = iStream.read()) >= 0) {
                if (nextByte <= 127) continue;
                isAscii = false;
                break;
            }
        }
        catch (IOException exc) {
            isAscii = false;
            throw exc;
        }
        return isAscii;
    }

    public static String[] loadListOfStrings(BufferedReader iStream) throws IOException {
        String[] outputArray = null;
        ArrayList<String> outputList = new ArrayList<String>();
        String line = null;
        while ((line = iStream.readLine()) != null) {
            String string = line.trim();
            if (string.length() <= 0) continue;
            outputList.add(string);
        }
        if (outputList.size() > 0) {
            outputArray = new String[outputList.size()];
            outputList.toArray(outputArray);
        }
        return outputArray != null ? outputArray : new String[]{};
    }

    public static String[] loadListOfStrings(File textFile) throws IOException {
        BufferedReader iStream = null;
        String[] outputArray = null;
        try {
            iStream = new BufferedReader(new InputStreamReader(new FileInputStream(textFile)));
            outputArray = FileUtil.loadListOfStrings(iStream);
        }
        catch (IOException exc) {
            throw exc;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
        return outputArray != null ? outputArray : new String[]{};
    }

    public static String[] loadListOfStrings(URL textFileURL) throws IOException {
        URLConnection urlConnection = textFileURL.openConnection();
        BufferedReader iStream = null;
        String[] outputArray = null;
        try {
            iStream = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            outputArray = FileUtil.loadListOfStrings(iStream);
        }
        catch (IOException exc) {
            throw exc;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
        return outputArray != null ? outputArray : new String[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromJar(String propFilePath, JarFile jarFile) throws IOException {
        Properties properties = null;
        String name = propFilePath.replace('\\', '/');
        JarEntry jarEntry = jarFile.getJarEntry(name);
        if (jarEntry != null) {
            InputStream iStream = null;
            try {
                iStream = jarFile.getInputStream(jarEntry);
                properties = new Properties();
                properties.load(iStream);
            }
            finally {
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return properties;
    }

    public static String loadTextFile(BufferedReader iStream) throws IOException {
        StringWriter buffer = null;
        PrintWriter writer = null;
        try {
            buffer = new StringWriter();
            writer = new PrintWriter(buffer);
            String line = null;
            while ((line = iStream.readLine()) != null) {
                writer.println(line);
            }
            writer.flush();
        }
        catch (IOException exc) {
            throw exc;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {}
            }
        }
        return buffer.toString();
    }

    public static String loadTextFile(File textFile) throws IOException {
        BufferedReader iStream = null;
        String content = null;
        try {
            iStream = new BufferedReader(new FileReader(textFile));
            content = FileUtil.loadTextFile(iStream);
        }
        catch (IOException exc) {
            throw exc;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
        return content;
    }

    public static String loadTextFile(File textFile, String encoding) throws IOException {
        BufferedReader iStream = null;
        String content = null;
        try {
            iStream = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(textFile), encoding));
            content = FileUtil.loadTextFile(iStream);
        }
        catch (IOException exc) {
            throw exc;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
        return content;
    }

    public static String loadTextFile(URL textFileURL) throws IOException {
        URLConnection urlConnection = textFileURL.openConnection();
        return FileUtil.loadTextFile(urlConnection);
    }

    public static String loadTextFile(URLConnection urlConnection) throws IOException {
        BufferedReader iStream = null;
        String content = null;
        try {
            iStream = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            content = FileUtil.loadTextFile(iStream);
        }
        catch (IOException exc) {
            throw exc;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadTextFileFromJar(String filePath, JarFile jarFile) throws IOException {
        String content = null;
        String name = filePath.replace('\\', '/');
        JarEntry jarEntry = jarFile.getJarEntry(name);
        if (jarEntry != null) {
            BufferedReader iStream = null;
            try {
                iStream = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));
                content = FileUtil.loadTextFile(iStream);
            }
            finally {
                if (iStream != null) {
                    try {
                        iStream.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return content;
    }

    public static String localPathToFileUrl(String path) {
        File file = new File(path);
        String absPath = file.getAbsolutePath().replace('\\', '/');
        StringBuffer urlBuffer = new StringBuffer("file:///");
        urlBuffer.append(absPath.replace(':', '|'));
        String fileUrlString = urlBuffer.toString().replaceAll(" ", "%20");
        URL fileUrl = null;
        try {
            fileUrl = new URL(fileUrlString);
        }
        catch (MalformedURLException e) {
            fileUrl = null;
        }
        return fileUrl != null ? fileUrl.toExternalForm() : fileUrlString;
    }

    public static boolean moveFile(File source, File destinationDir) throws IOException {
        boolean completed = false;
        File destination = new File(destinationDir, source.getName());
        if (destination.exists()) {
            destination.delete();
        }
        if (FileUtil.copyFile(source, destination)) {
            completed = source.delete();
        }
        return completed;
    }

    public static int replaceStringInFile(File textFile, String subStringRegex, String replacement) throws IOException {
        String fileExt;
        int counter = 0;
        String encoding = "ASCII";
        int extIndex = textFile.getName().lastIndexOf(46);
        String string = fileExt = extIndex > 0 ? textFile.getName().substring(extIndex) : null;
        if (".xml".equalsIgnoreCase(fileExt)) {
            String xmlEncoding = XMLUtil.detectXmlFileEncoding(textFile);
            if (xmlEncoding != null) {
                encoding = xmlEncoding;
            } else {
                throw new UnsupportedEncodingException("can't detect encoding in " + textFile.getAbsolutePath());
            }
        }
        String fileContent = FileUtil.loadTextFile(textFile, encoding);
        BufferedReader sReader = null;
        PrintStream fStream = null;
        boolean done = false;
        File backupFile = null;
        Pattern pattern = Pattern.compile(subStringRegex);
        String replaceWith = StringUtil.toRegExpReplacement(replacement);
        try {
            backupFile = new File(textFile.getAbsolutePath() + ".bak");
            if (backupFile.exists()) {
                backupFile.delete();
            }
            if (!textFile.renameTo(backupFile)) {
                throw new IOException("can't save backup copy of " + textFile.getAbsolutePath());
            }
            sReader = new BufferedReader(new StringReader(fileContent));
            fStream = new PrintStream((OutputStream)new FileOutputStream(textFile), true, encoding);
            String srcLine = null;
            while ((srcLine = sReader.readLine()) != null) {
                Matcher matcher = pattern.matcher(srcLine);
                while (matcher.find()) {
                    ++counter;
                }
                String resLine = srcLine.replaceAll(subStringRegex, replaceWith);
                fStream.println(resLine);
            }
            fStream.close();
            done = true;
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Throwable err) {
            if (err instanceof IOException) {
                throw new IOException(err.toString() + " in " + textFile.getAbsolutePath());
            }
            throw new RuntimeException(err.toString() + " in " + textFile.getAbsolutePath());
        }
        finally {
            if (sReader != null) {
                try {
                    sReader.close();
                }
                catch (Exception e) {}
            }
            if (fStream != null) {
                try {
                    fStream.close();
                }
                catch (Exception e) {}
            }
            if (done) {
                backupFile.delete();
            } else {
                textFile.delete();
                backupFile.renameTo(textFile);
            }
        }
        return counter;
    }

    public static SortedSet sortFileListByTime(Collection fileList) {
        TreeSet set = new TreeSet(new FileTimeComparator());
        set.addAll(fileList);
        return set;
    }

    public static File zipDirectory(File dir2zip) throws IOException {
        String zipFileName = dir2zip.getName() + ".zip";
        File zipFile = new File(dir2zip, zipFileName);
        return FileUtil.zipDirectory(dir2zip, zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zipDirectory(File dir2zip, File zippedFile) throws IOException {
        ZipOutputStream zoStream = null;
        try {
            zoStream = new ZipOutputStream(new FileOutputStream(zippedFile));
            File[] excludeFiles = new File[]{zippedFile};
            FileUtil.zipDirectory(dir2zip, zoStream, dir2zip, excludeFiles);
        }
        finally {
            if (zoStream != null) {
                try {
                    zoStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return zippedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipOutputStream zipDirectory(File dir2zip, ZipOutputStream zoStream, File referenceDir, File[] excludeFiles) throws IOException {
        byte[] block = new byte[4096];
        int inBytes = 0;
        FileInputStream iStream = null;
        try {
            File[] dirFileList = dir2zip.listFiles();
            for (int i = 0; i < dirFileList.length; ++i) {
                File entry = dirFileList[i];
                boolean isExcluded = false;
                for (int n = 0; n < excludeFiles.length; ++n) {
                    if (!entry.equals(excludeFiles[n])) continue;
                    isExcluded = true;
                    break;
                }
                if (isExcluded) continue;
                if (entry.isFile()) {
                    iStream = new FileInputStream(entry);
                    String zipEntryName = referenceDir != null ? FileUtil.getRelativePath(referenceDir, entry.getAbsolutePath()) : FileUtil.getRelativePath(dir2zip, entry.getAbsolutePath());
                    ZipEntry zipEntry = new ZipEntry(zipEntryName);
                    zoStream.putNextEntry(zipEntry);
                    while ((inBytes = iStream.read(block)) > 0) {
                        zoStream.write(block, 0, inBytes);
                    }
                    iStream.close();
                    continue;
                }
                if (!entry.isDirectory()) continue;
                FileUtil.zipDirectory(entry, zoStream, referenceDir, excludeFiles);
            }
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
        }
        return zoStream;
    }

    public static File zipFile(File file2zip) throws IOException {
        String zipFileName = file2zip.getName();
        int extIndex = zipFileName.lastIndexOf(46);
        zipFileName = extIndex >= 0 ? zipFileName.substring(0, extIndex) + ".zip" : zipFileName + ".zip";
        File zipFile = new File(file2zip.getParentFile(), zipFileName);
        return FileUtil.zipFile(file2zip, zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zipFile(File file2zip, File zippedFile) throws IOException {
        byte[] block = new byte[4096];
        int inBytes = 0;
        FileInputStream iStream = null;
        ZipOutputStream oStream = null;
        try {
            iStream = new FileInputStream(file2zip);
            ZipEntry zipEntry = new ZipEntry(file2zip.getName());
            oStream = new ZipOutputStream(new FileOutputStream(zippedFile));
            oStream.putNextEntry(zipEntry);
            while ((inBytes = iStream.read(block)) > 0) {
                oStream.write(block, 0, inBytes);
            }
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (Exception e) {}
            }
            if (oStream != null) {
                try {
                    oStream.close();
                }
                catch (Exception e) {}
            }
        }
        return zippedFile;
    }

    public static class ExtFilenameFilter
    implements FilenameFilter {
        private String _fileExt;
        private boolean _ignoreCase;

        public ExtFilenameFilter(String fileExt) {
            this(fileExt, true);
        }

        public ExtFilenameFilter(String fileExt, boolean ignoreCase) {
            this._fileExt = fileExt.startsWith(".") ? fileExt : "." + fileExt;
            this._ignoreCase = ignoreCase;
            if (ignoreCase) {
                this._fileExt = this._fileExt.toLowerCase();
            }
        }

        public boolean accept(File dir, String name) {
            String fileName = this._ignoreCase ? name.toLowerCase() : name;
            return fileName.endsWith(this._fileExt);
        }
    }

    public static class NameFileFilter
    implements FileFilter {
        private String _fileName;

        public NameFileFilter(String fileName) {
            this._fileName = fileName.replace('\\', '/');
        }

        public boolean accept(File file) {
            String filePath = file.getAbsolutePath().replace('\\', '/');
            if (filePath.endsWith(this._fileName)) {
                if (filePath.length() > this._fileName.length()) {
                    char prevChar = filePath.charAt(filePath.length() - this._fileName.length() - 1);
                    if (prevChar == ':' || prevChar == '/') {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
    }

    public static class DirFileFilter
    implements FileFilter {
        private String _dirPath;
        private String _fileExt;

        public DirFileFilter(String dirPath, String fileExt) {
            String string = this._dirPath = dirPath != null ? dirPath.replace('\\', '/') : null;
            this._fileExt = fileExt != null ? (fileExt.startsWith(".") ? fileExt.toLowerCase() : "." + fileExt.toLowerCase()) : null;
        }

        public boolean accept(File file) {
            boolean dirAccepted = true;
            boolean extAccepted = true;
            if (this._dirPath != null) {
                String parentDir = file.getParent();
                boolean bl = dirAccepted = parentDir != null && parentDir.replace('\\', '/').startsWith(this._dirPath);
            }
            if (this._fileExt != null) {
                extAccepted = file.getPath().toLowerCase().endsWith(this._fileExt);
            }
            return dirAccepted && extAccepted;
        }
    }

    public static class FileTimeComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            long t2;
            if (!(o1 instanceof File) || !(o2 instanceof File)) {
                throw new ClassCastException("invalid object type");
            }
            long t1 = ((File)o1).lastModified();
            return t1 >= (t2 = ((File)o2).lastModified()) ? -1 : 1;
        }

        public boolean equals(Object obj) {
            return obj instanceof FileTimeComparator;
        }
    }
}

