/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.apache.uima.resource.ConfigurableDataResourceSpecifier;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.RelativePathResolver;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.Resource_ImplBase;
import org.apache.uima.resource.impl.RelativePathResolver_impl;

public class ConfigurableDataResource_impl
extends Resource_ImplBase
implements DataResource {
    private URI mUri;
    private URL mFileUrl;

    public boolean initialize(ResourceSpecifier aSpecifier, Map aAdditionalParams) throws ResourceInitializationException {
        if (!(aSpecifier instanceof ConfigurableDataResourceSpecifier)) {
            return false;
        }
        ConfigurableDataResourceSpecifier spec = (ConfigurableDataResourceSpecifier)aSpecifier;
        try {
            this.mUri = new URI(spec.getUrl());
        }
        catch (URISyntaxException e) {
            throw new ResourceInitializationException(e);
        }
        this.setMetaData(spec.getMetaData());
        RelativePathResolver relPathResolver = null;
        if (aAdditionalParams != null) {
            relPathResolver = (RelativePathResolver)aAdditionalParams.get("RELATIVE_PATH_RESOLVER");
        }
        if (relPathResolver == null) {
            relPathResolver = new RelativePathResolver_impl();
        }
        try {
            this.mFileUrl = relPathResolver.resolveRelativePath(new URL(this.mUri.toString()));
        }
        catch (IOException e) {
            // empty catch block
        }
        return true;
    }

    public void destroy() {
    }

    public InputStream getInputStream() throws IOException {
        return this.mFileUrl.openStream();
    }

    public URI getUri() {
        return this.mUri;
    }

    public URL getUrl() {
        return this.mFileUrl;
    }

    protected File getLocalCache() {
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigurableDataResource_impl)) {
            return false;
        }
        URI uri = ((ConfigurableDataResource_impl)obj).getUri();
        if (uri == null || !uri.equals(this.getUri())) {
            return false;
        }
        File localCache = ((ConfigurableDataResource_impl)obj).getLocalCache();
        if (localCache == null && this.getLocalCache() != null) {
            return false;
        }
        return localCache == null || localCache.equals(this.getLocalCache());
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.mUri != null) {
            hashCode += this.mUri.hashCode();
        }
        return hashCode;
    }
}

