/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.impl.Import_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class FsIndexCollection_impl
extends MetaDataObject_impl
implements FsIndexCollection {
    private static final long serialVersionUID = -7687383527183197102L;
    private String mName;
    private String mVersion;
    private String mDescription;
    private String mVendor;
    private Import[] mImports;
    private FsIndexDescription[] mFsIndexes = new FsIndexDescription[0];
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("fsIndexCollection", new PropertyXmlInfo[]{new PropertyXmlInfo("name", true), new PropertyXmlInfo("description", true), new PropertyXmlInfo("version", true), new PropertyXmlInfo("vendor", true), new PropertyXmlInfo("imports", true), new PropertyXmlInfo("fsIndexes", "fsIndexes")});

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public void setVersion(String aVersion) {
        this.mVersion = aVersion;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String aDescription) {
        this.mDescription = aDescription;
    }

    public String getVendor() {
        return this.mVendor;
    }

    public void setVendor(String aVendor) {
        this.mVendor = aVendor;
    }

    public Import[] getImports() {
        if (this.mImports == null) {
            this.mImports = new Import[0];
        }
        return this.mImports;
    }

    public void setImports(Import[] aImports) {
        if (aImports == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aImports", "setImports"});
        }
        this.mImports = aImports;
    }

    public FsIndexDescription[] getFsIndexes() {
        if (this.mFsIndexes == null) {
            this.mFsIndexes = new FsIndexDescription[0];
        }
        return this.mFsIndexes;
    }

    public void setFsIndexes(FsIndexDescription[] aFSIndexes) {
        if (aFSIndexes == null) {
            throw new UIMA_IllegalArgumentException("illegal_argument", new Object[]{"null", "aFSIndexes", "setImports"});
        }
        this.mFsIndexes = aFSIndexes;
    }

    public void addFsIndex(FsIndexDescription aFsIndexDescription) {
        FsIndexDescription[] current = this.getFsIndexes();
        FsIndexDescription[] newArr = new FsIndexDescription[current.length + 1];
        System.arraycopy(current, 0, newArr, 0, current.length);
        newArr[current.length] = aFsIndexDescription;
        this.setFsIndexes(newArr);
    }

    public void removeFsIndex(FsIndexDescription aFsIndexDescription) {
        FsIndexDescription[] current = this.getFsIndexes();
        for (int i = 0; i < current.length; ++i) {
            if (current[i] != aFsIndexDescription) continue;
            FsIndexDescription[] newArr = new FsIndexDescription[current.length - 1];
            System.arraycopy(current, 0, newArr, 0, i);
            System.arraycopy(current, i + 1, newArr, i, current.length - i - 1);
            this.setFsIndexes(newArr);
            break;
        }
    }

    public void resolveImports() throws InvalidXMLException {
        this.resolveImports(new TreeSet(), UIMAFramework.newDefaultResourceManager());
    }

    public void resolveImports(ResourceManager aResourceManager) throws InvalidXMLException {
        this.resolveImports(new TreeSet(), aResourceManager);
    }

    public void resolveImports(Collection aAlreadyImportedFsIndexURLs, ResourceManager aResourceManager) throws InvalidXMLException {
        if (this.getSourceUrl() != null) {
            aAlreadyImportedFsIndexURLs.add(this.getSourceUrl().toString());
        }
        ArrayList importedIndexes = new ArrayList();
        Import[] imports = this.getImports();
        for (int i = 0; i < imports.length; ++i) {
            URL url;
            if (imports[i] instanceof Import_impl) {
                ((Import_impl)imports[i]).setSourceUrlIfNull(this.getSourceUrl());
            }
            if (aAlreadyImportedFsIndexURLs.contains((url = imports[i].findAbsoluteUrl(aResourceManager)).toString())) continue;
            aAlreadyImportedFsIndexURLs.add(url.toString());
            try {
                this.resolveImport(url, aAlreadyImportedFsIndexURLs, importedIndexes, aResourceManager);
                continue;
            }
            catch (IOException e) {
                throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{url, imports[i].getSourceUrlString()}, e);
            }
        }
        FsIndexDescription[] existingIndexes = this.getFsIndexes();
        if (existingIndexes == null) {
            existingIndexes = new FsIndexDescription[]{};
        }
        FsIndexDescription[] newIndexes = new FsIndexDescription[existingIndexes.length + importedIndexes.size()];
        System.arraycopy(existingIndexes, 0, newIndexes, 0, existingIndexes.length);
        for (int i = 0; i < importedIndexes.size(); ++i) {
            newIndexes[existingIndexes.length + i] = (FsIndexDescription)importedIndexes.get(i);
        }
        this.setFsIndexes(newIndexes);
        this.setImports(new Import[0]);
    }

    private void resolveImport(URL aURL, Collection aAlreadyImportedFsIndexCollectionURLs, Collection aResults, ResourceManager aResourceManager) throws InvalidXMLException, IOException {
        XMLInputSource input = new XMLInputSource(aURL);
        FsIndexCollection desc = UIMAFramework.getXMLParser().parseFsIndexCollection(input);
        desc.resolveImports(aAlreadyImportedFsIndexCollectionURLs, aResourceManager);
        aResults.addAll(Arrays.asList(desc.getFsIndexes()));
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }
}

