/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cpm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CasInitializerDescription;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCasProcessors;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer;
import org.apache.uima.collection.metadata.CpeCollectionReaderIterator;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeIntegratedCasProcessor;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.tools.cpm.AnalysisEnginePanel;
import org.apache.uima.tools.cpm.ConfigField;
import org.apache.uima.tools.cpm.ConsumerPanel;
import org.apache.uima.tools.cpm.JTabbedPaneWithCloseIcons;
import org.apache.uima.tools.cpm.MetaDataPanel;
import org.apache.uima.tools.cpm.PerformanceReportDialog;
import org.apache.uima.tools.cpm.TabClosedListener;
import org.apache.uima.tools.util.gui.FileChooserBugWorkarounds;
import org.apache.uima.tools.util.gui.FileSelector;
import org.apache.uima.tools.util.gui.FileSelectorListener;
import org.apache.uima.tools.util.gui.SwingWorker;
import org.apache.uima.tools.util.gui.TransportControlListener;
import org.apache.uima.tools.util.gui.TransportControlPanel;
import org.apache.uima.tools.util.gui.XMLFileFilter;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.XMLInputSource;

public class CpmPanel
extends JPanel
implements ActionListener,
FileSelectorListener,
TabClosedListener,
TransportControlListener {
    private static final long serialVersionUID = -5096300176103368922L;
    public static final String HELP_MESSAGE = "Instructions for using UIMA Collection Processing Engine Configurator:\n\nSelect a Collection Reader descriptor using the Browse button in the topmost panel.\n\nOn the Analyis Engines panel and the CAS Consumers panel, use the Add button to select Analysis Engine (AE) \nand CAS Consumer descriptors.\n\nPress the Play button to start collection processing.\nA progress bar in the lower left corner of the window will indicate the processing progress.\nWhen running, you may use the Pause or Stop button to pause or stop the processing.\n\nThe File menu contains options for opening and saving CPE descriptors.\n\nThe View menu contains an option to display the CAS Initializer panel.  CAS Initializers are deprecated \nsince UIMA version 2.0, but are still supported by this tool.";
    private static final String PREFS_CPE_DESCRIPTOR_FILE = "cpeDescriptorFile";
    private static final String PREFS_SAVE_USING_IMPORTS = "saveUsingImports";
    private JMenuItem openCpeDescMenuItem;
    private JMenuItem saveCpeDescMenuItem;
    private JMenuItem refreshMenuItem;
    private JMenuItem clearAllMenuItem;
    private JSplitPane mainSplitPane;
    private JSplitPane readerInitializerSplitPane;
    private ResetableMetaDataPanel collectionReaderPanel;
    private TitledBorder collectionReaderTitledBorder;
    private ResetableMetaDataPanel casInitializerPanel;
    private TitledBorder casInitializerTitledBorder;
    private FileSelector readerFileSelector;
    private FileSelector casInitializerFileSelector;
    private JPanel aeMainPanel;
    private JTabbedPaneWithCloseIcons aeTabbedPane;
    private JButton moveAeRightButton;
    private JButton moveAeLeftButton;
    private JButton addAeButton;
    private TitledBorder aeTitledBorder;
    private JPanel consumersPanel;
    private TitledBorder consumerTitledBorder;
    private JButton addConsumerButton;
    private JButton moveConsumerRightButton;
    private JButton moveConsumerLeftButton;
    private JTabbedPaneWithCloseIcons consumerTabbedPane;
    private Vector aeSpecifiers = new Vector();
    private Vector consumerSpecifiers = new Vector();
    private JProgressBar progressBar;
    private TransportControlPanel transportControlPanel;
    private AbstractButton startButton;
    private AbstractButton stopButton;
    private JLabel statusLabel;
    private Timer progressTimer;
    private int elapsedTime;
    private Timer performanceQueryTimer;
    private CollectionReaderDescription collectionReaderDesc;
    private CasInitializerDescription casInitializerDesc;
    private CollectionProcessingEngine mCPE;
    private boolean indeterminateProgressPause;
    private JFileChooser aeFileChooser;
    private JFileChooser consumerFileChooser;
    private JFileChooser openSaveFileChooser;
    private File fileChooserRootDir;
    private long collectionReaderLastFileSyncTimestamp;
    private long casInitializerLastFileSyncTimestamp;
    private long lastFileSyncUserPromptTime;
    private Preferences prefs = Preferences.userRoot().node("org/apache/uima/tools/CPE_GUI");
    private boolean mShuttingDown;
    private boolean mPaused;
    private boolean selectedComponentsChanged = false;
    private JMenuItem viewCasInitializerPanelMenuItem;
    private CpeDescription currentCpeDesc = this.createEmptyCpeDescription();
    private final ResourceManager defaultResourceManager = UIMAFramework.newDefaultResourceManager();
    private boolean saveUsingImports = true;
    private JCheckBoxMenuItem saveUsingImportMenuItem;

    public CpmPanel() {
        String fileChooserRootDirPath = System.getProperty("uima.file_chooser_root");
        if (fileChooserRootDirPath == null) {
            fileChooserRootDirPath = System.getProperty("user.dir");
        }
        this.fileChooserRootDir = new File(fileChooserRootDirPath);
        this.setLayout(new BorderLayout());
        this.mainSplitPane = new JSplitPane(0);
        this.mainSplitPane.setResizeWeight(0.25);
        JSplitPane bottomSplitPane = new JSplitPane(0);
        bottomSplitPane.setResizeWeight(0.5);
        this.mainSplitPane.setBottomComponent(bottomSplitPane);
        this.readerInitializerSplitPane = new JSplitPane(1);
        this.readerInitializerSplitPane.setResizeWeight(0.5);
        this.collectionReaderPanel = new ResetableMetaDataPanel(2);
        Border bevelBorder = BorderFactory.createRaisedBevelBorder();
        this.collectionReaderTitledBorder = BorderFactory.createTitledBorder(bevelBorder, "Collection Reader");
        this.collectionReaderPanel.setBorder(this.collectionReaderTitledBorder);
        JScrollPane collectionReaderScrollPane = new JScrollPane(this.collectionReaderPanel);
        this.readerInitializerSplitPane.setLeftComponent(collectionReaderScrollPane);
        this.casInitializerPanel = new ResetableMetaDataPanel(2);
        bevelBorder = BorderFactory.createRaisedBevelBorder();
        this.casInitializerTitledBorder = BorderFactory.createTitledBorder(bevelBorder, "CAS Initializer");
        this.casInitializerPanel.setBorder(this.casInitializerTitledBorder);
        this.readerInitializerSplitPane.setRightComponent(this.casInitializerPanel);
        this.mainSplitPane.setTopComponent(this.readerInitializerSplitPane);
        this.aeMainPanel = new JPanel();
        this.aeMainPanel.setLayout(new BorderLayout());
        this.aeTitledBorder = BorderFactory.createTitledBorder(bevelBorder, "Analysis Engines");
        this.aeMainPanel.setBorder(this.aeTitledBorder);
        this.addAeButton = new JButton("Add...");
        this.addAeButton.addActionListener(this);
        this.moveAeLeftButton = new JButton("<<");
        this.moveAeLeftButton.addActionListener(this);
        this.moveAeRightButton = new JButton(">>");
        this.moveAeRightButton.addActionListener(this);
        JPanel addAePanel = new JPanel();
        addAePanel.setLayout(new FlowLayout(0));
        addAePanel.add(this.addAeButton);
        addAePanel.add(this.moveAeLeftButton);
        addAePanel.add(this.moveAeRightButton);
        this.aeMainPanel.add((Component)addAePanel, "North");
        this.aeTabbedPane = new JTabbedPaneWithCloseIcons();
        this.aeTabbedPane.addTabClosedListener(this);
        this.aeMainPanel.add((Component)this.aeTabbedPane, "Center");
        JScrollPane aeScrollPane = new JScrollPane(this.aeMainPanel);
        bottomSplitPane.setTopComponent(aeScrollPane);
        this.consumersPanel = new JPanel();
        this.consumersPanel.setLayout(new BorderLayout());
        this.consumerTitledBorder = BorderFactory.createTitledBorder(bevelBorder, "CAS Consumers");
        this.consumersPanel.setBorder(this.consumerTitledBorder);
        this.addConsumerButton = new JButton("Add...");
        this.addConsumerButton.addActionListener(this);
        this.moveConsumerLeftButton = new JButton("<<");
        this.moveConsumerLeftButton.addActionListener(this);
        this.moveConsumerRightButton = new JButton(">>");
        this.moveConsumerRightButton.addActionListener(this);
        JPanel addConsumerPanel = new JPanel();
        addConsumerPanel.setLayout(new FlowLayout(0));
        addConsumerPanel.add(this.addConsumerButton);
        addConsumerPanel.add(this.moveConsumerLeftButton);
        addConsumerPanel.add(this.moveConsumerRightButton);
        this.consumersPanel.add((Component)addConsumerPanel, "North");
        this.consumerTabbedPane = new JTabbedPaneWithCloseIcons();
        this.consumerTabbedPane.addTabClosedListener(this);
        this.consumersPanel.add((Component)this.consumerTabbedPane, "Center");
        JScrollPane consumerScrollPane = new JScrollPane(this.consumersPanel);
        bottomSplitPane.setBottomComponent(consumerScrollPane);
        this.add((Component)this.mainSplitPane, "Center");
        JPanel southernPanel = new JPanel();
        southernPanel.setLayout(new BorderLayout());
        JPanel southernCentralPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 3;
        gbc.gridy = 0;
        gbc.insets = new Insets(4, 4, 4, 4);
        southernCentralPanel.setLayout(gbl);
        this.progressBar = new JProgressBar();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        southernCentralPanel.add((Component)this.progressBar, gbc);
        this.transportControlPanel = new TransportControlPanel(this);
        this.transportControlPanel.setButtonTooltipText(0, "Run Collection Processing");
        this.transportControlPanel.setButtonTooltipText(1, "Pause Collection Processing");
        this.transportControlPanel.setButtonTooltipText(2, "Stop Collection Processing");
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 10;
        southernCentralPanel.add((Component)this.transportControlPanel, gbc);
        southernPanel.add((Component)southernCentralPanel, "Center");
        this.statusLabel = new JLabel("Initialized", 2);
        southernPanel.add((Component)this.statusLabel, "South");
        this.startButton = this.transportControlPanel.getButton(0);
        this.startButton.addActionListener(this);
        this.stopButton = this.transportControlPanel.getButton(2);
        this.stopButton.addActionListener(this);
        this.add((Component)southernPanel, "South");
        this.progressTimer = new Timer(1000, this);
        this.performanceQueryTimer = new Timer(2000, this);
        this.initFileChoosers();
        this.readerFileSelector = new FileSelector(null, "Collection Reader Descriptor", 0, this.fileChooserRootDir, new XMLFileFilter());
        this.readerFileSelector.addFileSelectorListener(this, this.collectionReaderPanel);
        this.casInitializerFileSelector = new FileSelector(null, "CAS Initializer Descriptor", 0, this.fileChooserRootDir, new XMLFileFilter());
        this.casInitializerFileSelector.addFileSelectorListener(this, this.casInitializerPanel);
        try {
            this.populateCollectionReaderPanel(null);
            this.populateCasInitializerPanel(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setCasInitializerPanelVisible(false);
        if (System.getProperty("uima.noprefs") == null) {
            this.readPreferences();
        }
    }

    private void initFileChoosers() {
        this.aeFileChooser = new JFileChooser(this.fileChooserRootDir);
        this.aeFileChooser.setDialogTitle("Add Analysis Engine");
        this.aeFileChooser.setFileSelectionMode(0);
        this.aeFileChooser.addChoosableFileFilter(new XMLFileFilter());
        File aeDescDir = this.fileChooserRootDir;
        if (this.aeSpecifiers.size() > 0) {
            File lastAeFile = new File((String)this.aeSpecifiers.get(this.aeSpecifiers.size() - 1));
            aeDescDir = lastAeFile.getParentFile();
        }
        if (aeDescDir.exists()) {
            FileChooserBugWorkarounds.setCurrentDirectory(this.aeFileChooser, aeDescDir);
        }
        this.consumerFileChooser = new JFileChooser(this.fileChooserRootDir);
        this.consumerFileChooser.setDialogTitle("Add CAS Consumer");
        this.consumerFileChooser.setFileSelectionMode(0);
        this.consumerFileChooser.addChoosableFileFilter(new XMLFileFilter());
        File consumerDescDir = this.fileChooserRootDir;
        if (this.consumerSpecifiers.size() > 0) {
            File lastConsumerFile = new File((String)this.consumerSpecifiers.get(this.consumerSpecifiers.size() - 1));
            consumerDescDir = lastConsumerFile.getParentFile();
        }
        if (consumerDescDir.exists()) {
            FileChooserBugWorkarounds.setCurrentDirectory(this.consumerFileChooser, consumerDescDir);
        }
        this.openSaveFileChooser = new JFileChooser(this.fileChooserRootDir);
        this.openSaveFileChooser.setFileFilter(new XMLFileFilter());
    }

    private Frame getParentFrame() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof Frame); parent = parent.getParent()) {
        }
        return (Frame)parent;
    }

    public List createFileMenuItems() {
        ArrayList<JMenuItem> menuItemList = new ArrayList<JMenuItem>();
        this.openCpeDescMenuItem = new JMenuItem("Open CPE Descriptor");
        this.openCpeDescMenuItem.addActionListener(this);
        menuItemList.add(this.openCpeDescMenuItem);
        this.saveCpeDescMenuItem = new JMenuItem("Save CPE Descriptor");
        this.saveCpeDescMenuItem.addActionListener(this);
        menuItemList.add(this.saveCpeDescMenuItem);
        this.refreshMenuItem = new JMenuItem("Refresh Descriptors from File System");
        this.refreshMenuItem.addActionListener(this);
        menuItemList.add(this.refreshMenuItem);
        JMenu saveOptionsSubmenu = new JMenu("Save Options");
        this.saveUsingImportMenuItem = new JCheckBoxMenuItem("Use <import>");
        this.saveUsingImportMenuItem.addActionListener(this);
        this.saveUsingImportMenuItem.setSelected(this.saveUsingImports);
        saveOptionsSubmenu.add(this.saveUsingImportMenuItem);
        menuItemList.add(saveOptionsSubmenu);
        this.clearAllMenuItem = new JMenuItem("Clear All");
        this.clearAllMenuItem.addActionListener(this);
        menuItemList.add(this.clearAllMenuItem);
        return menuItemList;
    }

    public List createViewMenuItems() {
        ArrayList<JMenuItem> menuItemList = new ArrayList<JMenuItem>();
        this.viewCasInitializerPanelMenuItem = new JCheckBoxMenuItem("CAS Initializer Panel");
        this.viewCasInitializerPanelMenuItem.setSelected(this.casInitializerPanel.isVisible());
        this.viewCasInitializerPanelMenuItem.addActionListener(this);
        menuItemList.add(this.viewCasInitializerPanelMenuItem);
        return menuItemList;
    }

    private void setCasInitializerPanelVisible(boolean visible) {
        this.casInitializerPanel.setVisible(visible);
        if (this.viewCasInitializerPanelMenuItem != null) {
            this.viewCasInitializerPanelMenuItem.setSelected(visible);
        }
        if (visible) {
            this.readerInitializerSplitPane.setDividerLocation(0.5);
        }
    }

    private void readPreferences() {
        File cpeDescFile;
        String cpeDescFileString = this.prefs.get(PREFS_CPE_DESCRIPTOR_FILE, null);
        if (cpeDescFileString != null && (cpeDescFile = new File(cpeDescFileString)).exists()) {
            this.openSaveFileChooser.setSelectedFile(cpeDescFile);
            try {
                this.openCpeDescriptor(cpeDescFile);
            }
            catch (Exception e) {
                System.err.println("Error loading last known CPE Descriptor " + cpeDescFileString);
                e.printStackTrace();
            }
        }
        String saveUsingImportsString = this.prefs.get(PREFS_SAVE_USING_IMPORTS, "true");
        this.setSaveUsingImports("true".equalsIgnoreCase(saveUsingImportsString));
    }

    private void setSaveUsingImports(boolean b) {
        this.saveUsingImports = b;
        if (this.saveUsingImportMenuItem != null) {
            this.saveUsingImportMenuItem.setSelected(b);
        }
        this.prefs.put(PREFS_SAVE_USING_IMPORTS, Boolean.toString(b));
    }

    private void startProcessing() {
        if (this.collectionReaderDesc == null) {
            JOptionPane.showMessageDialog(this, "No Collection Reader has been selected", "Error", 0);
            this.transportControlPanel.reset();
            this.resetScreen();
            return;
        }
        try {
            this.updateCpeDescriptionParameterOverrides();
            this.mCPE = null;
            this.mCPE = UIMAFramework.produceCollectionProcessingEngine(this.currentCpeDesc);
            StatusCallbackListenerImpl statCbL = new StatusCallbackListenerImpl();
            this.mCPE.addStatusCallbackListener(statCbL);
            this.mCPE.process();
        }
        catch (Exception ex) {
            this.resetScreen();
            this.displayError(ex);
        }
    }

    private void updateCpeDescriptionParameterOverrides() throws Exception {
        CasProcessorConfigurationParameterSettings settings;
        CpeCasProcessor casProc;
        int i;
        this.checkForOutOfSyncFiles();
        if (this.readerFileSelector.getSelected().length() > 0) {
            if (this.collectionReaderPanel.isModified()) {
                CasProcessorConfigurationParameterSettings crSettings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                this.currentCpeDesc.getAllCollectionCollectionReaders()[0].setConfigurationParameterSettings(crSettings);
                this.createParameterOverrides(crSettings, this.collectionReaderPanel);
            } else {
                this.currentCpeDesc.getAllCollectionCollectionReaders()[0].setConfigurationParameterSettings(null);
            }
        }
        if (this.casInitializerFileSelector.getSelected().length() > 0) {
            if (this.casInitializerPanel.isModified()) {
                CasProcessorConfigurationParameterSettings casIniSettings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                this.currentCpeDesc.getAllCollectionCollectionReaders()[0].getCasInitializer().setConfigurationParameterSettings(casIniSettings);
                this.createParameterOverrides(casIniSettings, this.casInitializerPanel);
            } else {
                this.currentCpeDesc.getAllCollectionCollectionReaders()[0].getCasInitializer().setConfigurationParameterSettings(null);
            }
        }
        for (i = 0; i < this.aeSpecifiers.size(); ++i) {
            casProc = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(i);
            AnalysisEnginePanel aePanel = (AnalysisEnginePanel)this.aeTabbedPane.getComponentAt(i);
            if (aePanel.isModified()) {
                settings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                casProc.setConfigurationParameterSettings(settings);
                this.createParameterOverrides(settings, aePanel);
                continue;
            }
            casProc.setConfigurationParameterSettings(null);
        }
        for (i = 0; i < this.consumerSpecifiers.size(); ++i) {
            casProc = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(this.aeSpecifiers.size() + i);
            ConsumerPanel consumerPanel = (ConsumerPanel)this.consumerTabbedPane.getComponentAt(i);
            if (consumerPanel.isModified()) {
                settings = CpeDescriptorFactory.produceCasProcessorConfigurationParameterSettings();
                casProc.setConfigurationParameterSettings(settings);
                this.createParameterOverrides(settings, consumerPanel);
                continue;
            }
            casProc.setConfigurationParameterSettings(null);
        }
    }

    private void createParameterOverrides(CasProcessorConfigurationParameterSettings aSettings, MetaDataPanel aPanel) throws CpeDescriptorException {
        List values = aPanel.getValues();
        for (ConfigField configField : values) {
            if (!configField.isModified()) continue;
            String name = configField.getParameterName();
            Object value = configField.getFieldValue();
            if (value == null) continue;
            aSettings.setParameterValue(name, value);
        }
    }

    private void clearDirty() {
        int i;
        this.collectionReaderPanel.clearDirty();
        this.casInitializerPanel.clearDirty();
        for (i = 0; i < this.aeTabbedPane.getTabCount(); ++i) {
            ((MetaDataPanel)this.aeTabbedPane.getComponentAt(i)).clearDirty();
        }
        for (i = 0; i < this.consumerTabbedPane.getTabCount(); ++i) {
            ((MetaDataPanel)this.consumerTabbedPane.getComponentAt(i)).clearDirty();
        }
        this.selectedComponentsChanged = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.progressTimer) {
            ++this.elapsedTime;
            this.displayProgress();
        } else if (source != this.performanceQueryTimer || this.mCPE == null) {
            if (source == this.startButton) {
                this.statusLabel.setText("Initializing");
                this.progressBar.setValue(0);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        CpmPanel.this.startProcessing();
                        return null;
                    }
                };
                worker.start();
            } else if (source == this.addAeButton) {
                int rv = this.aeFileChooser.showOpenDialog(this.addAeButton);
                if (rv == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    File file = this.aeFileChooser.getSelectedFile();
                    try {
                        this.addAE(file.getPath());
                    }
                    catch (Exception e) {
                        this.displayError(e);
                    }
                    int lastTabIndex = this.aeTabbedPane.getTabCount() - 1;
                    this.aeTabbedPane.setSelectedIndex(lastTabIndex);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            } else if (source == this.moveAeLeftButton) {
                int index = this.aeTabbedPane.getSelectedIndex();
                if (index > 0) {
                    try {
                        CpeCasProcessor casProcToMove = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(index);
                        this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(index);
                        this.currentCpeDesc.getCpeCasProcessors().addCpeCasProcessor(casProcToMove, index - 1);
                    }
                    catch (CpeDescriptorException e) {
                        this.displayError(e);
                        return;
                    }
                    this.aeTabbedPane.moveTab(index, index - 1);
                    this.aeTabbedPane.setSelectedIndex(index - 1);
                    Object specifierToMove = this.aeSpecifiers.remove(index);
                    this.aeSpecifiers.add(index - 1, specifierToMove);
                }
            } else if (source == this.moveAeRightButton) {
                int index = this.aeTabbedPane.getSelectedIndex();
                if (index > -1 && index < this.aeTabbedPane.getTabCount() - 1) {
                    try {
                        CpeCasProcessor casProcToMove = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(index);
                        this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(index);
                        this.currentCpeDesc.getCpeCasProcessors().addCpeCasProcessor(casProcToMove, index + 1);
                    }
                    catch (CpeDescriptorException e) {
                        this.displayError(e);
                        return;
                    }
                    this.aeTabbedPane.moveTab(index, index + 1);
                    this.aeTabbedPane.setSelectedIndex(index + 1);
                    Object specifierToMove = this.aeSpecifiers.remove(index);
                    this.aeSpecifiers.add(index + 1, specifierToMove);
                }
            } else if (source == this.addConsumerButton) {
                int rv = this.consumerFileChooser.showOpenDialog(this.addConsumerButton);
                if (rv == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    File file = this.consumerFileChooser.getSelectedFile();
                    try {
                        this.addConsumer(file.getPath());
                    }
                    catch (Exception e) {
                        this.displayError(e);
                    }
                    int lastTabIndex = this.consumerTabbedPane.getTabCount() - 1;
                    this.consumerTabbedPane.setSelectedIndex(lastTabIndex);
                    this.setCursor(Cursor.getDefaultCursor());
                }
            } else if (source == this.moveConsumerLeftButton) {
                int index = this.consumerTabbedPane.getSelectedIndex();
                if (index > 0) {
                    try {
                        int absIndex = this.aeSpecifiers.size() + index;
                        CpeCasProcessor casProcToMove = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(absIndex);
                        this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(absIndex);
                        this.currentCpeDesc.getCpeCasProcessors().addCpeCasProcessor(casProcToMove, absIndex - 1);
                    }
                    catch (CpeDescriptorException e) {
                        this.displayError(e);
                        return;
                    }
                    this.consumerTabbedPane.moveTab(index, index - 1);
                    this.consumerTabbedPane.setSelectedIndex(index - 1);
                    Object specifierToMove = this.consumerSpecifiers.remove(index);
                    this.consumerSpecifiers.add(index - 1, specifierToMove);
                }
            } else if (source == this.moveConsumerRightButton) {
                int index = this.consumerTabbedPane.getSelectedIndex();
                if (index > -1 && index < this.consumerTabbedPane.getTabCount() - 1) {
                    try {
                        int absIndex = this.aeSpecifiers.size() + index;
                        CpeCasProcessor casProcToMove = this.currentCpeDesc.getCpeCasProcessors().getCpeCasProcessor(absIndex);
                        this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(absIndex);
                        this.currentCpeDesc.getCpeCasProcessors().addCpeCasProcessor(casProcToMove, absIndex + 1);
                    }
                    catch (CpeDescriptorException e) {
                        this.displayError(e);
                        return;
                    }
                    this.consumerTabbedPane.moveTab(index, index + 1);
                    this.consumerTabbedPane.setSelectedIndex(index + 1);
                    Object specifierToMove = this.consumerSpecifiers.remove(index);
                    this.consumerSpecifiers.add(index + 1, specifierToMove);
                }
            } else if (source == this.saveCpeDescMenuItem) {
                this.saveCpeDescriptor();
            } else if (source == this.openCpeDescMenuItem) {
                int returnVal = this.openSaveFileChooser.showOpenDialog(this);
                if (returnVal == 0) {
                    File f = this.openSaveFileChooser.getSelectedFile();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        this.openCpeDescriptor(f);
                    }
                    catch (Exception e) {
                        this.displayError(e);
                    }
                    finally {
                        this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            } else if (source == this.refreshMenuItem) {
                this.refreshOutOfSyncFiles();
            } else if (source == this.clearAllMenuItem) {
                this.clearAll();
            } else if (source == this.viewCasInitializerPanelMenuItem) {
                this.setCasInitializerPanelVisible(!this.casInitializerPanel.isVisible());
            } else if (source == this.saveUsingImportMenuItem) {
                this.setSaveUsingImports(!this.saveUsingImports);
            }
        }
    }

    private void clearAll() {
        this.currentCpeDesc = this.createEmptyCpeDescription();
        this.collectionReaderPanel.reset();
        this.readerFileSelector.setSelected("");
        this.casInitializerPanel.reset();
        this.casInitializerFileSelector.setSelected("");
        this.removeAllAEsAndConsumers();
        this.initFileChoosers();
        this.collectionReaderPanel.validate();
        this.casInitializerPanel.validate();
        this.aeMainPanel.validate();
        this.consumersPanel.validate();
    }

    private CpeDescription createEmptyCpeDescription() {
        CpeDescription cpeDesc = CpeDescriptorFactory.produceDescriptor();
        try {
            CpeCasProcessors cpeCasProcs = CpeDescriptorFactory.produceCasProcessors();
            cpeDesc.setCpeCasProcessors(cpeCasProcs);
            cpeCasProcs.setPoolSize(3);
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
        }
        return cpeDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCpeDescriptor() {
        int returnVal = this.openSaveFileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File f = this.openSaveFileChooser.getSelectedFile();
            if (this.openSaveFileChooser.getFileFilter() instanceof XMLFileFilter && f.getAbsolutePath().indexOf(46) == -1) {
                f = new File(f.getAbsolutePath() + ".xml");
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                this.doSaveCpeDescriptor(f);
                this.prefs.put(PREFS_CPE_DESCRIPTOR_FILE, f.getAbsolutePath());
            }
            catch (Exception e) {
                this.displayError(e);
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveCpeDescriptor(File aFile) throws Exception {
        this.updateCpeDescriptionParameterOverrides();
        if (this.saveUsingImports) {
            this.updateImports(aFile);
        }
        OutputStream out = null;
        try {
            File parentFile = aFile.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            out = new FileOutputStream(aFile);
            this.currentCpeDesc.toXML(out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        this.currentCpeDesc.setSourceUrl(aFile.toURI().toURL());
        this.clearDirty();
    }

    private void updateImports(File cpeDescSaveFile) throws Exception {
        CpeCollectionReader[] readers = this.currentCpeDesc.getAllCollectionCollectionReaders();
        if (readers != null) {
            for (int i = 0; i < readers.length; ++i) {
                this.updateImport(readers[i].getDescriptor(), cpeDescSaveFile);
                if (readers[i].getCasInitializer() == null) continue;
                this.updateImport(readers[i].getCasInitializer().getDescriptor(), cpeDescSaveFile);
            }
        }
        CpeCasProcessor[] casProcs = this.currentCpeDesc.getCpeCasProcessors().getAllCpeCasProcessors();
        for (int i = 0; i < casProcs.length; ++i) {
            this.updateImport(casProcs[i].getCpeComponentDescriptor(), cpeDescSaveFile);
        }
    }

    private void updateImport(CpeComponentDescriptor descriptor, File cpeDescSaveFile) throws Exception {
        File descFile;
        String relPath;
        if (descriptor.getImport() != null && descriptor.getImport().getName() != null) {
            return;
        }
        URL descUrl = descriptor.findAbsoluteUrl(this.defaultResourceManager);
        if ("file".equals(descUrl.getProtocol()) && (relPath = FileUtils.findRelativePath(descFile = this.urlToFile(descUrl), cpeDescSaveFile.getParentFile())) != null) {
            descriptor.setInclude(null);
            Import newImport = UIMAFramework.getResourceSpecifierFactory().createImport();
            newImport.setLocation(relPath);
            descriptor.setImport(newImport);
        }
    }

    private File urlToFile(URL url) throws URISyntaxException {
        String urlString = url.toString().replaceAll(" ", "%20");
        return new File(new URI(urlString));
    }

    private void displayProgress() {
        if (this.mCPE != null) {
            try {
                Progress[] progress = this.mCPE.getProgress();
                if (progress != null && progress.length > 0) {
                    int FILE_ENTITY_PROGRESS_INDEX = -1;
                    if (FILE_ENTITY_PROGRESS_INDEX == -1) {
                        for (int i = 0; i < progress.length; ++i) {
                            if (!progress[i].getUnit().equals("entities")) continue;
                            FILE_ENTITY_PROGRESS_INDEX = i;
                            break;
                        }
                    }
                    int value = (int)progress[FILE_ENTITY_PROGRESS_INDEX].getCompleted();
                    this.progressBar.setValue(value);
                    if (this.progressBar.isIndeterminate()) {
                        this.statusLabel.setText("Processed " + value);
                    } else {
                        this.statusLabel.setText("Processed " + value + " of " + this.progressBar.getMaximum());
                    }
                }
            }
            catch (Exception e) {
                this.displayError(e);
            }
        }
    }

    public boolean confirmExit() {
        int rv;
        this.mShuttingDown = true;
        if (this.mCPE != null && this.mCPE.isProcessing()) {
            rv = JOptionPane.showConfirmDialog(this, "Collection Processing is currently running.  Do you wish to abort?", "Exit", 0);
            if (rv == 1) {
                this.mShuttingDown = false;
                return false;
            }
            this.mCPE.stop();
            this.resetScreen();
        }
        try {
            if (this.isDirty()) {
                rv = JOptionPane.showConfirmDialog(this, "Configuration settings have been modified. Would you like to save the CPE descriptor?", "Exit", 1);
                if (rv == 2) {
                    this.mShuttingDown = false;
                    return false;
                }
                if (rv == 0) {
                    this.saveCpeDescriptor();
                }
            }
            return true;
        }
        catch (Exception e) {
            this.displayError(e);
            return true;
        }
    }

    public void checkForOutOfSyncFiles() {
        int i;
        File casInitializerSpecifierFile;
        File readerSpecifierFile;
        StringBuffer componentNames = new StringBuffer();
        if (this.collectionReaderDesc != null && (readerSpecifierFile = new File(this.readerFileSelector.getSelected())).lastModified() > this.collectionReaderLastFileSyncTimestamp && readerSpecifierFile.lastModified() > this.lastFileSyncUserPromptTime) {
            componentNames.append(this.collectionReaderDesc.getMetaData().getName()).append('\n');
        }
        if (this.casInitializerDesc != null && (casInitializerSpecifierFile = new File(this.casInitializerFileSelector.getSelected())).lastModified() > this.casInitializerLastFileSyncTimestamp && casInitializerSpecifierFile.lastModified() > this.lastFileSyncUserPromptTime) {
            componentNames.append(this.casInitializerDesc.getMetaData().getName()).append('\n');
        }
        int nrTabs = this.aeTabbedPane.getTabCount();
        for (i = 0; i < nrTabs; ++i) {
            AnalysisEnginePanel aePanel = (AnalysisEnginePanel)this.aeTabbedPane.getComponentAt(i);
            if (!aePanel.hasFileChanged(this.lastFileSyncUserPromptTime)) continue;
            componentNames.append(this.aeTabbedPane.getTitleAt(i)).append('\n');
        }
        nrTabs = this.consumerTabbedPane.getTabCount();
        for (i = 0; i < nrTabs; ++i) {
            ConsumerPanel consumerPanel = (ConsumerPanel)this.consumerTabbedPane.getComponentAt(i);
            if (!consumerPanel.hasFileChanged(this.lastFileSyncUserPromptTime)) continue;
            componentNames.append(this.consumerTabbedPane.getTitleAt(i)).append('\n');
        }
        if (componentNames.length() > 0) {
            int rv = JOptionPane.showConfirmDialog(this, "The following descriptor(s) have changed on the file system:\n" + componentNames.toString() + "\n\nDo you want to refresh them?", "Descriptors Changed On File System", 0);
            if (rv == 0) {
                this.refreshOutOfSyncFiles();
            }
            this.lastFileSyncUserPromptTime = System.currentTimeMillis();
        }
    }

    public void refreshOutOfSyncFiles() {
        int i;
        File casInitializerSpecifierFile;
        File readerSpecifierFile;
        if (this.collectionReaderDesc != null && (readerSpecifierFile = new File(this.readerFileSelector.getSelected())).lastModified() > this.collectionReaderLastFileSyncTimestamp) {
            try {
                this.populateCollectionReaderPanel(this.currentCpeDesc.getAllCollectionCollectionReaders()[0].getCollectionIterator());
            }
            catch (Exception e) {
                this.displayError(e);
            }
        }
        if (this.casInitializerDesc != null && (casInitializerSpecifierFile = new File(this.casInitializerFileSelector.getSelected())).lastModified() > this.casInitializerLastFileSyncTimestamp) {
            try {
                this.populateCasInitializerPanel(this.currentCpeDesc.getAllCollectionCollectionReaders()[0].getCasInitializer());
            }
            catch (Exception e) {
                this.displayError(e);
            }
        }
        int nrTabs = this.aeTabbedPane.getTabCount();
        for (i = 0; i < nrTabs; ++i) {
            AnalysisEnginePanel aePanel = (AnalysisEnginePanel)this.aeTabbedPane.getComponentAt(i);
            if (!aePanel.hasFileChanged(0L)) continue;
            try {
                aePanel.refreshFromFile();
                continue;
            }
            catch (Exception e) {
                this.displayError(e);
            }
        }
        nrTabs = this.consumerTabbedPane.getTabCount();
        for (i = 0; i < nrTabs; ++i) {
            ConsumerPanel consumerPanel = (ConsumerPanel)this.consumerTabbedPane.getComponentAt(i);
            if (!consumerPanel.hasFileChanged(0L)) continue;
            try {
                consumerPanel.refreshFromFile();
                continue;
            }
            catch (Exception e) {
                this.displayError(e);
            }
        }
    }

    public void displayError(String aErrorString) {
        StringBuffer buf = new StringBuffer(aErrorString.length());
        int CHARS_PER_LINE = 80;
        int charCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(aErrorString, " \n", true);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("\n")) {
                buf.append("\n");
                charCount = 0;
                continue;
            }
            if (charCount > 0 && charCount + tok.length() > 80) {
                buf.append("\n").append(tok);
                charCount = tok.length();
                continue;
            }
            buf.append(tok);
            charCount += tok.length();
        }
        JOptionPane.showMessageDialog(this, buf.toString(), "Error", 0);
    }

    public void displayError(Throwable aThrowable) {
        aThrowable.printStackTrace();
        String message = aThrowable.toString();
        while (aThrowable instanceof UIMAException || aThrowable instanceof UIMARuntimeException) {
            if (aThrowable instanceof UIMAException) {
                aThrowable = ((UIMAException)aThrowable).getCause();
            } else if (aThrowable instanceof UIMARuntimeException) {
                aThrowable = ((UIMARuntimeException)aThrowable).getCause();
            }
            if (aThrowable == null) continue;
            message = message + "\nCausedBy: " + aThrowable.toString();
        }
        this.displayError(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean populateCollectionReaderPanel(CpeCollectionReaderIterator cpeColRdr) throws InvalidXMLException, IOException, ResourceConfigurationException {
        try {
            URL specifierUrl = null;
            String specifierFile = null;
            if (cpeColRdr != null) {
                specifierUrl = cpeColRdr.getDescriptor().findAbsoluteUrl(this.defaultResourceManager);
                if (!"file".equals(specifierUrl.getProtocol())) {
                    this.displayError("Could not load descriptor from URL " + specifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
                    boolean bl = false;
                    return bl;
                }
                try {
                    specifierFile = this.urlToFile(specifierUrl).toString();
                }
                catch (URISyntaxException e) {
                    this.displayError(e);
                    boolean bl = false;
                    this.collectionReaderPanel.validate();
                    this.collectionReaderPanel.validate();
                    this.mainSplitPane.validate();
                    return bl;
                }
            }
            if (this.collectionReaderPanel.getNrComponents() == 0) {
                this.collectionReaderPanel.add(new JLabel("Descriptor:"));
                this.collectionReaderPanel.add(this.readerFileSelector);
                this.readerFileSelector.setSelected(specifierFile);
            } else {
                this.collectionReaderPanel.reset();
            }
            if (specifierFile == null || specifierFile.length() == 0) {
                this.collectionReaderDesc = null;
                boolean e = true;
                return e;
            }
            if (specifierFile != null && specifierFile.length() > 0) {
                File f = new File(specifierFile);
                if (!f.exists()) {
                    String errorMsg = "Descriptor file " + f.getAbsolutePath() + " does not exist";
                    JOptionPane.showMessageDialog(this, errorMsg, null, 0);
                    this.transportControlPanel.reset();
                    this.resetScreen();
                    boolean bl = false;
                    return bl;
                }
                this.collectionReaderLastFileSyncTimestamp = f.lastModified();
                XMLInputSource readerInputSource = new XMLInputSource(f);
                this.collectionReaderDesc = UIMAFramework.getXMLParser().parseCollectionReaderDescription(readerInputSource);
                this.collectionReaderPanel.populate(this.collectionReaderDesc.getMetaData(), cpeColRdr.getConfigurationParameterSettings());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.collectionReaderPanel.validate();
            this.collectionReaderPanel.validate();
            this.mainSplitPane.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean populateCasInitializerPanel(CpeCollectionReaderCasInitializer cpeCasIni) throws InvalidXMLException, IOException, ResourceConfigurationException {
        try {
            URL specifierUrl = null;
            String specifierFile = null;
            if (cpeCasIni != null) {
                specifierUrl = cpeCasIni.getDescriptor().findAbsoluteUrl(this.defaultResourceManager);
                if (!"file".equals(specifierUrl.getProtocol())) {
                    this.displayError("Could not load descriptor from URL " + specifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
                    boolean bl = false;
                    return bl;
                }
                try {
                    specifierFile = this.urlToFile(specifierUrl).toString();
                }
                catch (URISyntaxException e) {
                    this.displayError(e);
                    boolean bl = false;
                    this.casInitializerPanel.validate();
                    this.mainSplitPane.validate();
                    return bl;
                }
            }
            if (this.casInitializerPanel.getNrComponents() == 0) {
                this.casInitializerPanel.add(new JLabel("Descriptor:"));
                this.casInitializerPanel.add(this.casInitializerFileSelector);
                this.casInitializerFileSelector.setSelected(specifierFile);
            } else {
                this.casInitializerPanel.reset();
            }
            if (specifierFile == null || specifierFile.length() == 0) {
                this.casInitializerDesc = null;
                boolean e = true;
                return e;
            }
            this.setCasInitializerPanelVisible(true);
            File f = new File(specifierFile);
            if (!f.exists()) {
                String errorMsg = "Descriptor file " + f.getAbsolutePath() + " does not exist";
                JOptionPane.showMessageDialog(this, errorMsg, null, 0);
                this.transportControlPanel.reset();
                this.resetScreen();
                boolean bl = false;
                return bl;
            }
            this.casInitializerLastFileSyncTimestamp = f.lastModified();
            XMLInputSource casIniInputSource = new XMLInputSource(f);
            this.casInitializerDesc = UIMAFramework.getXMLParser().parseCasInitializerDescription(casIniInputSource);
            this.casInitializerPanel.populate(this.casInitializerDesc.getMetaData(), cpeCasIni.getConfigurationParameterSettings());
            boolean bl = true;
            return bl;
        }
        finally {
            this.casInitializerPanel.validate();
            this.mainSplitPane.validate();
        }
    }

    private void addAE(String aeSpecifierFile) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        String tempAeName = new File(aeSpecifierFile).getName();
        CpeIntegratedCasProcessor casProc = CpeDescriptorFactory.produceCasProcessor(tempAeName);
        casProc.setDescriptor(aeSpecifierFile);
        casProc.setBatchSize(10000);
        casProc.getErrorHandling().getErrorRateThreshold().setMaxErrorCount(0);
        this.currentCpeDesc.addCasProcessor(this.aeTabbedPane.getTabCount(), casProc);
        this.addAE(casProc);
    }

    private boolean addAE(CpeCasProcessor cpeCasProc) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        String tabName;
        File f;
        URL aeSpecifierUrl = cpeCasProc.getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
        if (!"file".equals(aeSpecifierUrl.getProtocol())) {
            this.displayError("Could not load descriptor from URL " + aeSpecifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
            return false;
        }
        try {
            f = this.urlToFile(aeSpecifierUrl);
        }
        catch (URISyntaxException e) {
            this.displayError(e);
            return false;
        }
        long fileModStamp = f.lastModified();
        XMLInputSource aeInputSource = new XMLInputSource(aeSpecifierUrl);
        ResourceSpecifier aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(aeInputSource);
        AnalysisEnginePanel aePanel = new AnalysisEnginePanel(aeSpecifier, f, fileModStamp);
        if (aeSpecifier instanceof AnalysisEngineDescription) {
            AnalysisEngineDescription aeDescription = (AnalysisEngineDescription)aeSpecifier;
            ResourceMetaData md = aeDescription.getMetaData();
            aePanel.populate(md, cpeCasProc.getConfigurationParameterSettings());
            tabName = md.getName();
        } else {
            tabName = f.getName();
        }
        tabName = this.makeUniqueCasProcessorName(tabName);
        cpeCasProc.setName(tabName);
        this.aeTabbedPane.addTab(tabName, aePanel);
        this.aeSpecifiers.add(f.getAbsolutePath());
        this.selectedComponentsChanged = true;
        return true;
    }

    private void addConsumer(String consumerSpecifierFile) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        String tempName = new File(consumerSpecifierFile).getName();
        CpeIntegratedCasProcessor casProc = CpeDescriptorFactory.produceCasProcessor(tempName);
        casProc.setDescriptor(consumerSpecifierFile);
        casProc.setBatchSize(10000);
        casProc.getErrorHandling().getErrorRateThreshold().setMaxErrorCount(0);
        this.currentCpeDesc.addCasProcessor(casProc);
        this.addConsumer(casProc);
    }

    private boolean addConsumer(CpeCasProcessor cpeCasProc) throws CpeDescriptorException, InvalidXMLException, IOException, ResourceConfigurationException {
        String tabName;
        File f;
        URL consumerSpecifierUrl = cpeCasProc.getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
        if (!"file".equals(consumerSpecifierUrl.getProtocol())) {
            this.displayError("Could not load descriptor from URL " + consumerSpecifierUrl.toString() + ".  CPE Configurator only supports file: URLs");
            return false;
        }
        try {
            f = this.urlToFile(consumerSpecifierUrl);
        }
        catch (URISyntaxException e) {
            this.displayError(e);
            return false;
        }
        long fileModStamp = f.lastModified();
        XMLInputSource consumerInputSource = new XMLInputSource(consumerSpecifierUrl);
        ResourceSpecifier casConsumerSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(consumerInputSource);
        ConsumerPanel consumerPanel = new ConsumerPanel(casConsumerSpecifier, f, fileModStamp);
        if (casConsumerSpecifier instanceof CasConsumerDescription) {
            ProcessingResourceMetaData md = ((CasConsumerDescription)casConsumerSpecifier).getCasConsumerMetaData();
            consumerPanel.populate(md, cpeCasProc.getConfigurationParameterSettings());
            tabName = md.getName();
        } else {
            tabName = f.getName();
        }
        tabName = this.makeUniqueCasProcessorName(tabName);
        cpeCasProc.setName(tabName);
        this.consumerTabbedPane.addTab(tabName, consumerPanel);
        this.consumerSpecifiers.add(f.getAbsolutePath());
        this.selectedComponentsChanged = true;
        return true;
    }

    private String makeUniqueCasProcessorName(String baseName) {
        if (this.aeTabbedPane.indexOfTab(baseName) == -1 && this.consumerTabbedPane.indexOfTab(baseName) == -1) {
            return baseName;
        }
        int num = 2;
        String name;
        while (this.aeTabbedPane.indexOfTab(name = baseName + " " + num) != -1 || this.consumerTabbedPane.indexOfTab(name) != -1) {
            ++num;
        }
        return name;
    }

    private void removeAllAEsAndConsumers() {
        this.aeTabbedPane.removeAll();
        this.aeSpecifiers.clear();
        this.consumerTabbedPane.removeAll();
        this.consumerSpecifiers.clear();
    }

    public boolean fileSelected(JComponent source, String fileString) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        boolean rv = false;
        try {
            if (source == this.collectionReaderPanel) {
                if (fileString != null && fileString.length() > 0) {
                    CpeCollectionReader[] readers = this.currentCpeDesc.getAllCollectionCollectionReaders();
                    if (readers.length == 0) {
                        this.currentCpeDesc.addCollectionReader(fileString);
                        readers = this.currentCpeDesc.getAllCollectionCollectionReaders();
                    } else {
                        readers[0].getCollectionIterator().getDescriptor().getInclude().set(fileString);
                        readers[0].getCollectionIterator().setConfigurationParameterSettings(null);
                    }
                    rv = this.populateCollectionReaderPanel(readers[0].getCollectionIterator());
                } else {
                    this.currentCpeDesc.setAllCollectionCollectionReaders(new CpeCollectionReader[0]);
                }
                this.selectedComponentsChanged = true;
            } else if (source == this.casInitializerPanel) {
                if (fileString != null && fileString.length() > 0) {
                    CpeCollectionReader[] readers = this.currentCpeDesc.getAllCollectionCollectionReaders();
                    if (readers.length == 0 || readers[0].getCasInitializer() == null) {
                        this.currentCpeDesc.addCasInitializer(fileString);
                        readers = this.currentCpeDesc.getAllCollectionCollectionReaders();
                    } else {
                        readers[0].getCasInitializer().getDescriptor().getInclude().set(fileString);
                        readers[0].getCasInitializer().setConfigurationParameterSettings(null);
                    }
                    rv = this.populateCasInitializerPanel(readers[0].getCasInitializer());
                } else {
                    CpeCollectionReader[] readers = this.currentCpeDesc.getAllCollectionCollectionReaders();
                    if (readers.length > 0) {
                        readers[0].removeCasInitializer();
                    }
                    rv = this.populateCasInitializerPanel(null);
                }
                this.selectedComponentsChanged = true;
            }
        }
        catch (Exception e) {
            this.displayError(e);
            rv = false;
        }
        this.setCursor(Cursor.getDefaultCursor());
        return rv;
    }

    public void tabClosed(JTabbedPaneWithCloseIcons source, int tabPos) {
        try {
            if (source == this.consumerTabbedPane) {
                this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(this.aeSpecifiers.size() + tabPos);
                this.consumerSpecifiers.remove(tabPos);
            } else if (source == this.aeTabbedPane) {
                this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(tabPos);
                this.aeSpecifiers.remove(tabPos);
            }
            this.selectedComponentsChanged = true;
        }
        catch (CpeDescriptorException e) {
            this.displayError(e);
        }
    }

    public void controlStarted() {
        this.statusLabel.setText("Initializing");
        this.progressBar.setIndeterminate(true);
        this.setFrameEnabled(false);
    }

    public void controlPaused() {
        this.mPaused = true;
        this.statusLabel.setText("Paused");
        this.indeterminateProgressPause = this.progressBar.isIndeterminate();
        if (this.indeterminateProgressPause) {
            this.progressBar.setIndeterminate(false);
        }
        if (!this.mCPE.isPaused()) {
            this.mCPE.pause();
        }
        this.progressTimer.stop();
        this.performanceQueryTimer.stop();
        PerformanceReportDialog perfReportDlg = new PerformanceReportDialog(this.getParentFrame());
        perfReportDlg.displayStats(this.mCPE.getPerformanceReport(), this.progressBar.getValue(), "Processing is paused.");
    }

    public void controlResumed() {
        this.mPaused = false;
        this.statusLabel.setText("Resumed");
        if (this.indeterminateProgressPause) {
            this.progressBar.setIndeterminate(true);
        }
        this.mCPE.resume();
        this.progressTimer.restart();
        this.performanceQueryTimer.restart();
    }

    public void controlStopped() {
        try {
            this.mCPE.stop();
        }
        catch (UIMA_IllegalStateException uIMA_IllegalStateException) {
            // empty catch block
        }
    }

    private void resetScreen() {
        this.progressTimer.stop();
        this.performanceQueryTimer.stop();
        this.transportControlPanel.reset();
        this.setFrameEnabled(true);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.elapsedTime = 0;
        this.statusLabel.setText("");
    }

    private void setFrameEnabled(boolean onOff) {
        int i;
        Color titleColor = onOff ? Color.black : Color.gray;
        this.readerInitializerSplitPane.setEnabled(onOff);
        this.collectionReaderPanel.setEnabled(onOff);
        this.collectionReaderTitledBorder.setTitleColor(titleColor);
        this.casInitializerPanel.setEnabled(onOff);
        this.casInitializerTitledBorder.setTitleColor(titleColor);
        this.aeMainPanel.setEnabled(onOff);
        this.addAeButton.setEnabled(onOff);
        this.moveAeRightButton.setEnabled(onOff);
        this.moveAeLeftButton.setEnabled(onOff);
        this.aeTitledBorder.setTitleColor(titleColor);
        this.aeTabbedPane.setEnabled(onOff);
        int nrTabs = this.aeTabbedPane.getTabCount();
        for (i = 0; i < nrTabs; ++i) {
            AnalysisEnginePanel aePanel = (AnalysisEnginePanel)this.aeTabbedPane.getComponentAt(i);
            aePanel.setEnabled(onOff);
        }
        this.consumersPanel.setEnabled(onOff);
        this.consumerTitledBorder.setTitleColor(titleColor);
        this.addConsumerButton.setEnabled(onOff);
        this.moveConsumerRightButton.setEnabled(onOff);
        this.moveConsumerLeftButton.setEnabled(onOff);
        this.consumerTabbedPane.setEnabled(onOff);
        nrTabs = this.consumerTabbedPane.getTabCount();
        for (i = 0; i < nrTabs; ++i) {
            ConsumerPanel consumerPanel = (ConsumerPanel)this.consumerTabbedPane.getComponentAt(i);
            consumerPanel.setEnabled(onOff);
        }
        if (this.openCpeDescMenuItem != null) {
            this.openCpeDescMenuItem.setEnabled(onOff);
        }
        if (this.saveCpeDescMenuItem != null) {
            this.saveCpeDescMenuItem.setEnabled(onOff);
        }
        if (this.refreshMenuItem != null) {
            this.refreshMenuItem.setEnabled(onOff);
        }
        if (this.clearAllMenuItem != null) {
            this.clearAllMenuItem.setEnabled(onOff);
        }
    }

    public void onCompletion() {
        try {
            this.setFrameEnabled(true);
            this.transportControlPanel.reset();
            this.displayProgress();
            this.progressBar.setIndeterminate(false);
            this.elapsedTime = 0;
            this.progressTimer.stop();
            this.performanceQueryTimer.stop();
            PerformanceReportDialog perfReportDlg = new PerformanceReportDialog(this.getParentFrame());
            perfReportDlg.displayStats(this.mCPE.getPerformanceReport(), this.progressBar.getValue(), "Processing completed successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void printStats() {
    }

    private boolean isDirty() {
        MetaDataPanel panel;
        int i;
        if (this.selectedComponentsChanged) {
            return true;
        }
        if (this.collectionReaderPanel.isDirty() || this.casInitializerPanel.isDirty()) {
            return true;
        }
        for (i = 0; i < this.aeTabbedPane.getTabCount(); ++i) {
            panel = (MetaDataPanel)this.aeTabbedPane.getComponentAt(i);
            if (!panel.isDirty()) continue;
            return true;
        }
        for (i = 0; i < this.consumerTabbedPane.getTabCount(); ++i) {
            panel = (MetaDataPanel)this.consumerTabbedPane.getComponentAt(i);
            if (!panel.isDirty()) continue;
            return true;
        }
        return false;
    }

    private void openCpeDescriptor(File aFile) throws InvalidXMLException, IOException, CpeDescriptorException, ResourceConfigurationException {
        this.currentCpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(aFile));
        CpeCollectionReader[] collRdrs = this.currentCpeDesc.getAllCollectionCollectionReaders();
        CpeCollectionReader collRdr = null;
        if (collRdrs != null && collRdrs.length > 0) {
            collRdr = collRdrs[0];
            this.collectionReaderPanel.clearAll();
            this.populateCollectionReaderPanel(collRdr.getCollectionIterator());
        } else {
            this.collectionReaderPanel.reset();
        }
        CpeCollectionReaderCasInitializer casIni = null;
        if (collRdr != null) {
            casIni = collRdr.getCasInitializer();
        }
        if (casIni != null) {
            this.casInitializerPanel.clearAll();
            this.populateCasInitializerPanel(casIni);
        } else {
            this.casInitializerPanel.reset();
        }
        int numFailed = 0;
        this.removeAllAEsAndConsumers();
        CpeCasProcessor[] casProcs = this.currentCpeDesc.getCpeCasProcessors().getAllCpeCasProcessors();
        for (int i = 0; i < casProcs.length; ++i) {
            boolean success = true;
            try {
                URL specifierUrl = casProcs[i].getCpeComponentDescriptor().findAbsoluteUrl(this.defaultResourceManager);
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(specifierUrl));
                success = this.isCasConsumerSpecifier(specifier) ? this.addConsumer(casProcs[i]) : this.addAE(casProcs[i]);
            }
            catch (Exception e) {
                System.err.println("Error loading CPE Descriptor " + aFile.getPath());
                e.printStackTrace();
                success = false;
            }
            if (success) continue;
            this.currentCpeDesc.getCpeCasProcessors().removeCpeCasProcessor(i - numFailed);
            ++numFailed;
        }
        this.prefs.put(PREFS_CPE_DESCRIPTOR_FILE, aFile.getAbsolutePath());
        this.clearDirty();
    }

    private boolean isCasConsumerSpecifier(ResourceSpecifier specifier) {
        if (specifier instanceof CasConsumerDescription) {
            return true;
        }
        if (specifier instanceof URISpecifier) {
            URISpecifier uriSpec = (URISpecifier)specifier;
            return "CasConsumer".equals(uriSpec.getResourceType());
        }
        return false;
    }

    static class ResetableMetaDataPanel
    extends MetaDataPanel {
        private static final long serialVersionUID = -4573780175511175666L;

        public ResetableMetaDataPanel() {
        }

        public ResetableMetaDataPanel(int nrColumns) {
            super(nrColumns);
        }

        public void reset() {
            Component[] components = this.gridBagPanel.getComponents();
            if (components.length > 2) {
                for (int i = components.length - 1; i >= 2; --i) {
                    this.gridBagPanel.remove(i);
                }
                this.componentIndex = 2;
            }
            this.fieldsList.clear();
        }
    }

    class StatusCallbackListenerImpl
    implements StatusCallbackListener {
        StatusCallbackListenerImpl() {
        }

        public void initializationComplete() {
            int nrFiles = -1;
            Progress[] progress = CpmPanel.this.mCPE.getProgress();
            if (progress != null) {
                for (int i = 0; i < progress.length; ++i) {
                    if (!progress[i].getUnit().equals("entities")) continue;
                    nrFiles = (int)progress[i].getTotal();
                    break;
                }
            }
            if (nrFiles != -1) {
                CpmPanel.this.progressBar.setMaximum(nrFiles);
                CpmPanel.this.progressBar.setIndeterminate(false);
            } else {
                CpmPanel.this.progressBar.setIndeterminate(true);
            }
            CpmPanel.this.progressBar.setValue(0);
            CpmPanel.this.progressTimer.start();
        }

        public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
            if (aStatus.isException()) {
                List ex = aStatus.getExceptions();
                CpmPanel.this.displayError((Throwable)ex.get(0));
            }
        }

        public void batchProcessComplete() {
        }

        public void collectionProcessComplete() {
            CpmPanel.this.onCompletion();
        }

        public void paused() {
            System.out.println("StatusCallbackListenerImpl::paused()");
        }

        public void resumed() {
            System.out.println("StatusCallbackListenerImpl::resumed");
        }

        public void aborted() {
            if (!CpmPanel.this.mShuttingDown && !CpmPanel.this.mPaused) {
                PerformanceReportDialog perfReportDlg = new PerformanceReportDialog(CpmPanel.this.getParentFrame());
                perfReportDlg.displayStats(CpmPanel.this.mCPE.getPerformanceReport(), CpmPanel.this.progressBar.getValue(), "Processing aborted.");
            }
            CpmPanel.this.resetScreen();
            CpmPanel.this.mPaused = false;
        }
    }
}

