/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cvd.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.internal.util.Timer;
import org.apache.uima.tools.cvd.MainFrame;

public class XmiCasFileOpenHandler
implements ActionListener {
    final MainFrame main;

    private XmiCasFileOpenHandler() {
        this.main = null;
    }

    public XmiCasFileOpenHandler(MainFrame main) {
        this.main = main;
    }

    public void actionPerformed(ActionEvent event) {
        File xmiCasFile;
        int rc;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle("Open XMI CAS file");
        if (this.main.getXcasFileOpenDir() != null) {
            fileChooser.setCurrentDirectory(this.main.getXcasFileOpenDir());
        }
        if ((rc = fileChooser.showOpenDialog(this.main)) == 0 && (xmiCasFile = fileChooser.getSelectedFile()).exists() && xmiCasFile.isFile()) {
            try {
                this.main.setXcasFileOpenDir(xmiCasFile.getParentFile());
                Timer time = new Timer();
                time.start();
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                XmiCasDeserializer xmiCasDeserializer = new XmiCasDeserializer(this.main.getCas().getTypeSystem());
                this.main.getCas().reset();
                parser.parse(xmiCasFile, xmiCasDeserializer.getXmiCasHandler(this.main.getCas()));
                time.stop();
                this.main.handleSofas();
                this.main.setTitle("XMI CAS");
                this.main.updateIndexTree(true);
                this.main.setRunOnCasEnabled();
                this.main.setEnableCasFileReadingAndWriting();
                this.main.setStatusbarMessage("Done loading XMI CAS file in " + time.getTimeSpan() + ".");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.main.handleException(e);
            }
        }
    }
}

