/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.docanalyzer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ProgressMonitor;
import javax.swing.SpringLayout;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.metadata.FixedFlow;
import org.apache.uima.analysis_engine.metadata.SofaMapping;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionProcessingManager;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.EntityProcessStatus;
import org.apache.uima.collection.StatusCallbackListener;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.tools.components.FileSystemCollectionReader;
import org.apache.uima.tools.components.XmiWriterCasConsumer;
import org.apache.uima.tools.components.XmlDetagger;
import org.apache.uima.tools.docanalyzer.AnnotationViewerDialog;
import org.apache.uima.tools.docanalyzer.FileSelector;
import org.apache.uima.tools.docanalyzer.PrefsMediator;
import org.apache.uima.tools.docanalyzer.TfDocumentListener;
import org.apache.uima.tools.docanalyzer.TfFileSelectorListener;
import org.apache.uima.tools.docanalyzer.TfFocusListener;
import org.apache.uima.tools.images.Images;
import org.apache.uima.tools.stylemap.StyleMapEditor;
import org.apache.uima.tools.stylemap.StyleMapEntry;
import org.apache.uima.tools.util.gui.AboutDialog;
import org.apache.uima.tools.util.gui.Caption;
import org.apache.uima.tools.util.gui.SpringUtilities;
import org.apache.uima.util.AnalysisEnginePerformanceReports;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class DocumentAnalyzer
extends JFrame
implements StatusCallbackListener,
ActionListener {
    private static final long serialVersionUID = 8795969283257780425L;
    private static final String HELP_MESSAGE = "Instructions for using UIMA Document Analyzer:\n\n1) In the \"Input Directory\" field, either type or use the browse\nbutton to select a directory containing the documents that you want\nto analyze.\n\n2) In the \"Output Directory\" field, either type or use the browse\nbutton to select a directory where you would like the analyzed\ndocuments to be placed.\n\n3) In the \"Location of Analysis Engine XML Descriptor\" field, either type or use\nthe browse button to select the XML Descriptor file for the Analysis Engine you\nwant to use.\n\n4) Optionally, if your input documents are XML files and you only\nwant to analyze the contents of a particular tag within those files,\nyou may enter in the \"XML Tag Containing Text\" field the name of\nthe XML tag that contains the text to be analyzed.\n\n 5) In the \"Language\" field, you may select or type the language \nof your input documents.  Some Analysis Engines may require this.\n\n6) Click the \"Run\" button at the buttom of the window.\n\n\nWhen processing is complete, a list of the analyzed documents will\nbe displayed.  Select the view format (Java Viewer is recommended),\nand double-click on a document to view it.\n\n";
    private FileSelector inputFileSelector;
    protected FileSelector outputFileSelector;
    protected FileSelector xmlFileSelector;
    protected String outputFileSelected = null;
    private JTextField runParametersField;
    private JComboBox languageComboBox;
    private JComboBox encodingComboBox;
    private ProgressMonitor progressMonitor;
    protected TypeSystem currentTypeSystem;
    protected String[] currentTaeOutputTypes;
    private File userStyleMapFile;
    protected boolean useGeneratedStyleMap = false;
    private FileSystemCollectionReader collectionReader;
    private CollectionProcessingManager mCPM;
    protected String interactiveTempFN = "__DAtemp__.txt";
    private JDialog aboutDialog;
    private int numDocs;
    private int numDocsProcessed = 0;
    private File outputDirectory;
    private JButton runButton;
    private JButton interButton;
    protected boolean interactive = false;
    private final JRadioButton javaViewerRB = new JRadioButton("Java Viewer");
    private final JRadioButton javaViewerUCRB = new JRadioButton("<html><font color=maroon>JV user colors</font></html>");
    private final JRadioButton htmlRB = new JRadioButton("HTML");
    protected final JRadioButton xmlRB = new JRadioButton("XML");
    private JDialog analyzeInputDialog = null;
    protected boolean javaViewerRBisSelected = false;
    protected boolean javaViewerUCRBisSelected = false;
    protected PrefsMediator prefsMed = new PrefsMediator();
    protected String statsString;
    protected File taeDescFile;
    protected String taeDescFileName;
    private File aeSpecifierFile;
    protected CAS cas;
    private Timer progressTimer;
    private boolean usingXmlDetagger;

    public DocumentAnalyzer() {
        this(null, false, false);
    }

    public DocumentAnalyzer(String outputFileSelected, boolean interactiveDA, boolean jvucrbis) {
        super("Document Analyzer");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            System.err.println("Could not set look and feel: " + e.getMessage());
        }
        try {
            this.setIconImage(Images.getImage("/org/apache/uima/tools/images/Micro_16.gif"));
        }
        catch (IOException e) {
            System.err.println("Image could not be loaded: " + e.getMessage());
        }
        this.aboutDialog = new AboutDialog(this, "About Document Analyzer");
        this.outputFileSelected = outputFileSelected;
        this.interactive = interactiveDA;
        this.javaViewerUCRBisSelected = jvucrbis;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        JMenu helpMenu = new JMenu("Help");
        JMenuItem aboutMenuItem = new JMenuItem("About");
        JMenuItem helpMenuItem = new JMenuItem("Help");
        JMenuItem exitMenuItem = new JMenuItem("Exit");
        fileMenu.add(exitMenuItem);
        helpMenu.add(aboutMenuItem);
        helpMenu.add(helpMenuItem);
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        String inputString = "Input Directory: ";
        String outputString = "Output Directory: ";
        String xmlString = "Location of Analysis Engine XML Descriptor: ";
        String runParametersString = "XML Tag containing Text (optional): ";
        Caption labelInputFile = new Caption("Input Directory: ");
        Caption labelOutputFile = new Caption("Output Directory: ");
        Caption labelXmlFile = new Caption("Location of Analysis Engine XML Descriptor: ");
        Caption labelRunParameters = new Caption("XML Tag containing Text (optional): ");
        Caption labelLanguage = new Caption("Language: ");
        Caption labelEncoding = new Caption("Character Encoding: ");
        JPanel controlPanel = new JPanel();
        controlPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        controlPanel.setLayout(new SpringLayout());
        this.outputDirectory = new File(this.prefsMed.getOutputDir());
        File browserRootDir = new File(System.getProperty("user.dir"));
        TfFocusListener tlf = new TfFocusListener(this.prefsMed);
        TfFileSelectorListener fsl = new TfFileSelectorListener(this.prefsMed);
        TfDocumentListener dl = new TfDocumentListener(this.prefsMed);
        this.inputFileSelector = new FileSelector(this.prefsMed.getInputDir(), "Input Directory", 1, browserRootDir);
        this.inputFileSelector.addFileSelectorListener(fsl);
        this.inputFileSelector.addDocumentListener(dl);
        this.outputFileSelector = new FileSelector(this.prefsMed.getOutputDir(), "Output Directory", 1, browserRootDir);
        this.outputFileSelector.addFileSelectorListener(fsl);
        this.outputFileSelector.addDocumentListener(dl);
        this.xmlFileSelector = new FileSelector(this.prefsMed.getTAEfile(), "Analysis Engine Descriptor XML file", 0, browserRootDir);
        this.xmlFileSelector.addFileSelectorListener(fsl);
        this.xmlFileSelector.addDocumentListener(dl);
        this.prefsMed.setFileSelectors(this.inputFileSelector, this.outputFileSelector, this.xmlFileSelector);
        this.runParametersField = new JTextField(16);
        this.runParametersField.setText(this.prefsMed.getXmlTag());
        JPanel runParametersPanel = new JPanel();
        runParametersPanel.setLayout(new FlowLayout(0, 2, 2));
        runParametersPanel.add(this.runParametersField);
        this.languageComboBox = new JComboBox<Object>(new Object[]{"en", "de", "es", "fr", "it", "pt", "ja", "ko-kr", "pt-br", "zh-cn", "zh-tw", "x-unspecified"});
        this.languageComboBox.setEditable(true);
        this.languageComboBox.setSelectedItem(this.prefsMed.getLanguage());
        JPanel languagePanel = new JPanel();
        languagePanel.setLayout(new FlowLayout(0, 2, 2));
        languagePanel.add(this.languageComboBox);
        SortedMap<String, Charset> charsetMap = Charset.availableCharsets();
        Set charsets = charsetMap.keySet();
        Object[] charsetArr = charsets.toArray();
        this.encodingComboBox = new JComboBox<Object>(charsetArr);
        this.encodingComboBox.setEditable(true);
        this.encodingComboBox.setSelectedItem(this.prefsMed.getEncoding());
        JPanel encodingPanel = new JPanel();
        encodingPanel.setLayout(new FlowLayout(0, 2, 2));
        encodingPanel.add(this.encodingComboBox);
        controlPanel.add(labelInputFile);
        controlPanel.add(this.inputFileSelector);
        controlPanel.add(labelOutputFile);
        controlPanel.add(this.outputFileSelector);
        controlPanel.add(labelXmlFile);
        controlPanel.add(this.xmlFileSelector);
        controlPanel.add(labelRunParameters);
        controlPanel.add(runParametersPanel);
        controlPanel.add(labelLanguage);
        controlPanel.add(languagePanel);
        controlPanel.add(labelEncoding);
        controlPanel.add(encodingPanel);
        SpringUtilities.makeCompactGrid(controlPanel, 6, 2, 4, 4, 4, 4);
        exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentAnalyzer.this.savePreferences();
                System.exit(0);
            }
        });
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentAnalyzer.this.aboutDialog.setVisible(true);
            }
        });
        helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JOptionPane.showMessageDialog(DocumentAnalyzer.this, DocumentAnalyzer.HELP_MESSAGE, "Document Analyzer Help", -1);
            }
        });
        Container contentPanel = this.getContentPane();
        contentPanel.setBackground(Color.WHITE);
        JLabel banner = new JLabel(Images.getImageIcon("/org/apache/uima/tools/images/UIMA_banner.png"));
        contentPanel.add((Component)banner, "North");
        contentPanel.add((Component)controlPanel, "Center");
        this.runButton = new JButton("Run");
        this.runButton.setToolTipText("Runs Analysis Engine and displays results");
        this.interButton = new JButton("Interactive");
        this.interButton.setToolTipText("Type in text to analyze");
        JButton viewButton = new JButton("View");
        viewButton.setDefaultCapable(true);
        viewButton.setRequestFocusEnabled(true);
        viewButton.requestFocus();
        viewButton.addFocusListener(tlf);
        this.prefsMed.setDocButtons(this.runButton, this.interButton, viewButton);
        JPanel lowerButtonsPanel = new JPanel();
        lowerButtonsPanel.add((Component)this.runButton, "West");
        lowerButtonsPanel.add((Component)this.interButton, "East");
        lowerButtonsPanel.add((Component)viewButton, "East");
        lowerButtonsPanel.setFocusCycleRoot(true);
        contentPanel.add((Component)lowerButtonsPanel, "South");
        this.setContentPane(contentPanel);
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ee) {
                DocumentAnalyzer.this.interactive = false;
                DocumentAnalyzer.this.savePreferences();
                DocumentAnalyzer.this.analyzeDocuments(null);
            }
        });
        this.interButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ee) {
                if (DocumentAnalyzer.this.outputFileSelector.getSelected().length() == 0) {
                    DocumentAnalyzer.this.displayError("Need to specify an output directory for temporary results.");
                } else {
                    DocumentAnalyzer.this.interactive = true;
                    DocumentAnalyzer.this.savePreferences();
                    DocumentAnalyzer.this.analyzeInputarea();
                }
            }
        });
        viewButton.addActionListener(this);
        this.restorePreferences();
        this.progressTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent ee) {
                DocumentAnalyzer.this.checkProgressMonitor();
            }
        });
    }

    public void analyzeInputarea() {
        this.analyzeInputDialog = new JDialog((Frame)this, "Annotation Input");
        File styleMapFile = this.prefsMed.getStylemapFile();
        if (!styleMapFile.exists()) {
            this.useGeneratedStyleMap = true;
        }
        TextAreaViewer viewer = new TextAreaViewer(this.analyzeInputDialog, this.useGeneratedStyleMap);
        this.analyzeInputDialog.getContentPane().add(viewer);
        this.analyzeInputDialog.setSize(850, 630);
        this.analyzeInputDialog.pack();
        this.analyzeInputDialog.show();
    }

    public void actionPerformed(ActionEvent e) {
        this.savePreferences();
        try {
            this.aeSpecifierFile = new File(this.xmlFileSelector.getSelected());
            this.interactive = false;
            this.showAnalysisResults(this.outputDirectory);
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public void analyzeDocuments(String analysisText) {
        this.outputFileSelected = this.outputFileSelector.getSelected();
        File inputDir = new File(this.inputFileSelector.getSelected());
        this.outputDirectory = this.outputFileSelector.getSelected().length() > 0 ? new File(this.outputFileSelector.getSelected()) : null;
        String tempFileDir = null;
        if (analysisText != null && this.outputDirectory != null) {
            tempFileDir = this.outputFileSelector.getSelected() + "/interactive_temp";
            inputDir = new File(tempFileDir);
            if (!inputDir.exists()) {
                inputDir.mkdirs();
            }
            this.outputFileSelected = this.outputFileSelector.getSelected() + "/interactive_out";
            this.prefsMed.setOutputDirForInteractiveMode(this.outputFileSelected, this.outputFileSelector.getSelected());
            this.outputDirectory = new File(this.outputFileSelected);
        } else {
            analysisText = null;
        }
        this.aeSpecifierFile = new File(this.xmlFileSelector.getSelected());
        String xmlTag = this.runParametersField.getText();
        if ("".equals(xmlTag)) {
            xmlTag = null;
        }
        String language = (String)this.languageComboBox.getSelectedItem();
        String encoding = (String)this.encodingComboBox.getSelectedItem();
        if (this.aeSpecifierFile.getName().equals("")) {
            this.displayError("An Analysis Engine Descriptor is Required");
        } else if (!this.aeSpecifierFile.exists()) {
            this.displayError("Analysis Engine Descriptor \"" + this.xmlFileSelector.getSelected() + "\" does not exist.");
        } else if (this.aeSpecifierFile.isDirectory()) {
            this.displayError("The Analysis Engine Descriptor (" + this.xmlFileSelector.getSelected() + ") must be a file, not a directory.");
        } else if (inputDir.getName().equals("")) {
            this.displayError("An Input Directory is Required");
        } else if (!inputDir.exists()) {
            this.displayError("The input directory \"" + this.inputFileSelector.getSelected() + "\" does not exist.");
        } else if (!inputDir.isDirectory()) {
            this.displayError("The input directory (" + this.inputFileSelector.getSelected() + ") must be a directory, not a file.");
        } else if (this.outputDirectory != null && !this.outputDirectory.exists() && !this.outputDirectory.mkdirs() || !this.outputDirectory.isDirectory()) {
            this.displayError("The output directory \"" + this.outputFileSelector.getSelected() + "\" does not exist and could not be created.");
        } else if (inputDir.equals(this.outputDirectory)) {
            this.displayError("The input directory and the output directory must be different.");
        } else {
            int i;
            File[] filesInOutDir;
            if (analysisText != null) {
                filesInOutDir = inputDir.listFiles();
                for (int i2 = 0; i2 < filesInOutDir.length; ++i2) {
                    if (filesInOutDir[i2].isDirectory()) continue;
                    filesInOutDir[i2].delete();
                }
                File tempFile = new File(tempFileDir + "/" + this.interactiveTempFN);
                try {
                    PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(tempFile)));
                    writer.println(analysisText);
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            filesInOutDir = this.outputDirectory.listFiles();
            for (i = 0; i < filesInOutDir.length; ++i) {
                if (filesInOutDir[i].isDirectory()) continue;
                String filename = filesInOutDir[i].getName();
                if (filename.endsWith(".xmi")) {
                    filename = filename.substring(0, filename.length() - 4);
                }
                if (new File(inputDir, filename).exists()) continue;
                int choice = JOptionPane.showConfirmDialog(this, "All files in " + this.outputDirectory.getPath() + " will be deleted.  These files don't " + "appear to match the files in the input directory.  Is this OK?", "Confirm", 0);
                if (choice != 1) break;
                return;
            }
            for (i = 0; i < filesInOutDir.length; ++i) {
                if (filesInOutDir[i].isDirectory()) continue;
                filesInOutDir[i].delete();
            }
            this.javaViewerRBisSelected = this.javaViewerRB.isSelected();
            this.javaViewerUCRBisSelected = this.javaViewerUCRB.isSelected();
            ProcessingThread thread = new ProcessingThread(inputDir, this.outputDirectory, this.aeSpecifierFile, xmlTag, language, encoding);
            thread.start();
        }
    }

    private void checkProgressMonitor() {
        if (this.progressMonitor.isCanceled()) {
            this.progressMonitor.setNote("Cancelling...");
            this.mCPM.stop();
            this.aborted();
        }
    }

    public void entityProcessComplete(CAS aCas, EntityProcessStatus aStatus) {
        if (aStatus.isException()) {
            this.displayError((Throwable)aStatus.getExceptions().get(0));
        }
        ++this.numDocsProcessed;
        this.progressMonitor.setProgress(this.numDocsProcessed + 2);
        this.progressMonitor.setNote("Processed " + this.numDocsProcessed + " of " + this.numDocs + " documents.");
    }

    public void aborted() {
        if (this.progressMonitor != null) {
            this.progressMonitor.close();
        }
        this.progressTimer.stop();
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void batchProcessComplete() {
    }

    public void collectionProcessComplete() {
        if (!this.progressMonitor.isCanceled()) {
            this.progressMonitor.close();
            this.progressTimer.stop();
        }
        this.setEnabled(true);
        this.setCursor(Cursor.getDefaultCursor());
        this.showAnalysisResults(new AnalysisEnginePerformanceReports(this.mCPM.getPerformanceReport()), this.outputDirectory);
    }

    public void initializationComplete() {
    }

    public void paused() {
    }

    public void resumed() {
    }

    public void showAnalysisResults(AnalysisEnginePerformanceReports aReports, File aOutputDir) {
        this.statsString = "PERFORMANCE STATS\n-------------\n\n" + aReports;
        this.show_analysis(aOutputDir);
    }

    public void showAnalysisResults(File aOutputDir) {
        try {
            this.cas = this.createCasFromDescriptor(this.prefsMed.getTAEfile());
            this.currentTypeSystem = this.cas.getTypeSystem();
        }
        catch (Exception e) {
            this.displayError(e);
        }
        this.statsString = null;
        if (this.prefsMed.getStylemapFile().exists()) {
            StyleMapEditor sedit = new StyleMapEditor(this, this.cas);
            String sXml = this.readStylemapFile(this.prefsMed.getStylemapFile());
            ArrayList sme = sedit.parseStyleList(sXml);
            this.currentTaeOutputTypes = new String[sme.size()];
            for (int i = 0; i < sme.size(); ++i) {
                StyleMapEntry e = (StyleMapEntry)sme.get(i);
                this.currentTaeOutputTypes[i] = e.getAnnotationTypeName();
            }
        }
        this.show_analysis(aOutputDir);
    }

    protected CAS createCasFromDescriptor(String aDescriptorFile) throws ResourceInitializationException, InvalidXMLException, IOException {
        ResourceSpecifier spec = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(aDescriptorFile));
        if (spec instanceof AnalysisEngineDescription) {
            return CasCreationUtils.createCas((AnalysisEngineDescription)spec);
        }
        AnalysisEngine currentAe = UIMAFramework.produceAnalysisEngine(spec);
        return CasCreationUtils.createCas(currentAe.getAnalysisEngineMetaData());
    }

    protected String readStylemapFile(File smapFile) {
        String styleMapXml = "";
        if (smapFile.exists()) {
            try {
                return FileUtils.file2String(smapFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return styleMapXml;
    }

    private void show_analysis(File outputDir) {
        File styleMapFile = this.getStyleMapFile();
        if (styleMapFile == null) {
            styleMapFile = this.prefsMed.getStylemapFile();
        }
        if (this.interactive) {
            new AnnotationViewerDialog(this, "Analysis Results", this.prefsMed, styleMapFile, this.statsString, this.currentTypeSystem, this.currentTaeOutputTypes, this.interactiveTempFN + ".xmi", this.javaViewerRBisSelected, this.javaViewerUCRBisSelected, this.xmlRB.isSelected(), this.cas);
        } else {
            AnnotationViewerDialog viewerDialog = new AnnotationViewerDialog(this, "Analysis Results", this.prefsMed, styleMapFile, this.statsString, this.currentTypeSystem, this.currentTaeOutputTypes, this.useGeneratedStyleMap, this.cas);
            if (this.usingXmlDetagger) {
                viewerDialog.setDefaultCasViewName("plainTextDocument");
            }
            viewerDialog.pack();
            viewerDialog.setModal(true);
            viewerDialog.setVisible(true);
        }
    }

    public void savePreferences() {
        this.prefsMed.setInputDir(this.inputFileSelector.getSelected());
        this.prefsMed.setOutputDir(this.outputFileSelector.getSelected());
        this.prefsMed.setTAEfile(this.xmlFileSelector.getSelected());
        this.prefsMed.setXmlTag(this.runParametersField.getText());
        this.prefsMed.setLanguage((String)this.languageComboBox.getSelectedItem());
        this.prefsMed.setEncoding((String)this.encodingComboBox.getSelectedItem());
    }

    public void restorePreferences() {
        this.prefsMed.restorePreferences();
    }

    public void displayError(String aErrorString) {
        StringBuffer buf = new StringBuffer(aErrorString.length());
        int CHARS_PER_LINE = 80;
        int charCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(aErrorString, " \n", true);
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            if (tok.equals("\n")) {
                buf.append("\n");
                charCount = 0;
                continue;
            }
            if (charCount > 0 && charCount + tok.length() > 80) {
                buf.append("\n").append(tok);
                charCount = tok.length();
                continue;
            }
            buf.append(tok);
            charCount += tok.length();
        }
        JOptionPane.showMessageDialog(this, buf.toString(), "Error", 0);
    }

    public void displayError(Throwable aThrowable) {
        aThrowable.printStackTrace();
        String message = aThrowable.toString();
        while (aThrowable instanceof UIMAException || aThrowable instanceof UIMARuntimeException) {
            if (aThrowable instanceof UIMAException) {
                aThrowable = ((UIMAException)aThrowable).getCause();
            } else if (aThrowable instanceof UIMARuntimeException) {
                aThrowable = ((UIMARuntimeException)aThrowable).getCause();
            }
            if (aThrowable == null) continue;
            message = message + "\nCausedBy: " + aThrowable.toString();
        }
        this.displayError(message);
    }

    public static void main(String[] args) {
        DocumentAnalyzer frame = new DocumentAnalyzer();
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void runProcessingThread(File inputDir, File outputDir, File aeSpecifierFile, String xmlTag, String language, String encoding) {
        try {
            CollectionReaderDescription collectionReaderDesc = FileSystemCollectionReader.getDescription();
            ConfigurationParameterSettings paramSettings = collectionReaderDesc.getMetaData().getConfigurationParameterSettings();
            paramSettings.setParameterValue("InputDirectory", inputDir.getAbsolutePath());
            paramSettings.setParameterValue("Language", language);
            paramSettings.setParameterValue("Encoding", encoding);
            this.collectionReader = (FileSystemCollectionReader)UIMAFramework.produceCollectionReader(collectionReaderDesc);
            String progressMsg = "  Processing " + this.collectionReader.getNumberOfDocuments() + " Documents.";
            this.numDocs = this.collectionReader.getNumberOfDocuments();
            this.progressMonitor = new ProgressMonitor(this, progressMsg, "", 0, this.numDocs + 2);
            String initial = "Initializing.... Please wait ";
            this.progressMonitor.setNote(initial);
            this.progressMonitor.setMillisToPopup(-1);
            this.progressMonitor.setMillisToDecideToPopup(-1);
            this.numDocsProcessed = 0;
            this.progressTimer.start();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.setEnabled(false);
            this.mCPM = UIMAFramework.newCollectionProcessingManager();
            XMLInputSource in = new XMLInputSource(aeSpecifierFile);
            ResourceSpecifier aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            CasConsumerDescription casConsumerDesc = XmiWriterCasConsumer.getDescription();
            ConfigurationParameterSettings consumerParamSettings = casConsumerDesc.getMetaData().getConfigurationParameterSettings();
            consumerParamSettings.setParameterValue("OutputDirectory", outputDir.getAbsolutePath());
            casConsumerDesc.getCasConsumerMetaData().getCapabilities()[0].addInputType("uima.cas.TOP", true);
            AnalysisEngineDescription xmlDetaggerDesc = null;
            if (xmlTag != null && xmlTag.length() > 0) {
                xmlDetaggerDesc = XmlDetagger.getDescription();
                ConfigurationParameterSettings xmlDetaggerParamSettings = xmlDetaggerDesc.getMetaData().getConfigurationParameterSettings();
                xmlDetaggerParamSettings.setParameterValue("XmlTagContainingText", xmlTag);
                this.usingXmlDetagger = true;
            } else {
                this.usingXmlDetagger = false;
            }
            AnalysisEngineDescription aggDesc = UIMAFramework.getResourceSpecifierFactory().createAnalysisEngineDescription();
            aggDesc.setPrimitive(false);
            aggDesc.getDelegateAnalysisEngineSpecifiersWithImports().put("UserAE", aeSpecifier);
            aggDesc.getDelegateAnalysisEngineSpecifiersWithImports().put("XmiWriter", casConsumerDesc);
            FixedFlow flow = UIMAFramework.getResourceSpecifierFactory().createFixedFlow();
            if (xmlDetaggerDesc != null) {
                aggDesc.getDelegateAnalysisEngineSpecifiersWithImports().put("XmlDetagger", xmlDetaggerDesc);
                flow.setFixedFlow(new String[]{"XmlDetagger", "UserAE", "XmiWriter"});
                SofaMapping sofaMapping1 = UIMAFramework.getResourceSpecifierFactory().createSofaMapping();
                sofaMapping1.setComponentKey("XmlDetagger");
                sofaMapping1.setComponentSofaName("xmlDocument");
                sofaMapping1.setAggregateSofaName("_InitialView");
                SofaMapping sofaMapping2 = UIMAFramework.getResourceSpecifierFactory().createSofaMapping();
                sofaMapping2.setComponentKey("UserAE");
                sofaMapping2.setAggregateSofaName("plainTextDocument");
                SofaMapping sofaMapping3 = UIMAFramework.getResourceSpecifierFactory().createSofaMapping();
                sofaMapping3.setComponentKey("XmiWriter");
                sofaMapping3.setAggregateSofaName("plainTextDocument");
                aggDesc.setSofaMappings(new SofaMapping[]{sofaMapping1, sofaMapping2, sofaMapping3});
            } else {
                flow.setFixedFlow(new String[]{"UserAE", "XmiWriter"});
            }
            aggDesc.getAnalysisEngineMetaData().setName("DocumentAnalyzerAE");
            aggDesc.getAnalysisEngineMetaData().setFlowConstraints(flow);
            aggDesc.getAnalysisEngineMetaData().getOperationalProperties().setMultipleDeploymentAllowed(false);
            this.progressMonitor.setProgress(1);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(aggDesc);
            this.mCPM.setAnalysisEngine(ae);
            this.progressMonitor.setProgress(2);
            this.mCPM.addStatusCallbackListener(this);
            ArrayList<MetaDataObject> descriptorList = new ArrayList<MetaDataObject>();
            descriptorList.add(collectionReaderDesc);
            descriptorList.add(ae.getMetaData());
            descriptorList.add(casConsumerDesc);
            this.cas = CasCreationUtils.createCas(descriptorList);
            this.currentTypeSystem = this.cas.getTypeSystem();
            if (aeSpecifier instanceof AnalysisEngineDescription) {
                ArrayList<String> outputTypeList = new ArrayList<String>();
                Capability[] capabilities = ((AnalysisEngineDescription)aeSpecifier).getAnalysisEngineMetaData().getCapabilities();
                for (int i = 0; i < capabilities.length; ++i) {
                    TypeOrFeature[] outputs = capabilities[i].getOutputs();
                    for (int j = 0; j < outputs.length; ++j) {
                        if (!outputs[j].isType()) continue;
                        outputTypeList.add(outputs[j].getName());
                        Type t = this.currentTypeSystem.getType(outputs[j].getName());
                        if (t == null) continue;
                        List subsumedTypes = this.currentTypeSystem.getProperlySubsumedTypes(t);
                        Iterator it = subsumedTypes.iterator();
                        while (it.hasNext()) {
                            outputTypeList.add(((Type)it.next()).getName());
                        }
                    }
                }
                outputTypeList.add("uima.tcas.DocumentAnnotation");
                this.currentTaeOutputTypes = new String[outputTypeList.size()];
                outputTypeList.toArray(this.currentTaeOutputTypes);
            } else {
                this.currentTaeOutputTypes = null;
            }
            this.mCPM.process(this.collectionReader);
            if (this.progressMonitor.isCanceled()) {
                this.mCPM.stop();
                this.progressMonitor.close();
            }
        }
        catch (Throwable t) {
            if (this.usingXmlDetagger && t instanceof UIMAException && ((UIMAException)t).hasMessageKey("sofa_mapping_not_supported_for_remote")) {
                this.displayError("The XML detagging feature is not supported for remote Analysis Engines or for Aggregates containing remotes.  If you are running a remote Analysis Engine the \"XML Tag Containing Text\" field must be left blank.");
            } else {
                this.displayError(t);
            }
            this.aborted();
        }
    }

    public File getStyleMapFile() {
        if (this.userStyleMapFile == null && this.prefsMed != null) {
            return this.prefsMed.getStylemapFile();
        }
        return this.userStyleMapFile;
    }

    public void setStyleMapFile(File styleMapFile) {
        this.userStyleMapFile = styleMapFile;
    }

    public Dimension getPreferredSize() {
        return new Dimension(700, 350);
    }

    class ProcessingThread
    extends Thread {
        File inputDir;
        File outputDir;
        File taeSpecifierFile;
        String xmlTag;
        String language;
        String encoding;

        ProcessingThread(File inputDir, File outputDir, File taeSpecifierFile, String xmlTag, String language, String encoding) {
            this.inputDir = inputDir;
            this.outputDir = outputDir;
            this.taeSpecifierFile = taeSpecifierFile;
            this.xmlTag = xmlTag;
            this.language = language;
            this.encoding = encoding;
        }

        public void run() {
            DocumentAnalyzer.this.runProcessingThread(this.inputDir, this.outputDir, this.taeSpecifierFile, this.xmlTag, this.language, this.encoding);
        }
    }

    class TextAreaViewer
    extends JPanel {
        private static final long serialVersionUID = -7503162930412929062L;
        private JTextPane textPane = new JTextPane();

        public TextAreaViewer(final JDialog aiDialog, boolean generatedStyleMap) {
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BoxLayout(mainPanel, 1));
            mainPanel.setPreferredSize(new Dimension(620, 600));
            mainPanel.setMinimumSize(new Dimension(200, 200));
            this.setLayout(new BorderLayout());
            this.add(mainPanel);
            JPanel analyzeTitlePanel = new JPanel();
            analyzeTitlePanel.setLayout(new FlowLayout(0));
            analyzeTitlePanel.add(new JLabel("Type or cut-and-paste in your text to be annotated. "));
            analyzeTitlePanel.add(new JLabel("Then click on Analyze."));
            mainPanel.add(analyzeTitlePanel);
            this.textPane.setEditable(true);
            this.textPane.setSelectionColor(new Color(100, 100, 200, 75));
            this.textPane.setPreferredSize(new Dimension(620, 400));
            this.textPane.setMinimumSize(new Dimension(200, 100));
            JScrollPane textScrollPane = new JScrollPane(this.textPane);
            mainPanel.add(textScrollPane);
            JPanel southernPanel = new JPanel();
            southernPanel.setLayout(new BoxLayout(southernPanel, 1));
            JPanel controlsPanel = new JPanel();
            controlsPanel.setLayout(new SpringLayout());
            Caption displayFormatLabel = new Caption("Results Display Format:");
            controlsPanel.add(displayFormatLabel);
            JPanel displayFormatPanel = new JPanel();
            displayFormatPanel.setLayout(new FlowLayout(0));
            displayFormatPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            if (generatedStyleMap) {
                DocumentAnalyzer.this.javaViewerRB.setSelected(true);
            } else {
                DocumentAnalyzer.this.javaViewerUCRB.setSelected(true);
            }
            ButtonGroup displayFormatButtonGroup = new ButtonGroup();
            displayFormatButtonGroup.add(DocumentAnalyzer.this.javaViewerRB);
            displayFormatButtonGroup.add(DocumentAnalyzer.this.javaViewerUCRB);
            displayFormatButtonGroup.add(DocumentAnalyzer.this.htmlRB);
            displayFormatButtonGroup.add(DocumentAnalyzer.this.xmlRB);
            displayFormatPanel.add(DocumentAnalyzer.this.javaViewerRB);
            displayFormatPanel.add(DocumentAnalyzer.this.javaViewerUCRB);
            displayFormatPanel.add(DocumentAnalyzer.this.htmlRB);
            displayFormatPanel.add(DocumentAnalyzer.this.xmlRB);
            if (generatedStyleMap) {
                DocumentAnalyzer.this.javaViewerRB.setSelected(true);
                DocumentAnalyzer.this.javaViewerUCRB.setEnabled(false);
            } else {
                DocumentAnalyzer.this.javaViewerUCRB.setSelected(true);
                DocumentAnalyzer.this.javaViewerUCRB.setEnabled(true);
            }
            controlsPanel.add(displayFormatPanel);
            controlsPanel.setLayout(new FlowLayout(0));
            southernPanel.add(controlsPanel);
            JButton analyzeButton = new JButton("Analyze");
            analyzeButton.setToolTipText("Runs Analysis Engine and displays results");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setLayout(new FlowLayout(2));
            buttonsPanel.add(analyzeButton);
            JButton closeButton = new JButton("Close");
            closeButton.setToolTipText("Close application");
            buttonsPanel.add(closeButton);
            southernPanel.add(buttonsPanel);
            mainPanel.add(southernPanel);
            analyzeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ee) {
                    TextAreaViewer.this.analyzeTextArea();
                }
            });
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    TextAreaViewer.this.setVisible(false);
                    aiDialog.dispose();
                }
            });
        }

        public void analyzeTextArea() {
            String text = this.textPane.getText();
            DocumentAnalyzer.this.analyzeDocuments(text);
        }
    }
}

