/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;

public class AnalysisEnginePerformanceReports {
    private ProcessTrace mProcessTrace;
    private Map mAnnotatorAnalysisTimes = new HashMap();
    private int mAnalysisTime = 0;
    private int mFrameworkOverhead = 0;
    private int mServiceWrapperOverhead = 0;
    private int mServiceCallOverhead = 0;
    private int mTotalTime = 0;
    private NumberFormat pctFormat;

    public AnalysisEnginePerformanceReports(ProcessTrace aProcessTrace) {
        this.mProcessTrace = aProcessTrace;
        this.pctFormat = NumberFormat.getPercentInstance();
        this.pctFormat.setMaximumFractionDigits(2);
        List events = aProcessTrace.getEvents();
        for (ProcessTraceEvent evt : events) {
            if ("ANALYSIS_ENGINE".equals(evt.getType()) || "SERVICE_CALL".equals(evt.getType())) {
                this.mTotalTime += evt.getDuration();
            }
            this.addEventData(evt);
        }
    }

    protected void addEventData(ProcessTraceEvent aEvent) {
        int subEventDuration;
        int duration;
        String[] subEventTypes;
        if ("ANALYSIS".equals(aEvent.getType())) {
            this.mAnalysisTime += aEvent.getDuration();
            String componentName = aEvent.getComponentName();
            this.mAnnotatorAnalysisTimes.put(componentName, aEvent.getDuration());
        } else if ("ANALYSIS_ENGINE".equals(aEvent.getType())) {
            subEventTypes = new String[]{"ANALYSIS", "ANALYSIS_ENGINE"};
            duration = aEvent.getDuration();
            subEventDuration = this.getSubEventDuration(aEvent, subEventTypes);
            if (subEventDuration > 0) {
                this.mFrameworkOverhead += duration - subEventDuration;
            }
        } else if ("SERVICE".equals(aEvent.getType())) {
            subEventTypes = new String[]{"ANALYSIS", "ANALYSIS_ENGINE"};
            duration = aEvent.getDuration();
            subEventDuration = this.getSubEventDuration(aEvent, subEventTypes);
            if (subEventDuration > 0) {
                this.mServiceWrapperOverhead += duration - subEventDuration;
            }
        } else if ("SERVICE_CALL".equals(aEvent.getType())) {
            subEventTypes = new String[]{"SERVICE", "ANALYSIS", "ANALYSIS_ENGINE"};
            duration = aEvent.getDuration();
            subEventDuration = this.getSubEventDuration(aEvent, subEventTypes);
            if (subEventDuration > 0) {
                this.mServiceCallOverhead += duration - subEventDuration;
            }
        }
        for (ProcessTraceEvent subEvt : aEvent.getSubEvents()) {
            this.addEventData(subEvt);
        }
    }

    public int getTotalTime() {
        return this.mTotalTime;
    }

    public int getAnalysisTime() {
        return this.mAnalysisTime;
    }

    public int getFrameworkOverhead() {
        return this.mFrameworkOverhead;
    }

    public int getServiceWrapperOverhead() {
        return this.mServiceWrapperOverhead;
    }

    public int getServiceCallOverhead() {
        return this.mServiceCallOverhead;
    }

    public String getFullReport() {
        return ((Object)this.mProcessTrace).toString();
    }

    public String toString() {
        int total = this.getTotalTime();
        int analysis = this.getAnalysisTime();
        int frameworkOver = this.getFrameworkOverhead();
        int serviceWrapperOver = this.getServiceWrapperOverhead();
        int serviceCallOver = this.getServiceCallOverhead();
        StringBuffer buf = new StringBuffer();
        buf.append("Total Analysis Engine Time: " + total + "ms\n");
        if (analysis > 0) {
            buf.append("Annotator Time: " + this.getAnalysisTime() + "ms (" + this.toPct(analysis, total) + ")\n");
        } else {
            buf.append("Analysis: <10ms\n");
        }
        if (frameworkOver > 0) {
            buf.append("Framework Overhead: " + frameworkOver + "ms (" + this.toPct(frameworkOver, total) + ")\n");
        } else {
            buf.append("Framework Overhead: <10ms\n");
        }
        if (serviceCallOver > 0) {
            buf.append("Service Wrapper Overhead: " + serviceWrapperOver + "ms (" + this.toPct(serviceWrapperOver, total) + ")\n");
            buf.append("Service Call Overhead: " + serviceCallOver + "ms (" + this.toPct(serviceCallOver, total) + ")\n");
        }
        return buf.toString();
    }

    private String toPct(long numerator, long denomenator) {
        return this.pctFormat.format((double)numerator / (double)denomenator);
    }

    private int getSubEventDuration(ProcessTraceEvent aEvent, String[] aEventTypes) {
        int duration = 0;
        List subEvents = aEvent.getSubEvents();
        block0: for (ProcessTraceEvent evt : subEvents) {
            String type = evt.getType();
            for (int i = 0; i < aEventTypes.length; ++i) {
                if (!aEventTypes[i].equals(type)) continue;
                duration += evt.getDuration();
                continue block0;
            }
            duration += this.getSubEventDuration(evt, aEventTypes);
        }
        return duration;
    }
}

