/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.cas.CASException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.Level;

public class JCasPool {
    private Vector mAllInstances = new Vector();
    private Vector mFreeInstances = new Vector();
    private int mNumInstances;
    private static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private static final Class CLASS_NAME = JCasPool.class;

    public JCasPool(int aNumInstances, TextAnalysisEngine aTextAnalysisEngine) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aTextAnalysisEngine.getAnalysisEngineMetaData());
    }

    public JCasPool(int aNumInstances, AnalysisEngine aAnalysisEngine) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aAnalysisEngine.getAnalysisEngineMetaData());
    }

    public JCasPool(int aNumInstances, ProcessingResourceMetaData aMetaData) throws ResourceInitializationException {
        this.mNumInstances = aNumInstances;
        this.fillPool(aMetaData);
    }

    public synchronized JCas getJCas() {
        if (!this.mFreeInstances.isEmpty()) {
            return (JCas)this.mFreeInstances.remove(0);
        }
        return null;
    }

    public synchronized void releaseJCas(JCas aJCas) {
        if (!this.mAllInstances.contains(aJCas) || this.mFreeInstances.contains(aJCas)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseJCas", LOG_RESOURCE_BUNDLE, "UIMA_return_jcas_to_pool__WARNING");
        } else {
            aJCas.reset();
            this.mFreeInstances.add(aJCas);
        }
        this.notifyAll();
    }

    public synchronized JCas getJCas(long aTimeout) {
        JCas cas;
        long startTime = new Date().getTime();
        while ((cas = this.getJCas()) == null) {
            try {
                this.wait(aTimeout);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (aTimeout <= 0L || new Date().getTime() - startTime < aTimeout) continue;
            return null;
        }
        return cas;
    }

    public int getSize() {
        return this.mNumInstances;
    }

    protected void fillPool(ProcessingResourceMetaData aMetaData) throws ResourceInitializationException {
        ArrayList<ProcessingResourceMetaData> mdList = new ArrayList<ProcessingResourceMetaData>();
        mdList.add(aMetaData);
        for (int i = 0; i < this.mNumInstances; ++i) {
            JCas c;
            try {
                c = CasCreationUtils.createCas(mdList).getJCas();
            }
            catch (CASException e) {
                throw new ResourceInitializationException(e);
            }
            this.mAllInstances.add(c);
            this.mFreeInstances.add(c);
        }
    }

    protected Vector getAllInstances() {
        return this.mAllInstances;
    }

    protected Vector getFreeInstances() {
        return this.mFreeInstances;
    }
}

