/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.uima.UIMARuntimeException;

public class XMLInputSource {
    private InputStream mInputStream;
    private URL mURL;

    public XMLInputSource(File aFile) throws IOException {
        this(aFile.toURL());
    }

    public XMLInputSource(String aUrlOrFileName) throws IOException {
        try {
            this.mURL = new URL(aUrlOrFileName);
        }
        catch (MalformedURLException e) {
            this.mURL = new File(aUrlOrFileName).toURL();
        }
        this.mInputStream = this.mURL.openStream();
    }

    public XMLInputSource(InputStream aInputStream, File aRelativePathBase) {
        this.mInputStream = aInputStream;
        try {
            this.mURL = aRelativePathBase == null ? null : aRelativePathBase.toURL();
        }
        catch (MalformedURLException e) {
            throw new UIMARuntimeException(e);
        }
    }

    public XMLInputSource(URL aURL) throws IOException {
        this.mURL = aURL;
        this.mInputStream = aURL.openStream();
    }

    public InputStream getInputStream() {
        return this.mInputStream;
    }

    public File getRelativePathBase() {
        String path = this.mURL.getPath();
        return new File(path).getParentFile();
    }

    public URL getURL() {
        return this.mURL;
    }

    public void close() throws IOException {
        if (this.mInputStream != null) {
            this.mInputStream.close();
        }
        this.mURL = null;
    }
}

