/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.ProcessTraceEvent;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.impl.ProcessTraceEvent_impl;

public class ProcessTrace_impl
implements ProcessTrace {
    private static final long serialVersionUID = 7566277176545062757L;
    private List mEventList = new ArrayList();
    private Stack mOpenEvents = new Stack();
    private UimaTimer mTimer;
    private boolean mEnabled;

    public ProcessTrace_impl() {
        this(UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public ProcessTrace_impl(Properties aPerformanceTuningSettings) {
        if (aPerformanceTuningSettings == null) {
            aPerformanceTuningSettings = UIMAFramework.getDefaultPerformanceTuningProperties();
        }
        this.mEnabled = "true".equalsIgnoreCase(aPerformanceTuningSettings.getProperty("process_trace_enabled"));
        if (this.mEnabled) {
            this.mTimer = UIMAFramework.newTimer();
        }
    }

    public ProcessTrace_impl(UimaTimer aTimer) {
        this(aTimer, UIMAFramework.getDefaultPerformanceTuningProperties());
    }

    public ProcessTrace_impl(UimaTimer aTimer, Properties aPerformanceTuningSettings) {
        this.mTimer = aTimer;
        if (aPerformanceTuningSettings == null) {
            aPerformanceTuningSettings = UIMAFramework.getDefaultPerformanceTuningProperties();
        }
        this.mEnabled = "true".equalsIgnoreCase(aPerformanceTuningSettings.getProperty("process_trace_enabled"));
    }

    public void startEvent(String aComponentName, String aEventType, String aDescription) {
        if (this.mEnabled) {
            ProcessTraceEvent_impl evt = new ProcessTraceEvent_impl(aComponentName, aEventType, aDescription);
            evt.setStartTime(this.mTimer.getTimeInMillis());
            this.mOpenEvents.push(evt);
        }
    }

    public void endEvent(String aComponentName, String aEventType, String aResultMessage) {
        if (this.mEnabled) {
            ArrayList<ProcessTraceEvent_impl> eventsToClose = new ArrayList<ProcessTraceEvent_impl>();
            boolean foundEvent = false;
            while (!this.mOpenEvents.isEmpty()) {
                ProcessTraceEvent_impl evt = (ProcessTraceEvent_impl)this.mOpenEvents.pop();
                eventsToClose.add(evt);
                if (!aComponentName.equals(evt.getComponentName()) || !aEventType.equals(evt.getType())) continue;
                foundEvent = true;
                break;
            }
            if (foundEvent) {
                long currentTime = this.mTimer.getTimeInMillis();
                for (int i = 0; i < eventsToClose.size(); ++i) {
                    ProcessTraceEvent_impl subEvt = (ProcessTraceEvent_impl)eventsToClose.get(i);
                    subEvt.setResultMessage(aResultMessage);
                    subEvt.setDuration((int)(currentTime - subEvt.getStartTime()));
                    ProcessTraceEvent_impl owner = null;
                    if (i < eventsToClose.size() - 1) {
                        owner = (ProcessTraceEvent_impl)eventsToClose.get(i + 1);
                    } else if (!this.mOpenEvents.isEmpty()) {
                        owner = (ProcessTraceEvent_impl)this.mOpenEvents.peek();
                    }
                    if (owner != null) {
                        owner.addSubEvent(subEvt);
                        continue;
                    }
                    this.mEventList.add(subEvt);
                }
            } else {
                for (int i = 0; i < eventsToClose.size(); ++i) {
                    this.mOpenEvents.push(eventsToClose.get(i));
                }
                throw new UIMA_IllegalStateException("required_method_call", new Object[]{"startEvent", "endEvent"});
            }
        }
    }

    public void addEvent(String aComponentName, String aType, String aDescription, int aDuration, String aResultMsg) {
        if (this.mEnabled) {
            ProcessTraceEvent_impl evt = new ProcessTraceEvent_impl(aComponentName, aType, aDescription);
            evt.setDuration(aDuration);
            evt.setResultMessage(aResultMsg);
            this.addEvent(evt);
        }
    }

    public void addEvent(ProcessTraceEvent aEvent) {
        if (this.mEnabled) {
            if (!this.mOpenEvents.isEmpty()) {
                ProcessTraceEvent_impl owner = (ProcessTraceEvent_impl)this.mOpenEvents.peek();
                owner.addSubEvent(aEvent);
            } else {
                this.mEventList.add(aEvent);
            }
        }
    }

    public void addAll(List aEventList) {
        for (ProcessTraceEvent evt : aEventList) {
            this.addEvent(evt);
        }
    }

    public List getEvents() {
        return this.mEventList;
    }

    public List getEventsByComponentName(String aComponentName, boolean aRecurseAfterMatch) {
        ArrayList result = new ArrayList();
        for (ProcessTraceEvent event : this.getEvents()) {
            this.getEventsByComponentName(event, aComponentName, aRecurseAfterMatch, result);
        }
        return result;
    }

    public List getEventsByType(String aType, boolean aRecurseAfterMatch) {
        ArrayList result = new ArrayList();
        for (ProcessTraceEvent event : this.getEvents()) {
            this.getEventsByType(event, aType, aRecurseAfterMatch, result);
        }
        return result;
    }

    public ProcessTraceEvent getEvent(String aComponentName, String aType) {
        List events = this.getEvents();
        return this.getEvent(events, aComponentName, aType);
    }

    protected ProcessTraceEvent getEvent(List aEvents, String aComponentName, String aType) {
        for (ProcessTraceEvent event : aEvents) {
            if (aComponentName.equals(event.getComponentName()) && aType.equals(event.getType())) {
                return event;
            }
            ProcessTraceEvent matchingSubEvt = this.getEvent(event.getSubEvents(), aComponentName, aType);
            if (matchingSubEvt == null) continue;
            return matchingSubEvt;
        }
        return null;
    }

    public void clear() {
        this.mEventList.clear();
    }

    public void aggregate(ProcessTrace aProcessTrace) {
        if (this.mEnabled) {
            List newEventList = aProcessTrace.getEvents();
            for (ProcessTraceEvent_impl newEvt : newEventList) {
                ProcessTraceEvent_impl correspondingEvt = this.findCorrespondingEvent(this.mEventList, newEvt);
                if (correspondingEvt != null) {
                    this.aggregateEvent(correspondingEvt, newEvt);
                    continue;
                }
                this.mEventList.add(newEvt);
            }
        }
    }

    public String toString() {
        int totalTime = 0;
        for (ProcessTraceEvent event : this.mEventList) {
            totalTime += event.getDuration();
        }
        StringBuffer buf = new StringBuffer();
        for (ProcessTraceEvent event : this.mEventList) {
            event.toString(buf, 0, totalTime);
        }
        return buf.toString();
    }

    protected void getEventsByComponentName(ProcessTraceEvent aEvent, String aComponentName, boolean aRecurseAfterMatch, List aResultList) {
        if (aComponentName.equals(aEvent.getComponentName())) {
            aResultList.add(aEvent);
            if (!aRecurseAfterMatch) {
                return;
            }
        }
        for (ProcessTraceEvent event : aEvent.getSubEvents()) {
            this.getEventsByComponentName(event, aComponentName, aRecurseAfterMatch, aResultList);
        }
    }

    protected void getEventsByType(ProcessTraceEvent aEvent, String aType, boolean aRecurseAfterMatch, List aResultList) {
        if (aType.equals(aEvent.getType())) {
            aResultList.add(aEvent);
            if (!aRecurseAfterMatch) {
                return;
            }
        }
        for (ProcessTraceEvent event : aEvent.getSubEvents()) {
            this.getEventsByType(event, aType, aRecurseAfterMatch, aResultList);
        }
    }

    protected ProcessTraceEvent_impl findCorrespondingEvent(List aEventList, ProcessTraceEvent_impl aEvent) {
        for (ProcessTraceEvent_impl evt : aEventList) {
            if (!evt.getComponentName().equals(aEvent.getComponentName()) || !evt.getType().equals(aEvent.getType())) continue;
            return evt;
        }
        return null;
    }

    protected void aggregateEvent(ProcessTraceEvent_impl aDest, ProcessTraceEvent_impl aSrc) {
        aDest.addToDuration(aSrc.getDuration());
        aDest.setResultMessage(aSrc.getResultMessage());
        List destEventList = aDest.getSubEvents();
        List srcEventList = aSrc.getSubEvents();
        ArrayList<ProcessTraceEvent_impl> eventsToAdd = null;
        for (ProcessTraceEvent_impl srcEvt : srcEventList) {
            ProcessTraceEvent_impl correspondingEvt = this.findCorrespondingEvent(destEventList, srcEvt);
            if (correspondingEvt != null) {
                this.aggregateEvent(correspondingEvt, srcEvt);
                continue;
            }
            if (eventsToAdd == null) {
                eventsToAdd = new ArrayList<ProcessTraceEvent_impl>();
            }
            eventsToAdd.add(srcEvt);
        }
        if (eventsToAdd != null) {
            Iterator it = eventsToAdd.iterator();
            while (it.hasNext()) {
                aDest.addSubEvent((ProcessTraceEvent)it.next());
            }
        }
    }
}

