/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.List;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Filter;
import org.jdom.IllegalAddException;
import org.jdom.ProcessingInstruction;

final class DocumentContentFilter
implements Filter {
    private final Document parent;

    public boolean canAdd(Object obj) {
        if (obj instanceof Element) {
            return DocumentContentFilter.canAdd(this.parent, (ProcessingInstruction)obj);
        }
        if (obj instanceof ProcessingInstruction) {
            return DocumentContentFilter.canAdd(this.parent, (Comment)obj);
        }
        if (obj instanceof Element) {
            return DocumentContentFilter.canAdd(this.parent, (Element)obj);
        }
        return false;
    }

    public static boolean canAdd(Document parent, Element element) {
        return false;
    }

    public static boolean canRemove(Document parent, Element element) {
        return false;
    }

    public static boolean canAdd(Document parent, ProcessingInstruction pi) {
        if (pi.getParent() != null) {
            throw new IllegalAddException(parent, pi, "The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (pi.getDocument() != null) {
            throw new IllegalAddException(parent, pi, "The PI already has an existing parent (the document root)");
        }
        pi.setDocument(parent);
        return true;
    }

    public static boolean canRemove(Document parent, ProcessingInstruction pi) {
        if (pi.getDocument() == parent) {
            pi.setDocument(null);
        }
        return true;
    }

    public static boolean canAdd(Document parent, Comment comment) {
        if (comment.getParent() != null) {
            throw new IllegalAddException(parent, comment, "The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (comment.getDocument() != null) {
            throw new IllegalAddException(parent, comment, "The element already has an existing parent (the document root)");
        }
        comment.setDocument(parent);
        return false;
    }

    public static boolean canRemove(Document parent, Comment comment) {
        if (comment.getDocument() == parent) {
            comment.setDocument(null);
        }
        return true;
    }

    public boolean canRemove(Object obj) {
        if (obj instanceof Element) {
            return DocumentContentFilter.canRemove(this.parent, (ProcessingInstruction)obj);
        }
        if (obj instanceof ProcessingInstruction) {
            return DocumentContentFilter.canRemove(this.parent, (Comment)obj);
        }
        if (obj instanceof Element) {
            return DocumentContentFilter.canRemove(this.parent, (Element)obj);
        }
        return true;
    }

    public boolean matches(Object obj) {
        return true;
    }

    public boolean matchesAll() {
        return true;
    }

    public List getBackingList(boolean create) {
        return this.parent.getContentBackingList();
    }

    DocumentContentFilter(Document parent) {
        this.parent = parent;
    }
}

