/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.List;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Filter;
import org.jdom.IllegalAddException;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

final class ElementContentFilter
implements Filter {
    private final Element parent;

    public boolean canAdd(Object obj) {
        if (obj instanceof Element) {
            return ElementContentFilter.canAdd(this.parent, (Element)obj);
        }
        if (obj instanceof Text) {
            return ElementContentFilter.canAdd(this.parent, (Text)obj);
        }
        if (obj instanceof Comment) {
            return ElementContentFilter.canAdd(this.parent, (Comment)obj);
        }
        if (obj instanceof ProcessingInstruction) {
            return ElementContentFilter.canAdd(this.parent, (ProcessingInstruction)obj);
        }
        if (obj instanceof CDATA) {
            return ElementContentFilter.canAdd(this.parent, (CDATA)obj);
        }
        if (obj instanceof EntityRef) {
            return ElementContentFilter.canAdd(this.parent, (EntityRef)obj);
        }
        return false;
    }

    public boolean canRemove(Object obj) {
        if (obj instanceof Element) {
            return ElementContentFilter.canRemove(this.parent, (Element)obj);
        }
        if (obj instanceof Text) {
            return ElementContentFilter.canRemove(this.parent, (Text)obj);
        }
        if (obj instanceof Comment) {
            return ElementContentFilter.canRemove(this.parent, (Comment)obj);
        }
        if (obj instanceof ProcessingInstruction) {
            return ElementContentFilter.canRemove(this.parent, (ProcessingInstruction)obj);
        }
        if (obj instanceof CDATA) {
            return ElementContentFilter.canRemove(this.parent, (CDATA)obj);
        }
        if (obj instanceof EntityRef) {
            return ElementContentFilter.canRemove(this.parent, (EntityRef)obj);
        }
        return true;
    }

    public static boolean canAdd(Element parent, Element element) {
        if (element.isRootElement()) {
            throw new IllegalAddException(parent, element, "The element already has an existing parent (the document root)");
        }
        if (element.getParent() != null) {
            throw new IllegalAddException(parent, element, "The element already has an existing parent \"" + element.getParent().getQualifiedName() + "\"");
        }
        if (element == parent) {
            throw new IllegalAddException(parent, element, "The element cannot be added to itself");
        }
        if (parent.isAncestor(element)) {
            throw new IllegalAddException(parent, element, "The element cannot be added as a descendent of itself");
        }
        element.setParent(parent);
        return true;
    }

    public static boolean canRemove(Element parent, Element element) {
        if (parent == element.getParent()) {
            element.setParent(null);
        }
        return true;
    }

    public static boolean canAdd(Element parent, Text text) {
        if (text.getParent() != null) {
            throw new IllegalAddException(parent, text, "The Text node already has an existing parent \"" + text.getParent().getQualifiedName() + "\"");
        }
        text.setParent(parent);
        return true;
    }

    public static boolean canRemove(Element parent, Text text) {
        if (parent == text.getParent()) {
            text.setParent(null);
        }
        return true;
    }

    public static boolean canAdd(Element parent, Comment comment) {
        if (comment.getParent() != null) {
            throw new IllegalAddException(parent, comment, "The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (comment.getDocument() != null) {
            throw new IllegalAddException(parent, comment, "The comment already has an existing parent (the document root)");
        }
        comment.setParent(parent);
        return true;
    }

    public static boolean canRemove(Element parent, Comment comment) {
        if (parent == comment.getParent()) {
            comment.setParent(null);
        }
        return true;
    }

    public static boolean canAdd(Element parent, ProcessingInstruction pi) {
        if (pi.getParent() != null) {
            throw new IllegalAddException(parent, pi, "The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (pi.getDocument() != null) {
            throw new IllegalAddException(parent, pi, "The PI already has an existing parent (the document root)");
        }
        pi.setParent(parent);
        return true;
    }

    public static boolean canRemove(Element parent, ProcessingInstruction pi) {
        if (parent == pi.getParent()) {
            pi.setParent(null);
        }
        return true;
    }

    public static boolean canAdd(Element parent, CDATA cdata) {
        if (cdata.getParent() != null) {
            throw new IllegalAddException(parent, cdata, "The CDATA section already has an existing parent \"" + cdata.getParent().getQualifiedName() + "\"");
        }
        cdata.setParent(parent);
        return true;
    }

    public static boolean canRemove(Element parent, CDATA cdata) {
        if (parent == cdata.getParent()) {
            cdata.setParent(null);
        }
        return true;
    }

    public static boolean canAdd(Element parent, EntityRef entity) {
        if (entity.getParent() != null) {
            throw new IllegalAddException(parent, entity, "The entity reference already has an existing parent \"" + entity.getParent().getQualifiedName() + "\"");
        }
        entity.setParent(parent);
        return true;
    }

    public static boolean canRemove(Element parent, EntityRef entity) {
        if (parent == entity.getParent()) {
            entity.setParent(null);
        }
        return true;
    }

    public boolean matches(Object obj) {
        return true;
    }

    public boolean matchesAll() {
        return true;
    }

    public List getBackingList(boolean create) {
        return this.parent.getContentBackingList(create);
    }

    ElementContentFilter(Element parent) {
        this.parent = parent;
    }
}

