/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class XMLOutputter
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: XMLOutputter.java,v $ $Revision: 1.68 $ $Date: 2002/01/08 09:17:10 $ $Name:  $";
    protected static final String STANDARD_INDENT = "  ";
    protected static final String STANDARD_LINE_SEPARATOR = "\r\n";
    private boolean omitDeclaration = false;
    private String encoding = "UTF-8";
    private boolean omitEncoding = false;
    private String indent = null;
    private boolean expandEmptyElements = false;
    private boolean newlines = false;
    private String lineSeparator = "\r\n";
    private boolean textNormalize = false;
    private static /* synthetic */ Class class$Lorg$jdom$CDATA;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Lorg$jdom$Comment;
    private static /* synthetic */ Class class$Lorg$jdom$Element;
    private static /* synthetic */ Class class$Lorg$jdom$EntityRef;
    private static /* synthetic */ Class class$Lorg$jdom$ProcessingInstruction;

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public void setNewlines(boolean newlines) {
        this.newlines = newlines;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
    }

    public void setOmitDeclaration(boolean omitDeclaration) {
        this.omitDeclaration = omitDeclaration;
    }

    public void setExpandEmptyElements(boolean expandEmptyElements) {
        this.expandEmptyElements = expandEmptyElements;
    }

    public void setTextNormalize(boolean textNormalize) {
        this.textNormalize = textNormalize;
    }

    public void setIndent(String indent) {
        if ("".equals(indent)) {
            indent = null;
        }
        this.indent = indent;
    }

    public void setIndent(boolean doIndent) {
        this.indent = doIndent ? STANDARD_INDENT : null;
    }

    public void setIndentSize(int indentSize) {
        StringBuffer indentBuffer = new StringBuffer();
        int i = 0;
        while (i < indentSize) {
            indentBuffer.append(" ");
            ++i;
        }
        this.indent = indentBuffer.toString();
    }

    protected void indent(Writer out, int level) throws IOException {
        if (this.indent != null && !this.indent.equals("")) {
            int i = 0;
            while (i < level) {
                out.write(this.indent);
                ++i;
            }
        }
    }

    protected void maybePrintln(Writer out) throws IOException {
        this.maybePrintln(out, 0);
    }

    protected void maybePrintln(Writer out, int indentLevel) throws IOException {
        if (this.newlines) {
            out.write(this.lineSeparator);
        }
        this.indent(out, indentLevel);
    }

    protected Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        return this.makeWriter(out, this.encoding);
    }

    protected Writer makeWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
        if ("UTF-8".equals(enc)) {
            enc = "UTF8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), enc));
        return writer;
    }

    public void output(Document doc, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doc, writer);
    }

    public void output(Document doc, Writer out) throws IOException {
        this.printDeclaration(doc, out, this.encoding);
        if (doc.getDocType() != null) {
            this.printDocType(doc.getDocType(), out);
        }
        Iterator i = doc.getContent().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                this.printElement(doc.getRootElement(), out, 0, this.createNamespaceStack());
            } else if (obj instanceof Comment) {
                this.printComment((Comment)obj, out);
            } else if (obj instanceof ProcessingInstruction) {
                this.printProcessingInstruction((ProcessingInstruction)obj, out);
            }
            this.maybePrintln(out);
        }
        out.write(this.lineSeparator);
        out.flush();
    }

    public void output(Element element, Writer out) throws IOException {
        this.printElement(element, out, 0, this.createNamespaceStack());
        out.flush();
    }

    public void output(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(element, writer);
    }

    public void outputElementContent(Element element, Writer out) throws IOException {
        List eltContent = element.getContent();
        this.printElementContent(element, out, 0, this.createNamespaceStack(), eltContent);
        out.flush();
    }

    public void outputElementContent(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.outputElementContent(element, writer);
    }

    public void output(CDATA cdata, Writer out) throws IOException {
        this.printCDATA(cdata, out);
        out.flush();
    }

    public void output(CDATA cdata, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(cdata, writer);
    }

    public void output(Comment comment, Writer out) throws IOException {
        this.printComment(comment, out);
        out.flush();
    }

    public void output(Comment comment, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(comment, writer);
    }

    public void output(String string, Writer out) throws IOException {
        this.printString(string, out);
        out.flush();
    }

    public void output(String string, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(string, writer);
    }

    public void output(Text text, Writer out) throws IOException {
        this.printString(text.getText(), out);
        out.flush();
    }

    public void output(Text text, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(text, writer);
    }

    public void output(EntityRef entity, Writer out) throws IOException {
        this.printEntityRef(entity, out);
        out.flush();
    }

    public void output(EntityRef entity, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(entity, writer);
    }

    public void output(ProcessingInstruction pi, Writer out) throws IOException {
        this.printProcessingInstruction(pi, out);
        out.flush();
    }

    public void output(ProcessingInstruction pi, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(pi, writer);
    }

    public void output(DocType doctype, Writer out) throws IOException {
        this.printDocType(doctype, out);
        out.flush();
    }

    public void output(DocType doctype, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doctype, writer);
    }

    public String outputString(Document doc) {
        StringWriter out = new StringWriter();
        try {
            this.output(doc, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Element element) {
        StringWriter out = new StringWriter();
        try {
            this.output(element, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(Comment comment) {
        StringWriter out = new StringWriter();
        try {
            this.output(comment, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(CDATA cdata) {
        StringWriter out = new StringWriter();
        try {
            this.output(cdata, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(ProcessingInstruction pi) {
        StringWriter out = new StringWriter();
        try {
            this.output(pi, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(DocType doctype) {
        StringWriter out = new StringWriter();
        try {
            this.output(doctype, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public String outputString(EntityRef entity) {
        StringWriter out = new StringWriter();
        try {
            this.output(entity, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    protected void printDeclaration(Document doc, Writer out, String encoding) throws IOException {
        if (!this.omitDeclaration) {
            out.write("<?xml version=\"1.0\"");
            if (!this.omitEncoding) {
                out.write(" encoding=\"" + encoding + "\"");
            }
            out.write("?>");
            out.write(this.lineSeparator);
        }
    }

    protected void printDocType(DocType docType, Writer out) throws IOException {
        if (docType == null) {
            return;
        }
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        boolean hasPublic = false;
        out.write("<!DOCTYPE ");
        out.write(docType.getElementName());
        if (publicID != null && !publicID.equals("")) {
            out.write(" PUBLIC \"");
            out.write(publicID);
            out.write("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                out.write(" SYSTEM");
            }
            out.write(" \"");
            out.write(systemID);
            out.write("\"");
        }
        if (docType.getInternalSubset() != null) {
            out.write(" [\n");
            out.write(docType.getInternalSubset());
            out.write("]");
        }
        out.write(">");
        out.write(this.lineSeparator);
    }

    protected void printComment(Comment comment, Writer out) throws IOException {
        out.write("<!--");
        out.write(comment.getText());
        out.write("-->");
    }

    protected void printProcessingInstruction(ProcessingInstruction pi, Writer out) throws IOException {
        String target = pi.getTarget();
        String rawData = pi.getData();
        if (!"".equals(rawData)) {
            out.write("<?");
            out.write(target);
            out.write(" ");
            out.write(rawData);
            out.write("?>");
        } else {
            out.write("<?");
            out.write(target);
            out.write("?>");
        }
    }

    protected void printCDATA(CDATA cdata, Writer out) throws IOException {
        out.write("<![CDATA[");
        out.write(cdata.getText());
        out.write("]]>");
    }

    protected void printText(Text text, Writer out) throws IOException {
        this.printString(text.getText(), out);
    }

    protected void printElement(Element element, Writer out, int indentLevel, NamespaceStack namespaces) throws IOException {
        List eltContent = element.getContent();
        out.write("<");
        out.write(element.getQualifiedName());
        int previouslyDeclaredNamespaces = namespaces.size();
        this.printElementNamespace(element, out, namespaces);
        this.printAdditionalNamespaces(element, out, namespaces);
        this.printAttributes(element.getAttributes(), element, out, namespaces);
        boolean stringOnly = true;
        Iterator itr = eltContent.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o instanceof Text || o instanceof CDATA) continue;
            stringOnly = false;
            break;
        }
        boolean empty = false;
        if (stringOnly) {
            String elementText;
            String string = elementText = this.textNormalize ? element.getTextNormalize() : element.getText();
            if (elementText == null || elementText.equals("")) {
                empty = true;
            }
        }
        if (empty) {
            if (!this.expandEmptyElements) {
                out.write(" />");
            } else {
                out.write("></");
                out.write(element.getQualifiedName());
                out.write(">");
            }
        } else {
            out.write(">");
            this.printElementContent(element, out, indentLevel + 1, namespaces, eltContent);
            out.write("</");
            out.write(element.getQualifiedName());
            out.write(">");
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
    }

    protected void printElementContent(Element element, Writer out, int indentLevel, NamespaceStack namespaces, List eltContent) throws IOException {
        boolean empty = eltContent.size() == 0;
        boolean stringOnly = true;
        if (!empty) {
            stringOnly = this.isStringOnly(eltContent);
        }
        if (stringOnly) {
            Class justOutput = null;
            boolean endedWithWhite = false;
            Iterator itr = eltContent.iterator();
            while (itr.hasNext()) {
                Object content = itr.next();
                if (content instanceof Text) {
                    String scontent = ((Text)content).getText();
                    if (justOutput == (class$Lorg$jdom$CDATA != null ? class$Lorg$jdom$CDATA : XMLOutputter.class$("org.jdom.CDATA")) && this.textNormalize && this.startsWithWhite(scontent)) {
                        out.write(" ");
                    }
                    this.printString(scontent, out);
                    endedWithWhite = this.endsWithWhite(scontent);
                    justOutput = class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String");
                    continue;
                }
                if (justOutput == (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) && this.textNormalize && endedWithWhite) {
                    out.write(" ");
                }
                this.printCDATA((CDATA)content, out);
                Class clazz = justOutput = class$Lorg$jdom$CDATA != null ? class$Lorg$jdom$CDATA : XMLOutputter.class$("org.jdom.CDATA");
            }
        } else {
            Object content = null;
            Class justOutput = null;
            boolean endedWithWhite = false;
            boolean wasFullyWhite = false;
            Iterator itr = eltContent.iterator();
            while (itr.hasNext()) {
                content = itr.next();
                if (content instanceof Comment) {
                    if (justOutput != (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) || !wasFullyWhite) {
                        this.maybePrintln(out, indentLevel);
                    }
                    this.printComment(content, out);
                    justOutput = class$Lorg$jdom$Comment != null ? class$Lorg$jdom$Comment : XMLOutputter.class$("org.jdom.Comment");
                    continue;
                }
                if (content instanceof Text) {
                    String scontent = ((Text)content).getText();
                    if (this.textNormalize && this.isWhitespace(scontent)) {
                        wasFullyWhite = true;
                        continue;
                    }
                    if (justOutput == (class$Lorg$jdom$CDATA != null ? class$Lorg$jdom$CDATA : XMLOutputter.class$("org.jdom.CDATA")) && this.textNormalize && this.startsWithWhite(scontent)) {
                        out.write(" ");
                    } else if (justOutput != (class$Lorg$jdom$CDATA != null ? class$Lorg$jdom$CDATA : XMLOutputter.class$("org.jdom.CDATA")) && justOutput != (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) && justOutput != null) {
                        this.maybePrintln(out, indentLevel);
                    }
                    if (scontent.length() == 1 && STANDARD_LINE_SEPARATOR.indexOf(scontent.charAt(0)) != -1) continue;
                    this.printString(scontent, out);
                    endedWithWhite = this.endsWithWhite(scontent);
                    justOutput = class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String");
                    wasFullyWhite = scontent.trim().length() == 0;
                    continue;
                }
                if (content instanceof Element) {
                    if (justOutput != (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) || !wasFullyWhite) {
                        this.maybePrintln(out, indentLevel);
                    }
                    this.printElement(content, out, indentLevel, namespaces);
                    justOutput = class$Lorg$jdom$Element != null ? class$Lorg$jdom$Element : XMLOutputter.class$("org.jdom.Element");
                    continue;
                }
                if (content instanceof EntityRef) {
                    if (justOutput != (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) || !wasFullyWhite) {
                        this.maybePrintln(out, indentLevel);
                    }
                    this.printEntityRef(content, out);
                    justOutput = class$Lorg$jdom$EntityRef != null ? class$Lorg$jdom$EntityRef : XMLOutputter.class$("org.jdom.EntityRef");
                    continue;
                }
                if (content instanceof ProcessingInstruction) {
                    if (justOutput != (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) || !wasFullyWhite) {
                        this.maybePrintln(out, indentLevel);
                    }
                    this.printProcessingInstruction(content, out);
                    justOutput = class$Lorg$jdom$ProcessingInstruction != null ? class$Lorg$jdom$ProcessingInstruction : XMLOutputter.class$("org.jdom.ProcessingInstruction");
                    continue;
                }
                if (!(content instanceof CDATA)) continue;
                if (justOutput == (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) && this.textNormalize && endedWithWhite) {
                    out.write(" ");
                } else if (justOutput != (class$Ljava$lang$String != null ? class$Ljava$lang$String : XMLOutputter.class$("java.lang.String")) && justOutput != (class$Lorg$jdom$CDATA != null ? class$Lorg$jdom$CDATA : XMLOutputter.class$("org.jdom.CDATA"))) {
                    this.maybePrintln(out, indentLevel);
                }
                this.printCDATA(content, out);
                Class clazz = justOutput = class$Lorg$jdom$CDATA != null ? class$Lorg$jdom$CDATA : XMLOutputter.class$("org.jdom.CDATA");
            }
            this.maybePrintln(out, indentLevel - 1);
        }
    }

    protected void printString(String s, Writer out) throws IOException {
        s = this.escapeElementEntities(s);
        if (this.textNormalize) {
            StringTokenizer tokenizer = new StringTokenizer(s);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                out.write(token);
                if (!tokenizer.hasMoreTokens()) continue;
                out.write(" ");
            }
        } else {
            out.write(s);
        }
    }

    protected void printEntityRef(EntityRef entity, Writer out) throws IOException {
        out.write("&" + entity.getName() + ";");
    }

    private void printNamespace(Namespace ns, Writer out) throws IOException {
        out.write(" xmlns");
        String prefix = ns.getPrefix();
        if (!prefix.equals("")) {
            out.write(":");
            out.write(prefix);
        }
        out.write("=\"");
        out.write(ns.getURI());
        out.write("\"");
    }

    protected void printAttributes(List attributes, Element parent, Writer out, NamespaceStack namespaces) throws IOException {
        Iterator itr = attributes.iterator();
        while (itr.hasNext()) {
            Attribute attribute = (Attribute)itr.next();
            Namespace ns = attribute.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                String prefix = ns.getPrefix();
                String uri = namespaces.getURI(prefix);
                if (!ns.getURI().equals(uri)) {
                    this.printNamespace(ns, out);
                    namespaces.push(ns);
                }
            }
            out.write(" ");
            out.write(attribute.getQualifiedName());
            out.write("=");
            out.write("\"");
            out.write(this.escapeAttributeEntities(attribute.getValue()));
            out.write("\"");
        }
    }

    private void printElementNamespace(Element element, Writer out, NamespaceStack namespaces) throws IOException {
        Namespace ns = element.getNamespace();
        if (ns != Namespace.XML_NAMESPACE && (ns != Namespace.NO_NAMESPACE || namespaces.getURI("") != null)) {
            String prefix = ns.getPrefix();
            String uri = namespaces.getURI(prefix);
            if (!ns.getURI().equals(uri)) {
                namespaces.push(ns);
                this.printNamespace(ns, out);
            }
        }
    }

    private void printAdditionalNamespaces(Element element, Writer out, NamespaceStack namespaces) throws IOException {
        List additionalNamespaces = element.getAdditionalNamespaces();
        if (additionalNamespaces != null) {
            Iterator itr = additionalNamespaces.iterator();
            while (itr.hasNext()) {
                Namespace additional = (Namespace)itr.next();
                String prefix = additional.getPrefix();
                String uri = namespaces.getURI(prefix);
                if (additional.getURI().equals(uri)) continue;
                namespaces.push(additional);
                this.printNamespace(additional, out);
            }
        }
    }

    protected String escapeAttributeEntities(String st) {
        StringBuffer buff = null;
        int length = st.length();
        String stEntity = null;
        int i = 0;
        int last = 0;
        while (i < length) {
            switch (st.charAt(i)) {
                case '<': {
                    stEntity = "&lt;";
                    break;
                }
                case '>': {
                    stEntity = "&gt;";
                    break;
                }
                case '\"': {
                    stEntity = "&quot;";
                    break;
                }
                case '&': {
                    stEntity = "&amp;";
                    break;
                }
            }
            if (stEntity != null) {
                if (buff == null) {
                    buff = new StringBuffer(length + 20);
                }
                buff.append(st.substring(last, i));
                buff.append(stEntity);
                stEntity = null;
                last = i + 1;
            }
            ++i;
        }
        if (buff != null) {
            if (last < length) {
                buff.append(st.substring(last, i));
            }
            return buff.toString();
        }
        return st;
    }

    protected String escapeElementEntities(String st) {
        StringBuffer buff = null;
        int length = st.length();
        String stEntity = null;
        int i = 0;
        int last = 0;
        while (i < length) {
            switch (st.charAt(i)) {
                case '<': {
                    stEntity = "&lt;";
                    break;
                }
                case '>': {
                    stEntity = "&gt;";
                    break;
                }
                case '&': {
                    stEntity = "&amp;";
                    break;
                }
            }
            if (stEntity != null) {
                if (buff == null) {
                    buff = new StringBuffer(length + 20);
                }
                buff.append(st.substring(last, i));
                buff.append(stEntity);
                stEntity = null;
                last = i + 1;
            }
            ++i;
        }
        if (buff != null) {
            if (last < length) {
                buff.append(st.substring(last, i));
            }
            return buff.toString();
        }
        return st;
    }

    public int parseArgs(String[] args, int i) {
        while (i < args.length) {
            if (args[i].equals("-omitDeclaration")) {
                this.setOmitDeclaration(true);
            } else if (args[i].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (args[i].equals("-indent")) {
                this.setIndent(args[++i]);
            } else if (args[i].equals("-indentSize")) {
                this.setIndentSize(Integer.parseInt(args[++i]));
            } else if (args[i].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (args[i].equals("-encoding")) {
                this.setEncoding(args[++i]);
            } else if (args[i].equals("-newlines")) {
                this.setNewlines(true);
            } else if (args[i].equals("-lineSeparator")) {
                this.setLineSeparator(args[++i]);
            } else if (args[i].equals("-textNormalize")) {
                this.setTextNormalize(true);
            } else {
                return i;
            }
            ++i;
        }
        return i;
    }

    private boolean startsWithWhite(String s) {
        return s.length() > 0 && s.charAt(0) <= ' ';
    }

    private boolean endsWithWhite(String s) {
        return s.length() > 0 && s.charAt(s.length() - 1) <= ' ';
    }

    private boolean isWhitespace(String s) {
        int length = s.length();
        int i = 0;
        while (i < length) {
            if (" \t\n\r".indexOf(s.charAt(i)) == -1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String getElementText(Element element) {
        return this.textNormalize ? element.getTextNormalize() : element.getText();
    }

    private boolean isEmpty(Element element) {
        String elementText;
        List eltContent = element.getContent();
        if (eltContent.size() == 0) {
            return true;
        }
        return this.isStringOnly(eltContent) && ((elementText = this.getElementText(element)) == null || elementText.equals(""));
    }

    private boolean isStringOnly(List eltContent) {
        Iterator itr = eltContent.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (o instanceof Text || o instanceof CDATA) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "XMLOutputter[omitDeclaration = " + this.omitDeclaration + ", " + "encoding = " + this.encoding + ", " + "omitEncoding = " + this.omitEncoding + ", " + "indent = '" + this.indent + "'" + ", " + "expandEmptyElements = " + this.expandEmptyElements + ", " + "newlines = " + this.newlines + ", " + "lineSeparator = '" + this.toBytes(this.lineSeparator) + "', " + "textNormalize = " + this.textNormalize + "]";
    }

    private String toBytes(String x) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < x.length()) {
            buf.append(this.toByte(x.charAt(i)));
            ++i;
        }
        return buf.toString();
    }

    private String toByte(char ch) {
        switch (ch) {
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
        }
        return "[" + ch + "]";
    }

    protected NamespaceStack createNamespaceStack() {
        XMLOutputter xMLOutputter = this;
        if (xMLOutputter == null) {
            throw null;
        }
        return xMLOutputter.new NamespaceStack();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public XMLOutputter() {
    }

    public XMLOutputter(String indent) {
        this.indent = indent;
    }

    public XMLOutputter(String indent, boolean newlines) {
        this.indent = indent;
        this.newlines = newlines;
    }

    public XMLOutputter(String indent, boolean newlines, String encoding) {
        this.indent = indent;
        this.newlines = newlines;
        this.encoding = encoding;
    }

    public XMLOutputter(XMLOutputter that) {
        this.omitDeclaration = that.omitDeclaration;
        this.omitEncoding = that.omitEncoding;
        this.indent = that.indent;
        this.expandEmptyElements = that.expandEmptyElements;
        this.newlines = that.newlines;
        this.encoding = that.encoding;
        this.lineSeparator = that.lineSeparator;
        this.textNormalize = that.textNormalize;
    }

    protected class NamespaceStack
    extends org.jdom.output.NamespaceStack {
        NamespaceStack() {
        }
    }
}

