/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.server;

import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMethod;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.netty.ByteBufFlux;
import io.micrometer.shaded.reactor.netty.http.server.DefaultHttpServerRoutes;
import io.micrometer.shaded.reactor.netty.http.server.HttpPredicate;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerOperations;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerRequest;
import io.micrometer.shaded.reactor.netty.http.server.HttpServerResponse;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketInbound;
import io.micrometer.shaded.reactor.netty.http.websocket.WebsocketOutbound;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public interface HttpServerRoutes
extends BiFunction<HttpServerRequest, HttpServerResponse, Publisher<Void>> {
    public static final Predicate<HttpServerRequest> INDEX_PREDICATE = req -> {
        URI uri = URI.create(req.uri());
        return Objects.equals(req.method(), HttpMethod.GET) && (uri.getPath().endsWith("/") || uri.getPath().indexOf(".", uri.getPath().lastIndexOf("/")) == -1);
    };

    public static HttpServerRoutes newRoutes() {
        return new DefaultHttpServerRoutes();
    }

    default public HttpServerRoutes delete(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.delete(path), handler);
    }

    default public HttpServerRoutes directory(String uri, Path directory) {
        return this.directory(uri, directory, null);
    }

    public HttpServerRoutes directory(String var1, Path var2, @Nullable Function<HttpServerResponse, HttpServerResponse> var3);

    default public HttpServerRoutes file(String uri, Path path) {
        return this.file(HttpPredicate.get(uri), path, null);
    }

    default public HttpServerRoutes file(String uri, String path) {
        return this.file(HttpPredicate.get(uri), Paths.get(path, new String[0]), null);
    }

    default public HttpServerRoutes file(Predicate<HttpServerRequest> uri, Path path, @Nullable Function<HttpServerResponse, HttpServerResponse> interceptor) {
        Objects.requireNonNull(path, "path");
        return this.route(uri, (req, resp) -> {
            if (!Files.isReadable(path)) {
                return resp.send(ByteBufFlux.fromPath(path));
            }
            if (interceptor != null) {
                return ((HttpServerResponse)interceptor.apply((HttpServerResponse)resp)).sendFile(path);
            }
            return resp.sendFile(path);
        });
    }

    default public HttpServerRoutes get(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.get(path), handler);
    }

    default public HttpServerRoutes head(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.head(path), handler);
    }

    default public HttpServerRoutes index(BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(INDEX_PREDICATE, handler);
    }

    default public HttpServerRoutes options(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.options(path), handler);
    }

    default public HttpServerRoutes post(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.post(path), handler);
    }

    default public HttpServerRoutes put(String path, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> handler) {
        return this.route(HttpPredicate.put(path), handler);
    }

    public HttpServerRoutes route(Predicate<? super HttpServerRequest> var1, BiFunction<? super HttpServerRequest, ? super HttpServerResponse, ? extends Publisher<Void>> var2);

    default public HttpServerRoutes ws(String path, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler) {
        return this.ws(path, handler, null);
    }

    default public HttpServerRoutes ws(String path, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler, @Nullable String protocols) {
        return this.ws(HttpPredicate.get(path), handler, protocols);
    }

    default public HttpServerRoutes ws(Predicate<? super HttpServerRequest> condition, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler, @Nullable String protocols) {
        return this.ws(condition, handler, protocols, 65536);
    }

    default public HttpServerRoutes ws(Predicate<? super HttpServerRequest> condition, BiFunction<? super WebsocketInbound, ? super WebsocketOutbound, ? extends Publisher<Void>> handler, @Nullable String protocols, int maxFramePayloadLength) {
        return this.route(condition, (req, resp) -> {
            if (req.requestHeaders().contains(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
                HttpServerOperations ops = (HttpServerOperations)req;
                return ops.withWebsocketSupport(req.uri(), protocols, maxFramePayloadLength, handler);
            }
            return resp.sendNotFound();
        });
    }
}

