/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.bootstrap.ServerBootstrap;
import io.micrometer.shaded.io.netty.channel.Channel;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import io.micrometer.shaded.io.netty.handler.codec.http2.Http2SecurityUtil;
import io.micrometer.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import io.micrometer.shaded.io.netty.handler.ssl.OpenSsl;
import io.micrometer.shaded.io.netty.handler.ssl.SslContext;
import io.micrometer.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandler;
import io.micrometer.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.micrometer.shaded.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientSecure;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

public final class SslProvider {
    final SslContext sslContext;
    final SslContextBuilder sslContextBuilder;
    final DefaultConfigurationType type;
    final long handshakeTimeoutMillis;
    final long closeNotifyFlushTimeoutMillis;
    final long closeNotifyReadTimeoutMillis;
    final Consumer<? super SslHandler> handlerConfigurator;
    static final Logger log = Loggers.getLogger(SslProvider.class);

    public static SslContextSpec builder() {
        return new Build();
    }

    public static SslProvider addHandlerConfigurator(SslProvider provider, Consumer<? super SslHandler> handlerConfigurator) {
        Objects.requireNonNull(provider, "provider");
        Objects.requireNonNull(handlerConfigurator, "handlerConfigurator");
        return new SslProvider(provider, handlerConfigurator);
    }

    public static SslProvider updateDefaultConfiguration(SslProvider provider, DefaultConfigurationType type) {
        Objects.requireNonNull(provider, "provider");
        Objects.requireNonNull(type, "type");
        return new SslProvider(provider, type);
    }

    public static SslProvider defaultClientProvider() {
        return TcpClientSecure.DEFAULT_CLIENT_PROVIDER;
    }

    public static Bootstrap setBootstrap(Bootstrap b, SslProvider sslProvider) {
        BootstrapHandlers.updateConfiguration(b, "io.micrometer.shaded.reactor.left.sslHandler", new DeferredSslSupport(sslProvider));
        return b;
    }

    @Nullable
    public static SslProvider findSslSupport(Bootstrap b) {
        DeferredSslSupport ssl = BootstrapHandlers.findConfiguration(DeferredSslSupport.class, b.config().handler());
        if (ssl == null) {
            return null;
        }
        return ssl.sslProvider;
    }

    @Nullable
    public static SslProvider findSslSupport(ServerBootstrap b) {
        SslSupportConsumer ssl = BootstrapHandlers.findConfiguration(SslSupportConsumer.class, b.config().childHandler());
        if (ssl == null) {
            return null;
        }
        return ssl.sslProvider;
    }

    public static Bootstrap removeSslSupport(Bootstrap b) {
        BootstrapHandlers.removeConfiguration(b, "io.micrometer.shaded.reactor.left.sslHandler");
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SslProvider(Build builder) {
        this.sslContextBuilder = builder.sslCtxBuilder;
        this.type = builder.type;
        if (builder.sslContext == null) {
            if (this.sslContextBuilder == null) throw new IllegalArgumentException("Neither SslContextBuilder nor SslContext is specified");
            if (this.type != null) {
                this.updateDefaultConfiguration();
            }
            try {
                this.sslContext = this.sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw Exceptions.propagate(e);
            }
        } else {
            this.sslContext = builder.sslContext;
        }
        this.handlerConfigurator = builder.handlerConfigurator;
        this.handshakeTimeoutMillis = builder.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = builder.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = builder.closeNotifyReadTimeoutMillis;
    }

    SslProvider(SslProvider from, Consumer<? super SslHandler> handlerConfigurator) {
        this.sslContext = from.sslContext;
        this.sslContextBuilder = from.sslContextBuilder;
        this.type = from.type;
        this.handlerConfigurator = from.handlerConfigurator == null ? handlerConfigurator : h -> {
            handlerConfigurator.accept((SslHandler)h);
            from.handlerConfigurator.accept((SslHandler)h);
        };
        this.handshakeTimeoutMillis = from.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = from.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = from.closeNotifyReadTimeoutMillis;
    }

    SslProvider(SslProvider from, DefaultConfigurationType type) {
        this.sslContextBuilder = from.sslContextBuilder;
        this.type = type;
        if (this.sslContextBuilder != null) {
            this.updateDefaultConfiguration();
            try {
                this.sslContext = this.sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw Exceptions.propagate(e);
            }
        } else {
            this.sslContext = from.sslContext;
        }
        this.handlerConfigurator = from.handlerConfigurator;
        this.handshakeTimeoutMillis = from.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = from.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = from.closeNotifyReadTimeoutMillis;
    }

    void updateDefaultConfiguration() {
        switch (this.type) {
            case H2: {
                this.sslContextBuilder.ciphers(Http2SecurityUtil.CIPHERS, SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, "h2", "http/1.1"));
            }
            case TCP: {
                io.micrometer.shaded.io.netty.handler.ssl.SslProvider sslProvider = OpenSsl.isAlpnSupported() ? io.micrometer.shaded.io.netty.handler.ssl.SslProvider.OPENSSL : io.micrometer.shaded.io.netty.handler.ssl.SslProvider.JDK;
                this.sslContextBuilder.sslProvider(sslProvider);
                break;
            }
        }
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    @Nullable
    public DefaultConfigurationType getDefaultConfigurationType() {
        return this.type;
    }

    public void configure(SslHandler sslHandler) {
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        sslHandler.setCloseNotifyFlushTimeoutMillis(this.closeNotifyFlushTimeoutMillis);
        sslHandler.setCloseNotifyReadTimeoutMillis(this.closeNotifyReadTimeoutMillis);
        if (this.handlerConfigurator != null) {
            this.handlerConfigurator.accept(sslHandler);
        }
    }

    public String asSimpleString() {
        return this.toString();
    }

    public String asDetailedString() {
        return "handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", closeNotifyFlushTimeoutMillis=" + this.closeNotifyFlushTimeoutMillis + ", closeNotifyReadTimeoutMillis=" + this.closeNotifyReadTimeoutMillis;
    }

    public String toString() {
        return "SslProvider{" + this.asDetailedString() + "}";
    }

    static ServerBootstrap removeSslSupport(ServerBootstrap b) {
        BootstrapHandlers.removeConfiguration(b, "io.micrometer.shaded.reactor.left.sslHandler");
        return b;
    }

    public static ServerBootstrap setBootstrap(ServerBootstrap b, SslProvider sslProvider) {
        BootstrapHandlers.updateConfiguration(b, "io.micrometer.shaded.reactor.left.sslHandler", (BiConsumer<ConnectionObserver, ? super Channel>)new SslSupportConsumer(sslProvider, null));
        return b;
    }

    static final class SslReadHandler
    extends ChannelInboundHandlerAdapter {
        boolean handshakeDone;

        SslReadHandler() {
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!this.handshakeDone) {
                ctx.read();
            }
            super.channelReadComplete(ctx);
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshake;
                this.handshakeDone = true;
                if (ctx.pipeline().context(this) != null) {
                    ctx.pipeline().remove(this);
                }
                if ((handshake = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                    ctx.fireChannelActive();
                } else {
                    ctx.fireExceptionCaught(handshake.cause());
                }
            }
            super.userEventTriggered(ctx, evt);
        }
    }

    static final class SslSupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final SslProvider sslProvider;
        final InetSocketAddress sniInfo;

        SslSupportConsumer(SslProvider sslProvider, @Nullable SocketAddress sniInfo) {
            this.sslProvider = sslProvider;
            this.sniInfo = sniInfo instanceof InetSocketAddress ? (InetSocketAddress)sniInfo : null;
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            SslHandler sslHandler;
            if (this.sniInfo != null) {
                sslHandler = this.sslProvider.getSslContext().newHandler(channel.alloc(), this.sniInfo.getHostString(), this.sniInfo.getPort());
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(channel, "SSL enabled using engine {} and SNI {}"), sslHandler.engine().getClass().getSimpleName(), this.sniInfo);
                }
            } else {
                sslHandler = this.sslProvider.getSslContext().newHandler(channel.alloc());
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(channel, "SSL enabled using engine {}"), sslHandler.engine().getClass().getSimpleName());
                }
            }
            this.sslProvider.configure(sslHandler);
            if (channel.pipeline().get("io.micrometer.shaded.reactor.left.proxyHandler") != null) {
                channel.pipeline().addAfter("io.micrometer.shaded.reactor.left.proxyHandler", "io.micrometer.shaded.reactor.left.sslHandler", sslHandler);
            } else {
                channel.pipeline().addFirst("io.micrometer.shaded.reactor.left.sslHandler", (ChannelHandler)sslHandler);
            }
            if (channel.pipeline().get("io.micrometer.shaded.reactor.left.loggingHandler") != null) {
                channel.pipeline().addAfter("io.micrometer.shaded.reactor.left.loggingHandler", "io.micrometer.shaded.reactor.left.sslReader", new SslReadHandler());
            } else {
                channel.pipeline().addAfter("io.micrometer.shaded.reactor.left.sslHandler", "io.micrometer.shaded.reactor.left.sslReader", new SslReadHandler());
            }
        }
    }

    static final class DeferredSslSupport
    implements Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> {
        final SslProvider sslProvider;

        DeferredSslSupport(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
        }

        @Override
        public BiConsumer<ConnectionObserver, Channel> apply(Bootstrap bootstrap) {
            return new SslSupportConsumer(this.sslProvider, bootstrap.config().remoteAddress());
        }
    }

    static final class Build
    implements SslContextSpec,
    DefaultConfigurationSpec,
    Builder {
        static final long DEFAULT_SSL_HANDSHAKE_TIMEOUT = Long.parseLong(System.getProperty("io.micrometer.shaded.reactor.netty.tcp.sslHandshakeTimeout", "10000"));
        SslContextBuilder sslCtxBuilder;
        DefaultConfigurationType type;
        SslContext sslContext;
        Consumer<? super SslHandler> handlerConfigurator;
        long handshakeTimeoutMillis = DEFAULT_SSL_HANDSHAKE_TIMEOUT;
        long closeNotifyFlushTimeoutMillis = 3000L;
        long closeNotifyReadTimeoutMillis;

        Build() {
        }

        @Override
        public final Builder sslContext(SslContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            return this;
        }

        @Override
        public final DefaultConfigurationSpec sslContext(SslContextBuilder sslCtxBuilder) {
            this.sslCtxBuilder = Objects.requireNonNull(sslCtxBuilder, "sslCtxBuilder");
            return this;
        }

        @Override
        public final Builder defaultConfiguration(DefaultConfigurationType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public final Builder handshakeTimeout(Duration handshakeTimeout) {
            Objects.requireNonNull(handshakeTimeout, "handshakeTimeout");
            return this.handshakeTimeoutMillis(handshakeTimeout.toMillis());
        }

        @Override
        public final Builder handlerConfigurator(Consumer<? super SslHandler> handlerConfigurator) {
            Objects.requireNonNull(handlerConfigurator, "handshakeTimeout");
            this.handlerConfigurator = handlerConfigurator;
            return this;
        }

        @Override
        public final Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            if (handshakeTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl handshake timeout must be positive was: " + handshakeTimeoutMillis);
            }
            this.handshakeTimeoutMillis = handshakeTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            Objects.requireNonNull(closeNotifyFlushTimeout, "closeNotifyFlushTimeout");
            return this.closeNotifyFlushTimeoutMillis(closeNotifyFlushTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyFlushTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
            if (closeNotifyFlushTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify flush timeout must be positive, was: " + closeNotifyFlushTimeoutMillis);
            }
            this.closeNotifyFlushTimeoutMillis = closeNotifyFlushTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            Objects.requireNonNull(closeNotifyReadTimeout, "closeNotifyReadTimeout");
            return this.closeNotifyReadTimeoutMillis(closeNotifyReadTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyReadTimeoutMillis(long closeNotifyReadTimeoutMillis) {
            if (closeNotifyReadTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify read timeout must be positive, was: " + closeNotifyReadTimeoutMillis);
            }
            this.closeNotifyReadTimeoutMillis = closeNotifyReadTimeoutMillis;
            return this;
        }

        @Override
        public SslProvider build() {
            return new SslProvider(this);
        }
    }

    public static interface DefaultConfigurationSpec {
        public Builder defaultConfiguration(DefaultConfigurationType var1);
    }

    public static enum DefaultConfigurationType {
        NONE,
        TCP,
        H2;

    }

    public static interface SslContextSpec {
        public Builder sslContext(SslContext var1);

        public DefaultConfigurationSpec sslContext(SslContextBuilder var1);
    }

    public static interface Builder {
        public Builder handlerConfigurator(Consumer<? super SslHandler> var1);

        public Builder handshakeTimeout(Duration var1);

        public Builder handshakeTimeoutMillis(long var1);

        public Builder closeNotifyFlushTimeout(Duration var1);

        public Builder closeNotifyFlushTimeoutMillis(long var1);

        public Builder closeNotifyReadTimeout(Duration var1);

        public Builder closeNotifyReadTimeoutMillis(long var1);

        public SslProvider build();
    }
}

