/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.publisher.FluxFilter;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import java.util.Objects;
import java.util.function.Predicate;

final class MonoFilter<T>
extends MonoOperator<T, T> {
    final Predicate<? super T> predicate;

    MonoFilter(Mono<? extends T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        if (actual instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new FluxFilter.FilterConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)actual, this.predicate));
            return;
        }
        this.source.subscribe(new FluxFilter.FilterSubscriber<T>(actual, this.predicate));
    }
}

