/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Fuseable;
import io.micrometer.shaded.reactor.core.Scannable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoNameFuseable;
import io.micrometer.shaded.reactor.core.publisher.MonoOperator;
import io.micrometer.shaded.reactor.util.annotation.Nullable;
import io.micrometer.shaded.reactor.util.function.Tuple2;
import io.micrometer.shaded.reactor.util.function.Tuples;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

final class MonoName<T>
extends MonoOperator<T, T> {
    final String name;
    final Set<Tuple2<String, String>> tags;

    static <T> Mono<T> createOrAppend(Mono<T> source, String name) {
        Objects.requireNonNull(name, "name");
        if (source instanceof MonoName) {
            MonoName s = (MonoName)source;
            return new MonoName<T>(s.source, name, s.tags);
        }
        if (source instanceof MonoNameFuseable) {
            MonoNameFuseable s = (MonoNameFuseable)source;
            return new MonoNameFuseable(s.source, name, s.tags);
        }
        if (source instanceof Fuseable) {
            return new MonoNameFuseable<T>(source, name, null);
        }
        return new MonoName<T>(source, name, null);
    }

    static <T> Mono<T> createOrAppend(Mono<T> source, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Set<Tuple2<String, String>> tags = Collections.singleton(Tuples.of(tagName, tagValue));
        if (source instanceof MonoName) {
            MonoName s = (MonoName)source;
            if (s.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s.tags);
            }
            return new MonoName<T>(s.source, s.name, tags);
        }
        if (source instanceof MonoNameFuseable) {
            MonoNameFuseable s = (MonoNameFuseable)source;
            if (s.tags != null) {
                tags = new HashSet<Tuple2<String, String>>(tags);
                tags.addAll(s.tags);
            }
            return new MonoNameFuseable(s.source, s.name, tags);
        }
        if (source instanceof Fuseable) {
            return new MonoNameFuseable<T>(source, null, tags);
        }
        return new MonoName<T>(source, null, tags);
    }

    MonoName(Mono<? extends T> source, @Nullable String name, @Nullable Set<Tuple2<String, String>> tags) {
        super(source);
        this.name = name;
        this.tags = tags;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(actual);
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tags != null) {
            return this.tags.stream();
        }
        return super.scanUnsafe(key);
    }
}

