/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.core.publisher;

import io.micrometer.shaded.reactor.core.publisher.RingBuffer;
import io.micrometer.shaded.reactor.core.publisher.RingBufferProducer;
import java.util.function.Supplier;

abstract class NotFunRingBufferFields<E>
extends RingBuffer<E> {
    private final long indexMask;
    private final Object[] entries;
    final int bufferSize;
    final RingBufferProducer sequenceProducer;

    NotFunRingBufferFields(Supplier<E> eventFactory, RingBufferProducer sequenceProducer) {
        this.sequenceProducer = sequenceProducer;
        this.bufferSize = sequenceProducer.getBufferSize();
        this.indexMask = this.bufferSize - 1;
        this.entries = new Object[sequenceProducer.getBufferSize()];
        this.fill(eventFactory);
    }

    private void fill(Supplier<E> eventFactory) {
        for (int i = 0; i < this.bufferSize; ++i) {
            this.entries[i] = eventFactory.get();
        }
    }

    final E elementAt(long sequence) {
        return (E)this.entries[(int)(sequence & this.indexMask)];
    }
}

