/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.http.client;

import io.micrometer.shaded.io.netty.buffer.ByteBuf;
import io.micrometer.shaded.io.netty.buffer.ByteBufAllocator;
import io.micrometer.shaded.io.netty.buffer.ByteBufHolder;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelHandler;
import io.micrometer.shaded.io.netty.channel.ChannelHandlerContext;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.FullHttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpConstants;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpHeaders;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMessage;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpMethod;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpRequest;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponse;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpUtil;
import io.micrometer.shaded.io.netty.handler.codec.http.HttpVersion;
import io.micrometer.shaded.io.netty.handler.codec.http.LastHttpContent;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http.cookie.Cookie;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.micrometer.shaded.io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.micrometer.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.micrometer.shaded.io.netty.handler.stream.ChunkedWriteHandler;
import io.micrometer.shaded.io.netty.util.ReferenceCountUtil;
import io.micrometer.shaded.io.netty.util.ReferenceCounted;
import io.micrometer.shaded.org.reactorstreams.Publisher;
import io.micrometer.shaded.reactor.core.CoreSubscriber;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.Exceptions;
import io.micrometer.shaded.reactor.core.publisher.Flux;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.Operators;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.FutureMono;
import io.micrometer.shaded.reactor.netty.NettyInbound;
import io.micrometer.shaded.reactor.netty.NettyOutbound;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.http.Cookies;
import io.micrometer.shaded.reactor.netty.http.HttpOperations;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientForm;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientFormEncoder;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientRequest;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientResponse;
import io.micrometer.shaded.reactor.netty.http.client.HttpClientState;
import io.micrometer.shaded.reactor.netty.http.client.PrematureCloseException;
import io.micrometer.shaded.reactor.netty.http.client.RedirectClientException;
import io.micrometer.shaded.reactor.netty.http.client.WebsocketClientOperations;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;

class HttpClientOperations
extends HttpOperations<NettyInbound, NettyOutbound>
implements HttpClientResponse,
HttpClientRequest {
    final boolean isSecure;
    final HttpRequest nettyRequest;
    final HttpHeaders requestHeaders;
    final ClientCookieEncoder cookieEncoder;
    final ClientCookieDecoder cookieDecoder;
    Supplier<String>[] redirectedFrom = EMPTY_REDIRECTIONS;
    volatile ResponseState responseState;
    boolean started;
    BiPredicate<HttpClientRequest, HttpClientResponse> followRedirectPredicate;
    static final int MAX_REDIRECTS = 50;
    static final Supplier<String>[] EMPTY_REDIRECTIONS = new Supplier[0];
    static final Logger log = Loggers.getLogger(HttpClientOperations.class);

    HttpClientOperations(HttpClientOperations replaced) {
        super(replaced);
        this.started = replaced.started;
        this.redirectedFrom = replaced.redirectedFrom;
        this.isSecure = replaced.isSecure;
        this.nettyRequest = replaced.nettyRequest;
        this.responseState = replaced.responseState;
        this.followRedirectPredicate = replaced.followRedirectPredicate;
        this.requestHeaders = replaced.requestHeaders;
        this.cookieEncoder = replaced.cookieEncoder;
        this.cookieDecoder = replaced.cookieDecoder;
    }

    HttpClientOperations(Connection c, ConnectionObserver listener, ClientCookieEncoder encoder, ClientCookieDecoder decoder) {
        super(c, listener);
        this.isSecure = c.channel().pipeline().get("io.micrometer.shaded.reactor.left.sslHandler") != null;
        this.nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
        this.requestHeaders = this.nettyRequest.headers();
        this.cookieDecoder = decoder;
        this.cookieEncoder = encoder;
    }

    @Override
    public HttpClientRequest addCookie(Cookie cookie) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add((CharSequence)HttpHeaderNames.COOKIE, (Object)this.cookieEncoder.encode(cookie));
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(ChannelHandler handler) {
        super.addHandlerLast(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerLast(String name, ChannelHandler handler) {
        super.addHandlerLast(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(ChannelHandler handler) {
        super.addHandlerFirst(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandlerFirst(String name, ChannelHandler handler) {
        super.addHandlerFirst(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(ChannelHandler handler) {
        super.addHandler(handler);
        return this;
    }

    @Override
    public HttpClientOperations addHandler(String name, ChannelHandler handler) {
        super.addHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations replaceHandler(String name, ChannelHandler handler) {
        super.replaceHandler(name, handler);
        return this;
    }

    @Override
    public HttpClientOperations removeHandler(String name) {
        super.removeHandler(name);
        return this;
    }

    @Override
    public HttpClientRequest addHeader(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.add(name, (Object)value);
        return this;
    }

    @Override
    public InetSocketAddress address() {
        return (InetSocketAddress)this.channel().remoteAddress();
    }

    public void chunkedTransfer(boolean chunked) {
        if (!this.hasSentHeaders() && HttpUtil.isTransferEncodingChunked(this.nettyRequest) != chunked) {
            this.requestHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
            HttpUtil.setTransferEncodingChunked(this.nettyRequest, chunked);
        }
    }

    @Override
    public HttpClientOperations withConnection(Consumer<? super Connection> withConnection) {
        Objects.requireNonNull(withConnection, "withConnection");
        withConnection.accept(this);
        return this;
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        ResponseState responseState = this.responseState;
        if (responseState != null && responseState.cookieHolder != null) {
            return responseState.cookieHolder.getCachedCookies();
        }
        return Collections.emptyMap();
    }

    void followRedirectPredicate(BiPredicate<HttpClientRequest, HttpClientResponse> predicate) {
        this.followRedirectPredicate = predicate;
    }

    @Override
    protected void onInboundCancel() {
        if (this.isInboundDisposed()) {
            return;
        }
        this.channel().close();
    }

    @Override
    protected void onInboundClose() {
        if (this.isInboundCancelled() || this.isInboundDisposed()) {
            return;
        }
        this.listener().onStateChange(this, HttpClientState.RESPONSE_INCOMPLETE);
        if (this.responseState == null) {
            if (this.markSentBody()) {
                this.listener().onUncaughtException(this, PrematureCloseException.BEFORE_RESPONSE_SENDING_REQUEST);
            } else {
                this.listener().onUncaughtException(this, PrematureCloseException.BEFORE_RESPONSE);
            }
            return;
        }
        super.onInboundError(PrematureCloseException.DURING_RESPONSE);
    }

    @Override
    public NettyOutbound sendObject(Publisher<?> dataStream) {
        if (!(HttpUtil.isTransferEncodingChunked(this.nettyRequest) || HttpUtil.isContentLengthSet(this.nettyRequest) || this.method().equals(HttpMethod.HEAD) || this.hasSentHeaders())) {
            HttpUtil.setTransferEncodingChunked(this.nettyRequest, true);
        }
        return super.sendObject(dataStream);
    }

    @Override
    public HttpClientRequest header(CharSequence name, CharSequence value) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        this.requestHeaders.set(name, (Object)value);
        return this;
    }

    @Override
    public HttpClientRequest headers(HttpHeaders headers) {
        if (this.hasSentHeaders()) {
            throw new IllegalStateException("Status and headers already sent");
        }
        String host = this.requestHeaders.get(HttpHeaderNames.HOST);
        this.requestHeaders.set(headers);
        this.requestHeaders.set((CharSequence)HttpHeaderNames.HOST, (Object)host);
        return this;
    }

    @Override
    public boolean isFollowRedirect() {
        return this.followRedirectPredicate != null && this.redirectedFrom.length <= 50;
    }

    @Override
    public boolean isKeepAlive() {
        ResponseState rs = this.responseState;
        if (rs != null) {
            return this.isKeepAlive(rs.response);
        }
        return this.isKeepAlive(this.nettyRequest);
    }

    @Override
    public boolean isWebsocket() {
        ChannelOperations<?, ?> ops = HttpClientOperations.get(this.channel());
        return ops != null && ops.getClass().equals(WebsocketClientOperations.class);
    }

    @Override
    public HttpMethod method() {
        return this.nettyRequest.method();
    }

    @Override
    public final HttpClientOperations onDispose(Disposable onDispose) {
        super.onDispose(onDispose);
        return this;
    }

    @Override
    public String[] redirectedFrom() {
        Supplier<String>[] redirectedFrom = this.redirectedFrom;
        String[] dest = new String[redirectedFrom.length];
        for (int i = 0; i < redirectedFrom.length; ++i) {
            dest[i] = redirectedFrom[i].get();
        }
        return dest;
    }

    @Override
    public HttpHeaders requestHeaders() {
        return this.nettyRequest.headers();
    }

    @Override
    public HttpHeaders responseHeaders() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return responseState.headers;
        }
        throw new IllegalStateException("Response headers cannot be accessed without server response");
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> source) {
        if (Objects.equals(this.method(), HttpMethod.GET) || Objects.equals(this.method(), HttpMethod.HEAD)) {
            return new GetOrHeadAggregateOutbound(this, source, this.outboundHttpMessage());
        }
        return super.send(source);
    }

    final URI websocketUri() {
        URI uri;
        try {
            String url = this.uri();
            if (url.startsWith("http") || url.startsWith("ws")) {
                uri = new URI(url);
            } else {
                String host = this.requestHeaders().get(HttpHeaderNames.HOST);
                uri = new URI((this.isSecure ? "wss" : "ws") + "://" + host + (url.startsWith("/") ? url : "/" + url));
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    @Override
    public HttpResponseStatus status() {
        ResponseState responseState = this.responseState;
        if (responseState != null) {
            return HttpResponseStatus.valueOf(responseState.response.status().code());
        }
        throw new IllegalStateException("Trying to access status() while missing response");
    }

    @Override
    public final String uri() {
        return this.nettyRequest.uri();
    }

    @Override
    public final HttpVersion version() {
        HttpVersion version = this.nettyRequest.protocolVersion();
        if (version.equals(HttpVersion.HTTP_1_0)) {
            return HttpVersion.HTTP_1_0;
        }
        if (version.equals(HttpVersion.HTTP_1_1)) {
            return HttpVersion.HTTP_1_1;
        }
        throw new IllegalStateException(version.protocolName() + " not supported");
    }

    @Override
    protected void preSendHeadersAndStatus() {
    }

    @Override
    protected void onOutboundComplete() {
        if (this.isWebsocket() || this.isInboundCancelled()) {
            return;
        }
        if (this.markSentHeaderAndBody()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "No sendHeaders() called before complete, sending zero-length header"));
            }
            this.channel().writeAndFlush(this.newFullEmptyBodyMessage());
        } else if (this.markSentBody()) {
            this.channel().writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT);
        }
        this.listener().onStateChange(this, HttpClientState.REQUEST_SENT);
        this.channel().read();
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.isPersistent() && this.responseState == null) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Outbound error happened"), err);
            }
            this.listener().onUncaughtException(this, err);
            if (this.markSentBody()) {
                this.markPersistent(false);
            }
            this.terminate();
            return;
        }
        super.onOutboundError(err);
    }

    @Override
    protected void onInboundNext(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            if (response.decoderResult().isFailure()) {
                this.onInboundError(response.decoderResult().cause());
                ReferenceCountUtil.release(msg);
                return;
            }
            if (this.started) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations cannot proceed more than one response {}"), response.headers().toString());
                }
                ReferenceCountUtil.release(msg);
                return;
            }
            this.started = true;
            this.setNettyResponse(response);
            if (!this.isKeepAlive()) {
                this.markPersistent(false);
            }
            if (this.isInboundCancelled()) {
                ReferenceCountUtil.release(msg);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received response (auto-read:{}) : {}"), this.channel().config().isAutoRead(), this.responseHeaders().entries().toString());
            }
            if (this.notRedirected(response)) {
                try {
                    this.listener().onStateChange(this, HttpClientState.RESPONSE_RECEIVED);
                }
                catch (Exception e) {
                    this.onInboundError(e);
                    ReferenceCountUtil.release(msg);
                    return;
                }
            }
            if (msg instanceof FullHttpResponse) {
                super.onInboundNext(ctx, msg);
                this.terminate();
            }
            return;
        }
        if (msg instanceof LastHttpContent) {
            if (!this.started) {
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations received an incorrect end delimiter (previously used connection?)"));
                }
                ReferenceCountUtil.release(msg);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received last HTTP packet"));
            }
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                super.onInboundNext(ctx, msg);
            }
            this.channel().config().setAutoRead(true);
            if (this.markSentBody()) {
                this.markPersistent(false);
            }
            this.terminate();
            return;
        }
        if (!this.started) {
            if (log.isDebugEnabled()) {
                if (msg instanceof ByteBufHolder) {
                    msg = ((ByteBufHolder)msg).content();
                }
                log.debug(ReactorNetty.format(this.channel(), "HttpClientOperations received an incorrect chunk {} (previously used connection?)"), msg);
            }
            ReferenceCountUtil.release(msg);
            return;
        }
        super.onInboundNext(ctx, msg);
    }

    @Override
    protected HttpMessage outboundHttpMessage() {
        return this.nettyRequest;
    }

    final boolean notRedirected(HttpResponse response) {
        if (this.isFollowRedirect() && this.followRedirectPredicate.test(this, this)) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Received redirect location: {}"), response.headers().entries().toString());
            }
            this.listener().onUncaughtException(this, new RedirectClientException(response.headers()));
            return false;
        }
        return true;
    }

    @Override
    protected HttpMessage newFullEmptyBodyMessage() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(this.version(), this.method(), this.uri());
        request.headers().set(this.requestHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING).setInt(HttpHeaderNames.CONTENT_LENGTH, 0));
        return request;
    }

    final HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    final Mono<Void> send() {
        if (this.markSentHeaderAndBody()) {
            HttpMessage request = this.newFullEmptyBodyMessage();
            return FutureMono.deferFuture(() -> this.channel().writeAndFlush(request));
        }
        return Mono.empty();
    }

    final void setNettyResponse(HttpResponse nettyResponse) {
        ResponseState state = this.responseState;
        if (state == null) {
            this.responseState = new ResponseState(nettyResponse, nettyResponse.headers(), this.cookieDecoder);
        }
    }

    final void withWebsocketSupport(String protocols, int maxFramePayloadLength, boolean compress) {
        URI url = this.websocketUri();
        if (this.markSentHeaders()) {
            WebsocketClientOperations ops;
            this.addHandlerFirst("io.micrometer.shaded.reactor.left.httpAggregator", new HttpObjectAggregator(8192));
            if (compress) {
                this.requestHeaders().remove(HttpHeaderNames.ACCEPT_ENCODING);
                this.removeHandler("io.micrometer.shaded.reactor.left.decompressor");
                this.addHandlerFirst("io.micrometer.shaded.reactor.left.wsCompressionHandler", WebSocketClientCompressionHandler.INSTANCE);
            }
            if (!this.rebind(ops = new WebsocketClientOperations(url, protocols, maxFramePayloadLength, this))) {
                log.error(ReactorNetty.format(this.channel(), "Error while rebinding websocket in channel attribute: " + HttpClientOperations.get(this.channel()) + " to " + ops));
            }
        }
    }

    static final class GetOrHeadAggregateOutbound
    implements NettyOutbound {
        final HttpOperations<?, ?> parent;
        final HttpMessage request;
        final Publisher<? extends ByteBuf> source;

        GetOrHeadAggregateOutbound(HttpOperations<?, ?> parent, Publisher<? extends ByteBuf> source, HttpMessage request) {
            this.parent = parent;
            this.source = source;
            this.request = request;
        }

        @Override
        public ByteBufAllocator alloc() {
            return this.parent.alloc();
        }

        @Override
        public NettyOutbound sendObject(Publisher<?> dataStream) {
            return this.parent.sendObject(dataStream);
        }

        @Override
        public NettyOutbound sendObject(Object message) {
            return this.parent.sendObject(message);
        }

        @Override
        public <S> NettyOutbound sendUsing(Callable<? extends S> sourceInput, BiFunction<? super Connection, ? super S, ?> mappedInput, Consumer<? super S> sourceCleanup) {
            return this.parent.sendUsing(sourceInput, mappedInput, sourceCleanup);
        }

        @Override
        public Mono<Void> then() {
            ByteBufAllocator alloc = this.parent.channel().alloc();
            return Flux.from(this.source).collect(alloc::heapBuffer, ByteBuf::writeBytes).flatMap(agg -> {
                if (!HttpUtil.isTransferEncodingChunked(this.request) && !HttpUtil.isContentLengthSet(this.request)) {
                    this.request.headers().setInt(HttpHeaderNames.CONTENT_LENGTH, agg.readableBytes());
                }
                if (agg.readableBytes() > 0) {
                    return this.parent.then().thenEmpty(FutureMono.disposableWriteAndFlush(this.parent.channel(), Mono.just(agg)));
                }
                agg.release();
                return this.parent.then();
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release);
        }

        @Override
        public NettyOutbound withConnection(Consumer<? super Connection> withConnection) {
            return this.parent.withConnection(withConnection);
        }
    }

    static final class SendForm
    extends Mono<Void> {
        static final HttpDataFactory DEFAULT_FACTORY = new DefaultHttpDataFactory(16384L);
        final HttpClientOperations parent;
        final BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback;
        final Consumer<Flux<Long>> progressCallback;

        SendForm(HttpClientOperations parent, BiConsumer<? super HttpClientRequest, HttpClientForm> formCallback, @Nullable Consumer<Flux<Long>> progressCallback) {
            this.parent = parent;
            this.formCallback = formCallback;
            this.progressCallback = progressCallback;
        }

        @Override
        public void subscribe(CoreSubscriber<? super Void> s) {
            if (this.parent.channel().eventLoop().inEventLoop()) {
                this._subscribe(s);
            } else {
                this.parent.channel().eventLoop().execute(() -> this._subscribe(s));
            }
        }

        void _subscribe(CoreSubscriber<? super Void> s) {
            if (!this.parent.markSentHeaders()) {
                Operators.error(s, new IllegalStateException("headers have already been sent"));
                return;
            }
            HttpDataFactory df = DEFAULT_FACTORY;
            try {
                HttpClientFormEncoder encoder = new HttpClientFormEncoder(df, this.parent.nettyRequest, false, HttpConstants.DEFAULT_CHARSET, HttpPostRequestEncoder.EncoderMode.RFC1738);
                this.formCallback.accept(this.parent, encoder);
                encoder = encoder.applyChanges(this.parent.nettyRequest);
                df = encoder.newFactory;
                if (!encoder.isMultipart()) {
                    this.parent.requestHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING);
                }
                this.parent.addHandlerFirst("io.micrometer.shaded.reactor.left.chunkedWriter", new ChunkedWriteHandler());
                boolean chunked = HttpUtil.isTransferEncodingChunked(this.parent.nettyRequest);
                HttpRequest r = encoder.finalizeRequest();
                if (!chunked) {
                    HttpUtil.setTransferEncodingChunked(r, false);
                    HttpUtil.setContentLength(r, encoder.length());
                }
                ChannelFuture f = this.parent.channel().writeAndFlush(r);
                Flux tail = encoder.progressFlux.onBackpressureLatest();
                if (encoder.cleanOnTerminate) {
                    tail = tail.doOnCancel(encoder).doAfterTerminate(encoder);
                }
                if (encoder.isChunked()) {
                    if (this.progressCallback != null) {
                        this.progressCallback.accept(tail);
                    }
                    this.parent.channel().writeAndFlush(encoder);
                } else if (this.progressCallback != null) {
                    this.progressCallback.accept(FutureMono.from(f).cast(Long.class).switchIfEmpty(Mono.just(encoder.length())).flux());
                }
                Operators.complete(s);
            }
            catch (Throwable e) {
                Exceptions.throwIfJvmFatal(e);
                df.cleanRequestHttpData(this.parent.nettyRequest);
                Operators.error(s, Exceptions.unwrap(e));
            }
        }
    }

    static final class ResponseState {
        final HttpResponse response;
        final HttpHeaders headers;
        final Cookies cookieHolder;

        ResponseState(HttpResponse response, HttpHeaders headers, ClientCookieDecoder decoder) {
            this.response = response;
            this.headers = headers;
            this.cookieHolder = Cookies.newClientResponseHolder(headers, decoder);
        }
    }
}

