/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.io.netty.channel.ChannelFuture;
import io.micrometer.shaded.io.netty.channel.ChannelFutureListener;
import io.micrometer.shaded.reactor.core.Disposable;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.core.publisher.MonoSink;
import io.micrometer.shaded.reactor.netty.ChannelBindException;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.ReactorNetty;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.channel.ChannelOperations;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import io.micrometer.shaded.reactor.util.Logger;
import io.micrometer.shaded.reactor.util.Loggers;
import io.micrometer.shaded.reactor.util.context.Context;
import java.io.IOException;
import java.net.BindException;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.function.Supplier;

final class NewConnectionProvider
implements ConnectionProvider {
    static final Logger log = Loggers.getLogger(NewConnectionProvider.class);
    static final NewConnectionProvider INSTANCE = new NewConnectionProvider();

    NewConnectionProvider() {
    }

    @Override
    public Mono<? extends Connection> acquire(Bootstrap b) {
        return Mono.create(sink -> {
            Bootstrap bootstrap = b.clone();
            ChannelOperations.OnSetup factory = BootstrapHandlers.channelOperationFactory(bootstrap);
            ConnectionObserver obs = BootstrapHandlers.connectionObserver(bootstrap);
            if (bootstrap.config().remoteAddress() != null) {
                NewConnectionProvider.convertLazyRemoteAddress(bootstrap);
            }
            BootstrapHandlers.finalizeHandler(bootstrap, factory, (ConnectionObserver)new NewConnectionObserver((MonoSink<Connection>)sink, obs));
            ChannelFuture f = bootstrap.config().remoteAddress() != null ? bootstrap.connect() : bootstrap.bind();
            DisposableConnect disposableConnect = new DisposableConnect((MonoSink<Connection>)sink, f, bootstrap);
            f.addListener(disposableConnect);
            sink.onCancel(disposableConnect);
        });
    }

    @Override
    public boolean isDisposed() {
        return false;
    }

    static void convertLazyRemoteAddress(Bootstrap b) {
        SocketAddress remote = b.config().remoteAddress();
        Objects.requireNonNull(remote, "Remote Address not configured");
        if (remote instanceof Supplier) {
            Supplier lazyRemote = (Supplier)((Object)remote);
            b.remoteAddress(Objects.requireNonNull((SocketAddress)lazyRemote.get(), "address supplier returned null"));
        }
    }

    static final class NewConnectionObserver
    implements ConnectionObserver {
        final MonoSink<Connection> sink;
        final ConnectionObserver obs;

        NewConnectionObserver(MonoSink<Connection> sink, ConnectionObserver obs) {
            this.sink = sink;
            this.obs = obs;
        }

        @Override
        public Context currentContext() {
            return this.sink.currentContext();
        }

        @Override
        public void onStateChange(Connection connection, ConnectionObserver.State newState) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(connection.channel(), "onStateChange({}, {})"), newState, connection);
            }
            if (newState == ConnectionObserver.State.CONFIGURED) {
                this.sink.success(connection);
            } else if (newState == ConnectionObserver.State.DISCONNECTING && connection.channel().isActive()) {
                connection.channel().close();
            }
            this.obs.onStateChange(connection, newState);
        }

        @Override
        public void onUncaughtException(Connection c, Throwable error) {
            this.sink.error(error);
            this.obs.onUncaughtException(c, error);
        }
    }

    static final class DisposableConnect
    implements Disposable,
    ChannelFutureListener {
        final MonoSink<Connection> sink;
        final ChannelFuture f;
        final Bootstrap bootstrap;

        DisposableConnect(MonoSink<Connection> sink, ChannelFuture f, Bootstrap bootstrap) {
            this.sink = sink;
            this.f = f;
            this.bootstrap = bootstrap;
        }

        @Override
        public final void dispose() {
            if (this.isDisposed()) {
                return;
            }
            this.f.removeListener(this);
            if (!this.f.isDone()) {
                this.f.cancel(true);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.f.isCancelled() || this.f.isDone();
        }

        @Override
        public final void operationComplete(ChannelFuture f) {
            if (!f.isSuccess()) {
                if (f.isCancelled()) {
                    if (log.isDebugEnabled()) {
                        log.debug(ReactorNetty.format(f.channel(), "Channel cancelled"));
                    }
                    return;
                }
                Throwable cause = f.cause();
                if (cause != null) {
                    if (cause instanceof BindException || cause instanceof IOException && cause.getMessage() != null && cause.getMessage().contains("Address already in use")) {
                        this.sink.error(ChannelBindException.fail(this.bootstrap, null));
                    } else {
                        this.sink.error(cause);
                    }
                } else {
                    this.sink.error(new IOException("error while connecting to " + f.channel()));
                }
            } else if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(f.channel(), "Connected new channel"));
            }
        }
    }
}

