/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.tcp;

import io.micrometer.shaded.io.netty.bootstrap.Bootstrap;
import io.micrometer.shaded.reactor.core.publisher.Mono;
import io.micrometer.shaded.reactor.netty.Connection;
import io.micrometer.shaded.reactor.netty.ConnectionObserver;
import io.micrometer.shaded.reactor.netty.channel.BootstrapHandlers;
import io.micrometer.shaded.reactor.netty.tcp.TcpClient;
import io.micrometer.shaded.reactor.netty.tcp.TcpClientOperator;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class TcpClientDoOn
extends TcpClientOperator
implements ConnectionObserver {
    final Consumer<? super Bootstrap> onConnect;
    final Consumer<? super Connection> onConnected;
    final Consumer<? super Connection> onDisconnected;

    TcpClientDoOn(TcpClient client, @Nullable Consumer<? super Bootstrap> onConnect, @Nullable Consumer<? super Connection> onConnected, @Nullable Consumer<? super Connection> onDisconnected) {
        super(client);
        this.onConnect = onConnect;
        this.onConnected = onConnected;
        this.onDisconnected = onDisconnected;
    }

    @Override
    public Bootstrap configure() {
        Bootstrap b = this.source.configure();
        ConnectionObserver observer = BootstrapHandlers.connectionObserver(b);
        BootstrapHandlers.connectionObserver(b, observer.then(this));
        return b;
    }

    @Override
    public Mono<? extends Connection> connect(Bootstrap b) {
        if (this.onConnect != null) {
            return this.source.connect(b).doOnSubscribe(s -> this.onConnect.accept(b));
        }
        return this.source.connect(b);
    }

    @Override
    public void onStateChange(Connection connection, ConnectionObserver.State newState) {
        if (this.onConnected != null && newState == ConnectionObserver.State.CONFIGURED) {
            this.onConnected.accept(connection);
            return;
        }
        if (this.onDisconnected != null) {
            if (newState == ConnectionObserver.State.DISCONNECTING) {
                connection.onDispose(() -> this.onDisconnected.accept(connection));
            } else if (newState == ConnectionObserver.State.RELEASED) {
                this.onDisconnected.accept(connection);
            }
        }
    }
}

