/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.shaded.reactor.netty.resources;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.shaded.reactor.netty.Metrics;
import io.micrometer.shaded.reactor.netty.resources.ConnectionPoolMetrics;
import io.micrometer.shaded.reactor.netty.resources.ConnectionProvider;
import java.net.SocketAddress;

final class MicrometerPooledConnectionProviderMeterRegistrar
implements ConnectionProvider.MeterRegistrar {
    static final MicrometerPooledConnectionProviderMeterRegistrar INSTANCE = new MicrometerPooledConnectionProviderMeterRegistrar();

    private MicrometerPooledConnectionProviderMeterRegistrar() {
    }

    @Override
    public void registerMetrics(String poolName, String id, SocketAddress remoteAddress, ConnectionPoolMetrics metrics) {
        String addressAsString = Metrics.formatSocketAddress(remoteAddress);
        String[] tags = new String[]{"id", id, "remote.address", addressAsString};
        this.registerMetricsInternal("io.micrometer.shaded.reactor.netty.connection.provider." + poolName, metrics, tags);
        tags = new String[]{"id", id, "remote.address", addressAsString, "name", poolName};
        this.registerMetricsInternal("io.micrometer.shaded.reactor.netty.connection.provider", metrics, tags);
    }

    private void registerMetricsInternal(String name, ConnectionPoolMetrics metrics, String ... tags) {
        Gauge.builder((String)(name + ".total.connections"), (Object)metrics, ConnectionPoolMetrics::allocatedSize).description("The number of all connections, active or idle.").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)(name + ".active.connections"), (Object)metrics, ConnectionPoolMetrics::acquiredSize).description("The number of the connections that have been successfully acquired and are in active use").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)(name + ".idle.connections"), (Object)metrics, ConnectionPoolMetrics::idleSize).description("The number of the idle connections").tags(tags).register(Metrics.REGISTRY);
        Gauge.builder((String)(name + ".pending.connections"), (Object)metrics, ConnectionPoolMetrics::pendingAcquireSize).description("The number of the request, that are pending acquire a connection").tags(tags).register(Metrics.REGISTRY);
    }
}

