/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.models.Xml;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyDeserializer
extends JsonDeserializer<Property> {
    Logger LOGGER = LoggerFactory.getLogger(PropertyDeserializer.class);

    private static String getString(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : detailNode.asText();
    }

    private static Integer getInteger(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Integer.valueOf(detailNode.intValue());
    }

    private static Double getDouble(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Double.valueOf(detailNode.doubleValue());
    }

    private static Boolean getBoolean(JsonNode node, PropertyBuilder.PropertyId type) {
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        return detailNode == null ? null : Boolean.valueOf(detailNode.booleanValue());
    }

    private static List<String> getEnum(JsonNode node, PropertyBuilder.PropertyId type) {
        ArrayList<String> result = new ArrayList<String>();
        JsonNode detailNode = PropertyDeserializer.getDetailNode(node, type);
        if (detailNode != null) {
            ArrayNode an = (ArrayNode)detailNode;
            for (JsonNode child : an) {
                if (!(child instanceof TextNode) && !(child instanceof NumericNode) && !(child instanceof IntNode) && !(child instanceof LongNode) && !(child instanceof DoubleNode) && !(child instanceof FloatNode)) continue;
                result.add(child.asText());
            }
        }
        return result.isEmpty() ? null : result;
    }

    private static Map<String, Object> getVendorExtensions(JsonNode node) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator fieldNameIter = node.fieldNames();
        while (fieldNameIter.hasNext()) {
            String fieldName = (String)fieldNameIter.next();
            if (!fieldName.startsWith("x-")) continue;
            JsonNode extensionField = node.get(fieldName);
            Object extensionObject = Json.mapper().convertValue((Object)extensionField, Object.class);
            result.put(fieldName, extensionObject);
        }
        return result;
    }

    private static JsonNode getDetailNode(JsonNode node, PropertyBuilder.PropertyId type) {
        return node.get(type.getPropertyName());
    }

    public Property deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Property property = this.propertyFromNode(node);
        if (property != null) {
            property.setXml(this.getXml(node));
        }
        return property;
    }

    public Xml getXml(JsonNode node) {
        ObjectNode obj;
        Xml xml = null;
        if (node instanceof ObjectNode && (obj = (ObjectNode)((ObjectNode)node).get("xml")) != null) {
            xml = new Xml();
            JsonNode n = obj.get("name");
            if (n != null) {
                xml.name(n.asText());
            }
            if ((n = obj.get("namespace")) != null) {
                xml.namespace(n.asText());
            }
            if ((n = obj.get("prefix")) != null) {
                xml.prefix(n.asText());
            }
            if ((n = obj.get("attribute")) != null) {
                xml.attribute(Boolean.valueOf(n.asBoolean()));
            }
            if ((n = obj.get("wrapped")) != null) {
                xml.wrapped(Boolean.valueOf(n.asBoolean()));
            }
        }
        return xml;
    }

    Property propertyFromNode(JsonNode node) {
        String type = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TYPE);
        String format = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.FORMAT);
        Xml xml = this.getXml(node);
        String description = PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DESCRIPTION);
        JsonNode detailNode = node.get("$ref");
        if (detailNode != null) {
            return new RefProperty(detailNode.asText()).description(description);
        }
        if (ObjectProperty.isType((String)type) || node.get("properties") != null) {
            detailNode = node.get("additionalProperties");
            if (detailNode != null && detailNode.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
                Property items = this.propertyFromNode(detailNode);
                if (items != null) {
                    MapProperty mapProperty = new MapProperty(items).description(description);
                    mapProperty.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
                    return mapProperty;
                }
            } else {
                detailNode = node.get("properties");
                String detailNodeType = null;
                HashMap properties = new HashMap();
                if (detailNode != null) {
                    Iterator iter = detailNode.fields();
                    while (iter.hasNext()) {
                        Map.Entry field = (Map.Entry)iter.next();
                        Property property = this.propertyFromNode((JsonNode)field.getValue());
                        if (property != null) {
                            properties.put(field.getKey(), property);
                            continue;
                        }
                        if ("type".equals(field.getKey()) && field.getValue() != null && "array".equals(((JsonNode)field.getValue()).asText())) {
                            detailNodeType = "array";
                        }
                        if (!"description".equals(field.getKey()) || !((JsonNode)field.getValue()).getNodeType().equals((Object)JsonNodeType.STRING)) continue;
                        description = ((JsonNode)field.getValue()).asText();
                    }
                }
                if ("array".equals(detailNodeType)) {
                    ArrayProperty ap = new ArrayProperty().description(description);
                    ap.setDescription(description);
                    if (properties.keySet().size() == 1) {
                        String key = (String)properties.keySet().iterator().next();
                        ap.setItems((Property)properties.get(key));
                    }
                    ap.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
                    return ap;
                }
                ObjectProperty objectProperty = new ObjectProperty(properties).description(description);
                objectProperty.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
                return objectProperty;
            }
        }
        if (ArrayProperty.isType((String)type) && (detailNode = node.get("items")) != null) {
            Property subProperty = this.propertyFromNode(detailNode);
            ArrayProperty arrayProperty = new ArrayProperty().items(subProperty).description(description);
            arrayProperty.setVendorExtensionMap(PropertyDeserializer.getVendorExtensions(node));
            return arrayProperty;
        }
        EnumMap<PropertyBuilder.PropertyId, Object> args = new EnumMap<PropertyBuilder.PropertyId, Object>(PropertyBuilder.PropertyId.class);
        args.put(PropertyBuilder.PropertyId.TYPE, (Object)type);
        args.put(PropertyBuilder.PropertyId.FORMAT, (Object)format);
        args.put(PropertyBuilder.PropertyId.DESCRIPTION, (Object)description);
        args.put(PropertyBuilder.PropertyId.EXAMPLE, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.EXAMPLE));
        args.put(PropertyBuilder.PropertyId.ENUM, (Object)PropertyDeserializer.getEnum(node, PropertyBuilder.PropertyId.ENUM));
        args.put(PropertyBuilder.PropertyId.TITLE, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.TITLE));
        args.put(PropertyBuilder.PropertyId.DEFAULT, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DEFAULT));
        args.put(PropertyBuilder.PropertyId.PATTERN, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.PATTERN));
        args.put(PropertyBuilder.PropertyId.DESCRIMINATOR, (Object)PropertyDeserializer.getString(node, PropertyBuilder.PropertyId.DESCRIMINATOR));
        args.put(PropertyBuilder.PropertyId.MIN_ITEMS, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_ITEMS));
        args.put(PropertyBuilder.PropertyId.MAX_ITEMS, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_ITEMS));
        args.put(PropertyBuilder.PropertyId.MIN_PROPERTIES, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_PROPERTIES));
        args.put(PropertyBuilder.PropertyId.MAX_PROPERTIES, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_PROPERTIES));
        args.put(PropertyBuilder.PropertyId.MIN_LENGTH, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MIN_LENGTH));
        args.put(PropertyBuilder.PropertyId.MAX_LENGTH, (Object)PropertyDeserializer.getInteger(node, PropertyBuilder.PropertyId.MAX_LENGTH));
        args.put(PropertyBuilder.PropertyId.MINIMUM, (Object)PropertyDeserializer.getDouble(node, PropertyBuilder.PropertyId.MINIMUM));
        args.put(PropertyBuilder.PropertyId.MAXIMUM, (Object)PropertyDeserializer.getDouble(node, PropertyBuilder.PropertyId.MAXIMUM));
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM, (Object)PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.EXCLUSIVE_MINIMUM));
        args.put(PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM, (Object)PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.EXCLUSIVE_MAXIMUM));
        args.put(PropertyBuilder.PropertyId.UNIQUE_ITEMS, (Object)PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.UNIQUE_ITEMS));
        args.put(PropertyBuilder.PropertyId.READ_ONLY, (Object)PropertyDeserializer.getBoolean(node, PropertyBuilder.PropertyId.READ_ONLY));
        args.put(PropertyBuilder.PropertyId.VENDOR_EXTENSIONS, (Object)PropertyDeserializer.getVendorExtensions(node));
        Property output = PropertyBuilder.build((String)type, (String)format, args);
        if (output == null) {
            this.LOGGER.warn("no property from " + type + ", " + format + ", " + args);
            return null;
        }
        output.setDescription(description);
        return output;
    }
}

