/*
 * Decompiled with CFR 0.152.
 */
package scala_maven_dependency;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import scala_maven.VersionNumber;
import scala_maven_dependency.ArtifactIds;
import scala_maven_dependency.Context;
import scala_maven_dependency.LocalFileArtifact;

public class Context4ScalaHome
implements Context {
    private File scalaHome;
    private final VersionNumber scalaVersion;
    private final VersionNumber scalaCompatVersion;
    private ArtifactIds aids;

    public Context4ScalaHome(VersionNumber scalaVersion, VersionNumber scalaCompatVersion, ArtifactIds aids, File scalaHome) {
        this.scalaHome = scalaHome;
        this.scalaVersion = scalaVersion;
        this.scalaCompatVersion = scalaCompatVersion;
        this.aids = aids;
    }

    @Override
    public boolean hasInDistro(Artifact artifact) throws Exception {
        return false;
    }

    @Override
    public VersionNumber version() {
        return this.scalaVersion;
    }

    @Override
    public VersionNumber versionCompat() {
        return this.scalaCompatVersion;
    }

    @Override
    public Set<Artifact> findLibraryAndDependencies() throws Exception {
        File lib = new File(this.scalaHome, "lib");
        File f = new File(lib, this.aids.scalaLibraryArtifactId() + ".jar");
        TreeSet<Artifact> d = new TreeSet<Artifact>();
        d.add(new LocalFileArtifact("local", this.aids.scalaLibraryArtifactId(), this.scalaVersion.toString(), f));
        return d;
    }

    @Override
    public Set<Artifact> findCompilerAndDependencies() throws Exception {
        TreeSet<Artifact> d = new TreeSet<Artifact>();
        for (File f : new File(this.scalaHome, "lib").listFiles()) {
            String name = f.getName();
            if (!name.endsWith(".jar")) continue;
            d.add(new LocalFileArtifact("local", name.substring(0, name.length() - 4), this.scalaVersion.toString(), f));
        }
        return d;
    }
}

