/*
 * Decompiled with CFR 0.152.
 */
package net.liftweb.json;

import java.io.Reader;
import java.io.StringReader;
import net.liftweb.json.JsonAST;
import net.liftweb.json.JsonParser;
import net.liftweb.json.JsonParser$;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonParser$
implements ScalaObject {
    public static final JsonParser$ MODULE$;
    private final Function1<JsonParser.Parser, JsonAST.JValue> astParser;
    private final char net$liftweb$json$JsonParser$$EOF;

    static {
        new JsonParser$();
    }

    public JsonAST.JValue parse(String s) {
        return this.parse(new JsonParser.Buffer(new StringReader(s)));
    }

    public JsonAST.JValue parse(Reader s) {
        return this.parse(new JsonParser.Buffer(s));
    }

    /*
     * WARNING - void declaration
     */
    public Option<JsonAST.JValue> parseOpt(String s) {
        void var2_2;
        None$ exceptionResult1 = null;
        try {
            exceptionResult1 = new Some((Object)this.parse(s));
        }
        catch (Exception exception) {
            exceptionResult1 = None$.MODULE$;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Option<JsonAST.JValue> parseOpt(Reader s) {
        void var2_2;
        None$ exceptionResult2 = null;
        try {
            exceptionResult2 = new Some((Object)this.parse(s));
        }
        catch (Exception exception) {
            exceptionResult2 = None$.MODULE$;
        }
        return var2_2;
    }

    public <A> A parse(String s, Function1<JsonParser.Parser, A> p) {
        return this.parse(new StringReader(s), p);
    }

    public <A> A parse(Reader s, Function1<JsonParser.Parser, A> p) {
        return (A)p.apply((Object)new JsonParser.Parser(new JsonParser.Buffer(s)));
    }

    private JsonAST.JValue parse(JsonParser.Buffer buf) {
        JsonAST.JValue exceptionResult3 = null;
        try {
            exceptionResult3 = (JsonAST.JValue)this.astParser().apply((Object)new JsonParser.Parser(buf));
            return exceptionResult3;
        }
        catch (Exception exception) {
            throw new JsonParser.ParseException("parsing failed", exception);
        }
        catch (JsonParser.ParseException parseException) {
            throw parseException;
        }
        finally {
            buf.release();
        }
    }

    public String unquote(String string) {
        return this.unquote(new JsonParser.Buffer(new StringReader(string)));
    }

    public String unquote(JsonParser.Buffer buf) {
        char EOF$1 = (char)-1;
        buf.mark();
        char c = buf.next();
        while (c != EOF$1) {
            if (c == '\"') {
                return buf.substring();
            }
            if (c == '\\') {
                return this.unquote0$1(buf, buf.substring(), EOF$1);
            }
            c = buf.next();
        }
        throw Predef$.MODULE$.error("expected string end");
    }

    private Function1<JsonParser.Parser, JsonAST.JValue> astParser() {
        return this.astParser;
    }

    public final char net$liftweb$json$JsonParser$$EOF() {
        return this.net$liftweb$json$JsonParser$$EOF;
    }

    private final String unquote0$1(JsonParser.Buffer buf, String base, char c) {
        StringBuilder s = new StringBuilder(base);
        char c2 = '\\';
        while (c2 != c) {
            StringBuilder stringBuilder;
            if (c2 == '\"') {
                return s.toString();
            }
            if (c2 == '\\') {
                char c3 = buf.next();
                switch (c3) {
                    default: {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case 'u': {
                        char[] chars = Array$.MODULE$.apply(buf.next(), (Seq)Predef$.MODULE$.wrapCharArray(new char[]{buf.next(), buf.next(), buf.next()}));
                        int codePoint = Integer.parseInt(new String(chars), 16);
                        stringBuilder = s.appendCodePoint(codePoint);
                        break;
                    }
                    case 't': {
                        stringBuilder = s.append('\t');
                        break;
                    }
                    case 'r': {
                        stringBuilder = s.append('\r');
                        break;
                    }
                    case 'n': {
                        stringBuilder = s.append('\n');
                        break;
                    }
                    case 'f': {
                        stringBuilder = s.append('\f');
                        break;
                    }
                    case 'b': {
                        stringBuilder = s.append('\b');
                        break;
                    }
                    case '\\': {
                        stringBuilder = s.append('\\');
                        break;
                    }
                    case '/': {
                        stringBuilder = s.append('/');
                        break;
                    }
                    case '\"': {
                        stringBuilder = s.append('\"');
                        break;
                    }
                }
            } else {
                stringBuilder = s.append(c2);
            }
            c2 = buf.next();
        }
        throw Predef$.MODULE$.error("expected string end");
    }

    private JsonParser$() {
        MODULE$ = this;
        this.astParser = new anonfun.2();
        this.net$liftweb$json$JsonParser$$EOF = (char)-1;
    }
}

