/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimMinimumSpanningTree<V, E>
implements Transformer<Graph<V, E>, Graph<V, E>> {
    protected Factory<? extends Graph<V, E>> treeFactory;
    protected Transformer<E, Double> weights;

    public PrimMinimumSpanningTree(Factory<? extends Graph<V, E>> factory) {
        this((Factory<Graph<V, E>>)factory, (Transformer<E, Double>)new ConstantTransformer((Object)1.0));
    }

    public PrimMinimumSpanningTree(Factory<? extends Graph<V, E>> factory, Transformer<E, Double> weights) {
        this.treeFactory = factory;
        if (weights != null) {
            this.weights = weights;
        }
    }

    public Graph<V, E> transform(Graph<V, E> graph) {
        HashSet unfinishedEdges = new HashSet(graph.getEdges());
        Graph tree = (Graph)this.treeFactory.create();
        V root = this.findRoot(graph);
        if (graph.getVertices().contains(root)) {
            tree.addVertex(root);
        } else if (graph.getVertexCount() > 0) {
            tree.addVertex(graph.getVertices().iterator().next());
        }
        this.updateTree(tree, graph, unfinishedEdges);
        return tree;
    }

    protected V findRoot(Graph<V, E> graph) {
        for (Object v : graph.getVertices()) {
            if (graph.getInEdges(v).size() != 0) continue;
            return (V)v;
        }
        if (graph.getVertexCount() > 0) {
            return (V)graph.getVertices().iterator().next();
        }
        return null;
    }

    protected void updateTree(Graph<V, E> tree, Graph<V, E> graph, Collection<E> unfinishedEdges) {
        Collection tv = tree.getVertices();
        double minCost = Double.MAX_VALUE;
        Object nextEdge = null;
        Object nextVertex = null;
        Object currentVertex = null;
        for (E e : unfinishedEdges) {
            if (tree.getEdges().contains(e)) continue;
            Pair endpoints = graph.getEndpoints(e);
            Object first = endpoints.getFirst();
            Object second = endpoints.getSecond();
            if (tv.contains(first) && !tv.contains(second)) {
                if (!((Double)this.weights.transform(e) < minCost)) continue;
                minCost = (Double)this.weights.transform(e);
                nextEdge = e;
                currentVertex = first;
                nextVertex = second;
                continue;
            }
            if (!tv.contains(second) || tv.contains(first) || !((Double)this.weights.transform(e) < minCost)) continue;
            minCost = (Double)this.weights.transform(e);
            nextEdge = e;
            currentVertex = second;
            nextVertex = first;
        }
        if (nextVertex != null && nextEdge != null) {
            unfinishedEdges.remove(nextEdge);
            tree.addEdge(nextEdge, currentVertex, nextVertex);
            this.updateTree(tree, graph, unfinishedEdges);
        }
    }
}

