/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.PrintStream;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class MappingPrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final PrintStream ps;

    public MappingPrinter() {
        this(System.out);
    }

    public MappingPrinter(PrintStream printStream) {
        this.ps = printStream;
    }

    public void visitProgramClass(ProgramClass programClass) {
        String name = programClass.getName();
        String newName = ClassObfuscator.newClassName(programClass);
        this.ps.println(ClassUtil.externalClassName(name) + " -> " + ClassUtil.externalClassName(newName) + ":");
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String newName = MemberObfuscator.newMemberName(programField);
        if (newName != null) {
            this.ps.println("    " + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + " -> " + newName);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String name = programMethod.getName(programClass);
        if (name.equals("<clinit>") || name.equals("<init>")) {
            return;
        }
        String newName = MemberObfuscator.newMemberName(programMethod);
        if (newName != null) {
            this.ps.println("    " + MappingPrinter.lineNumberRange(programClass, programMethod) + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + " -> " + newName);
        }
    }

    private static String lineNumberRange(ProgramClass programClass, ProgramMember programMember) {
        String range = programMember.getLineNumberRange(programClass);
        return range != null ? range + ":" : "";
    }
}

