/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.shrink.AnnotationUsageMarker;
import proguard.shrink.ClassShrinker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFilter;

public class Shrinker {
    private final Configuration configuration;

    public Shrinker(Configuration configuration) {
        this.configuration = configuration;
    }

    public ClassPool execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        UsageMarker usageMarker = this.configuration.whyAreYouKeeping == null ? new UsageMarker() : new ShortestUsageMarker();
        MultiClassVisitor classUsageMarker = new MultiClassVisitor(new ClassVisitor[]{usageMarker, new NamedMethodVisitor("<init>", "()V", usageMarker)});
        ClassPoolVisitor classPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, classUsageMarker, usageMarker, true, false, false);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        programClassPool.classesAccept(new InterfaceUsageMarker(usageMarker));
        programClassPool.classesAccept(new UsedClassFilter(usageMarker, new AllAttributeVisitor(true, new MultiAttributeVisitor(new AttributeVisitor[]{new InnerUsageMarker(usageMarker), new AnnotationUsageMarker(usageMarker)}))));
        if (this.configuration.whyAreYouKeeping != null) {
            System.out.println();
            ShortestUsagePrinter shortestUsagePrinter = new ShortestUsagePrinter((ShortestUsageMarker)usageMarker, this.configuration.verbose);
            ClassPoolVisitor whyClassPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.whyAreYouKeeping, (ClassVisitor)shortestUsagePrinter, (MemberVisitor)shortestUsagePrinter);
            programClassPool.accept(whyClassPoolvisitor);
            libraryClassPool.accept(whyClassPoolvisitor);
        }
        if (this.configuration.printUsage != null) {
            PrintStream ps = this.isFile(this.configuration.printUsage) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printUsage))) : System.out;
            programClassPool.classesAcceptAlphabetically(new UsagePrinter(usageMarker, true, ps));
            if (ps != System.out) {
                ps.close();
            }
        }
        int originalProgramClassPoolSize = programClassPool.size();
        ClassPool newProgramClassPool = new ClassPool();
        programClassPool.classesAccept(new UsedClassFilter(usageMarker, new MultiClassVisitor(new ClassVisitor[]{new ClassShrinker(usageMarker), new ClassPoolFiller(newProgramClassPool)})));
        programClassPool.clear();
        int newProgramClassPoolSize = newProgramClassPool.size();
        if (newProgramClassPoolSize == 0) {
            throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
        }
        if (this.configuration.verbose) {
            System.out.println("Removing unused program classes and class elements...");
            System.out.println("  Original number of program classes: " + originalProgramClassPoolSize);
            System.out.println("  Final number of program classes:    " + newProgramClassPoolSize);
        }
        return newProgramClassPool;
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }
}

