/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.crypto.CryptoErrors$;
import net.shrine.crypto.DownStreamCertCollection;
import net.shrine.crypto.HubCertCollection;
import net.shrine.crypto.ImproperlyConfiguredKeyStoreProblem;
import net.shrine.crypto.KeyStoreDescriptor;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.crypto.KeyStoreType;
import net.shrine.crypto.PeerCertCollection;
import net.shrine.crypto.RemoteSite;
import net.shrine.crypto.RemoteSiteDescriptor;
import net.shrine.log.Loggable;
import net.shrine.util.NonEmptySeq;
import net.shrine.util.PeerToPeerModel$;
import net.shrine.util.SingleHubModel;
import net.shrine.util.TrustModel;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.UninitializedFieldError;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;

public final class BouncyKeyStoreCollection$
implements Loggable {
    public static final BouncyKeyStoreCollection$ MODULE$;
    private final BouncyCastleProvider provider;
    private Option<KeyStoreDescriptor> descriptor;
    private Option<KeyStore> keyStore;
    private final String SHA256;
    private final Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$init$0;
    private volatile boolean bitmap$0;

    static {
        new BouncyKeyStoreCollection$();
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        BouncyKeyStoreCollection$ bouncyKeyStoreCollection$ = this;
        synchronized (bouncyKeyStoreCollection$) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.class.net$shrine$log$Loggable$$internalLogger((Loggable)this);
                this.bitmap$0 = true;
            }
            return this.net$shrine$log$Loggable$$internalLogger;
        }
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger : this.net$shrine$log$Loggable$$internalLogger$lzycompute();
    }

    public Logger logger() {
        return Loggable.class.logger((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.class.debugEnabled((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.class.infoEnabled((Loggable)this);
    }

    public void debug(Function0<Object> s) {
        Loggable.class.debug((Loggable)this, s);
    }

    public final void debug(Function0<Object> s, Throwable e) {
        Loggable.class.debug((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<Object> s) {
        Loggable.class.info((Loggable)this, s);
    }

    public final void info(Function0<Object> s, Throwable e) {
        Loggable.class.info((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<Object> s) {
        Loggable.class.warn((Loggable)this, s);
    }

    public final void warn(Function0<Object> s, Throwable e) {
        Loggable.class.warn((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<Object> s) {
        Loggable.class.error((Loggable)this, s);
    }

    public final void error(Function0<Object> s, Throwable e) {
        Loggable.class.error((Loggable)this, s, (Throwable)e);
    }

    public BouncyCastleProvider provider() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.provider;
        }
        throw new UninitializedFieldError("Uninitialized field: BouncyKeyStoreCollection.scala: 46");
    }

    public Option<KeyStoreDescriptor> descriptor() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.descriptor;
        }
        throw new UninitializedFieldError("Uninitialized field: BouncyKeyStoreCollection.scala: 48");
    }

    public void descriptor_$eq(Option<KeyStoreDescriptor> x$1) {
        this.descriptor = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
    }

    public Option<KeyStore> keyStore() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.keyStore;
        }
        throw new UninitializedFieldError("Uninitialized field: BouncyKeyStoreCollection.scala: 49");
    }

    public void keyStore_$eq(Option<KeyStore> x$1) {
        this.keyStore = x$1;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
    }

    public String SHA256() {
        if ((byte)(this.bitmap$init$0 & 8) != 0) {
            return this.SHA256;
        }
        throw new UninitializedFieldError("Uninitialized field: BouncyKeyStoreCollection.scala: 50");
    }

    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createCertCollection(KeyStore keyStore2, KeyStoreDescriptor descriptor2) {
        TrustModel trustModel;
        block6: {
            Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> either;
            block3: {
                Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> either2;
                block5: {
                    Set entries;
                    block4: {
                        block2: {
                            this.descriptor_$eq((Option<KeyStoreDescriptor>)new Some((Object)descriptor2));
                            this.keyStore_$eq((Option<KeyStore>)new Some((Object)keyStore2));
                            Iterator values = JavaConversions$.MODULE$.enumerationAsScalaIterator(keyStore2.aliases()).map((Function1)new Serializable(keyStore2, descriptor2){
                                public static final long serialVersionUID = 0L;
                                private final KeyStore keyStore$1;
                                private final KeyStoreDescriptor descriptor$1;

                                public final Tuple3<String, Certificate, Option<PrivateKey>> apply(String alias) {
                                    return new Tuple3((Object)alias, (Object)this.keyStore$1.getCertificate(alias), (Object)Option$.MODULE$.apply((Object)((PrivateKey)this.keyStore$1.getKey(alias, this.descriptor$1.password().toCharArray()))));
                                }
                                {
                                    this.keyStore$1 = keyStore$1;
                                    this.descriptor$1 = descriptor$1;
                                }
                            });
                            entries = values.map((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final KeyStoreEntry apply(Tuple3<String, Certificate, Option<PrivateKey>> value) {
                                    return new KeyStoreEntry((X509Certificate)value._2(), (NonEmptySeq<String>)new NonEmptySeq(value._1(), (Seq)Nil$.MODULE$), (Option<PrivateKey>)((Option)value._3()));
                                }
                            }).toSet();
                            if (!entries.exists((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(KeyStoreEntry x$1) {
                                    return x$1.isExpired(x$1.isExpired$default$1());
                                }
                            })) break block2;
                            either = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.ExpiredCertificates((Iterable<KeyStoreEntry>)((Iterable)entries.filter((Function1)new Serializable(){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(KeyStoreEntry x$2) {
                                    return x$2.isExpired(x$2.isExpired$default$1());
                                }
                            })))));
                            break block3;
                        }
                        trustModel = descriptor2.trustModel();
                        if (!PeerToPeerModel$.MODULE$.equals(trustModel)) break block4;
                        either2 = this.createPeerCertCollection((Set<KeyStoreEntry>)entries, descriptor2);
                        break block5;
                    }
                    if (!(trustModel instanceof SingleHubModel)) break block6;
                    SingleHubModel singleHubModel = (SingleHubModel)trustModel;
                    boolean isHub = singleHubModel.isCa();
                    either2 = this.createHubCertCollection((Set<KeyStoreEntry>)entries, descriptor2, isHub);
                }
                either = either2;
            }
            return either;
        }
        throw new MatchError((Object)trustModel);
    }

    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createHubCertCollection(Set<KeyStoreEntry> entries, KeyStoreDescriptor descriptor2, boolean isHub) {
        Left left;
        if (entries.size() != 2) {
            left = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.RequiresExactlyTwoEntries((Iterable<KeyStoreEntry>)entries)));
        } else if (entries.count((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyStoreEntry x$3) {
                return x$3.privateKey().isDefined();
            }
        }) != 1) {
            left = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.RequiresExactlyOnePrivateKey((Iterable<KeyStoreEntry>)((Iterable)entries.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KeyStoreEntry x$4) {
                    return x$4.privateKey().isDefined();
                }
            })))));
        } else {
            Tuple2 partition = entries.partition((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(KeyStoreEntry x$5) {
                    return x$5.privateKey().isDefined();
                }
            });
            KeyStoreEntry privateEntry = (KeyStoreEntry)((IterableLike)partition._1()).head();
            KeyStoreEntry caEntry = (KeyStoreEntry)((IterableLike)partition._2()).head();
            Seq<RemoteSiteDescriptor> rsds = descriptor2.remoteSiteDescriptors();
            if (isHub || BoxesRunTime.equals((Object)((RemoteSiteDescriptor)rsds.head()).keyStoreAlias().get(), (Object)caEntry.aliases().first())) {
                if (isHub && privateEntry.wasSignedBy(caEntry)) {
                    left = package$.MODULE$.Right().apply((Object)new HubCertCollection(privateEntry, caEntry, (Seq<RemoteSite>)((Seq)rsds.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final RemoteSite apply(RemoteSiteDescriptor rsd) {
                            return new RemoteSite(rsd.url(), (Option<KeyStoreEntry>)None$.MODULE$, rsd.siteAlias(), rsd.port());
                        }
                    }, Seq$.MODULE$.canBuildFrom()))));
                } else if (privateEntry.wasSignedBy(caEntry)) {
                    RemoteSiteDescriptor rsd = (RemoteSiteDescriptor)rsds.head();
                    left = package$.MODULE$.Right().apply((Object)new DownStreamCertCollection(privateEntry, caEntry, new RemoteSite(rsd.url(), (Option<KeyStoreEntry>)new Some((Object)caEntry), rsd.siteAlias(), rsd.port())));
                } else {
                    KeyStoreEntry keyStoreEntry = privateEntry;
                    left = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.NotSignedByCa((Iterable<KeyStoreEntry>)((Iterable)Nil$.MODULE$.$plus$colon((Object)keyStoreEntry, List$.MODULE$.canBuildFrom())), caEntry)));
                }
            } else {
                String string = (String)((RemoteSiteDescriptor)rsds.head()).keyStoreAlias().get();
                KeyStoreEntry keyStoreEntry = caEntry;
                left = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.IncorrectAliasMapping((Iterable<String>)((Iterable)Nil$.MODULE$.$plus$colon((Object)string, List$.MODULE$.canBuildFrom())), (Iterable<KeyStoreEntry>)((Iterable)Nil$.MODULE$.$plus$colon((Object)keyStoreEntry, List$.MODULE$.canBuildFrom())))));
            }
        }
        return left;
    }

    public Seq<RemoteSite> remoteDescriptorToRemoteSite(KeyStoreDescriptor descriptor2, Set<KeyStoreEntry> entries) {
        return (Seq)descriptor2.remoteSiteDescriptors().map((Function1)new Serializable(entries){
            public static final long serialVersionUID = 0L;
            private final Set entries$1;

            public final RemoteSite apply(RemoteSiteDescriptor rsd) {
                return new RemoteSite(rsd.url(), (Option<KeyStoreEntry>)this.entries$1.find((Function1)new Serializable(this, rsd){
                    public static final long serialVersionUID = 0L;
                    private final RemoteSiteDescriptor rsd$1;

                    public final boolean apply(KeyStoreEntry x$9) {
                        return x$9.aliases().contains(this.rsd$1.keyStoreAlias().get());
                    }
                    {
                        this.rsd$1 = rsd$1;
                    }
                }), rsd.siteAlias(), rsd.port());
            }
            {
                this.entries$1 = entries$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * Unable to fully structure code
     */
    public Either<ImproperlyConfiguredKeyStoreProblem, BouncyKeyStoreCollection> createPeerCertCollection(Set<KeyStoreEntry> entries, KeyStoreDescriptor descriptor) {
        block5: {
            block4: {
                block3: {
                    block2: {
                        configKeyStoreAliases = (Seq)descriptor.remoteSiteDescriptors().map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Option<String> apply(RemoteSiteDescriptor x$10) {
                                return x$10.keyStoreAlias();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        v0 = configKeyStoreAliases.toSet().flatten((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final Iterable<String> apply(Option<String> xo) {
                                return Option$.MODULE$.option2Iterable(xo);
                            }
                        });
                        var4_4 = entries.map((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply(KeyStoreEntry x$11) {
                                return (String)x$11.aliases().first();
                            }
                        }, Set$.MODULE$.canBuildFrom());
                        if (v0 != null ? v0.equals(var4_4) == false : var4_4 != null) ** GOTO lbl37
                        var5_5 = new Tuple2(descriptor.privateKeyAlias(), entries.filter((Function1)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(KeyStoreEntry x$12) {
                                return x$12.privateKey().isDefined();
                            }
                        }));
                        if (var5_5 == null || !(empty = (Set)var5_5._2()).isEmpty()) break block2;
                        var7_7 = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError("Could not find a key in the KeyStore with a PrivateKey. Without one, SHRINE cannot sign messages."));
                        ** GOTO lbl34
                    }
                    if (var5_5 == null) break block3;
                    var8_8 = (Option)var5_5._1();
                    keys = (Set)var5_5._2();
                    if (!None$.MODULE$.equals(var8_8) || keys.size() != 1) break block3;
                    this.warn((Function0<Object>)new Serializable(keys){
                        public static final long serialVersionUID = 0L;
                        private final Set keys$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No private key specified, using the only entry with a private key: `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((KeyStoreEntry)this.keys$1.head()).aliases().first()}));
                        }
                        {
                            this.keys$1 = keys$1;
                        }
                    });
                    var7_7 = package$.MODULE$.Right().apply((Object)new PeerCertCollection((KeyStoreEntry)keys.head(), (Set<KeyStoreEntry>)((Set)entries.$minus$minus((GenTraversableOnce)keys)), this.remoteDescriptorToRemoteSite(descriptor, entries)));
                    ** GOTO lbl34
                }
                if (var5_5 == null || !None$.MODULE$.equals(var10_10 = (Option)var5_5._1())) break block4;
                var7_7 = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.TooManyPrivateKeys((Iterable<KeyStoreEntry>)entries)));
                ** GOTO lbl34
            }
            if (var5_5 == null) break block5;
            var11_11 = (Option)var5_5._1();
            keys = (Set)var5_5._2();
            if (!(var11_11 instanceof Some) || !keys.exists((Function1)new Serializable(alias = (String)(var13_13 = (Some)var11_11).x()){
                public static final long serialVersionUID = 0L;
                private final String alias$1;

                public final boolean apply(KeyStoreEntry x$13) {
                    return x$13.aliases().contains((Object)this.alias$1);
                }
                {
                    this.alias$1 = alias$1;
                }
            })) break block5;
            privateKeyEntry = (KeyStoreEntry)keys.find((Function1)new Serializable(alias){
                public static final long serialVersionUID = 0L;
                private final String alias$1;

                public final boolean apply(KeyStoreEntry x$14) {
                    return x$14.aliases().contains((Object)this.alias$1);
                }
                {
                    this.alias$1 = alias$1;
                }
            }).get();
            var7_7 = package$.MODULE$.Right().apply((Object)new PeerCertCollection(privateKeyEntry, (Set<KeyStoreEntry>)((Set)entries.$minus((Object)privateKeyEntry)), this.remoteDescriptorToRemoteSite(descriptor, entries)));
            ** GOTO lbl34
        }
        if (var5_5 != null && (var16_16 = (Option)var5_5._1()) instanceof Some) {
            var17_17 = (Some)var16_16;
            alias = (String)var17_17.x();
            var7_7 = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.CouldNotFindAlias(alias)));
lbl34:
            // 5 sources

            v1 = var7_7;
        } else {
            throw new MatchError((Object)var5_5);
lbl37:
            // 1 sources

            v1 = package$.MODULE$.Left().apply((Object)CryptoErrors$.MODULE$.configureError(CryptoErrors$.MODULE$.IncorrectAliasMapping((Iterable<String>)((Iterable)configKeyStoreAliases.flatten((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Iterable<String> apply(Option<String> xo) {
                    return Option$.MODULE$.option2Iterable(xo);
                }
            })), (Iterable<KeyStoreEntry>)entries)));
        }
        return v1;
    }

    public BouncyKeyStoreCollection fromFileRecoverWithClassPath(KeyStoreDescriptor descriptor2) {
        KeyStore keyStore2 = new File(descriptor2.file()).exists() ? this.fromStreamHelper(descriptor2, (Function1<String, InputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final FileInputStream apply(String x$15) {
                return new FileInputStream(x$15);
            }
        }) : this.fromStreamHelper(descriptor2, (Function1<String, InputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final InputStream apply(String x$16) {
                return BouncyKeyStoreCollection$.MODULE$.getClass().getClassLoader().getResourceAsStream(x$16);
            }
        });
        this.keyStore_$eq((Option<KeyStore>)new Some((Object)keyStore2));
        this.descriptor_$eq((Option<KeyStoreDescriptor>)new Some((Object)descriptor2));
        return (BouncyKeyStoreCollection)this.createCertCollection(keyStore2, descriptor2).fold((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(ImproperlyConfiguredKeyStoreProblem problem) {
                throw (Throwable)problem.throwable().get();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BouncyKeyStoreCollection apply(BouncyKeyStoreCollection x) {
                return (BouncyKeyStoreCollection)Predef$.MODULE$.identity((Object)x);
            }
        });
    }

    public KeyStore fromStreamHelper(KeyStoreDescriptor descriptor2, Function1<String, InputStream> streamFrom) {
        this.debug((Function0<Object>)new Serializable(descriptor2){
            public static final long serialVersionUID = 0L;
            private final KeyStoreDescriptor descriptor$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading keystore using descriptor: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BouncyKeyStoreCollection$.MODULE$.net$shrine$crypto$BouncyKeyStoreCollection$$toString$1(this.descriptor$2)}));
            }
            {
                this.descriptor$2 = descriptor$2;
            }
        });
        InputStream stream = (InputStream)streamFrom.apply((Object)descriptor2.file());
        Predef$.MODULE$.require(stream != null, (Function0)new Serializable(descriptor2){
            public static final long serialVersionUID = 0L;
            private final KeyStoreDescriptor descriptor$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"null stream for descriptor ", "\u00ac"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BouncyKeyStoreCollection$.MODULE$.net$shrine$crypto$BouncyKeyStoreCollection$$toString$1(this.descriptor$2)}));
            }
            {
                this.descriptor$2 = descriptor$2;
            }
        });
        KeyStore keystore = KeyStore.getInstance(descriptor2.keyStoreType().name());
        try {
            keystore.load(stream, descriptor2.password().toCharArray());
            this.debug((Function0<Object>)new Serializable(keystore){
                public static final long serialVersionUID = 0L;
                private final KeyStore keystore$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Keystore aliases: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.keystore$1.aliases()).asScala()).mkString(",")}));
                }
                {
                    this.keystore$1 = keystore$1;
                }
            });
            this.debug((Function0<Object>)new Serializable(descriptor2){
                public static final long serialVersionUID = 0L;
                private final KeyStoreDescriptor descriptor$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Keystore ", " loaded successfully"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BouncyKeyStoreCollection$.MODULE$.net$shrine$crypto$BouncyKeyStoreCollection$$toString$1(this.descriptor$2)}));
                }
                {
                    this.descriptor$2 = descriptor$2;
                }
            });
            return keystore;
        }
        catch (IOException iOException) {
            throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load keystore from ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{descriptor2})), iOException);
        }
    }

    public final String net$shrine$crypto$BouncyKeyStoreCollection$$toString$1(KeyStoreDescriptor descriptor2) {
        String x$17 = "********";
        String x$18 = descriptor2.copy$default$1();
        Option<String> x$19 = descriptor2.copy$default$3();
        Seq<String> x$20 = descriptor2.copy$default$4();
        TrustModel x$21 = descriptor2.copy$default$5();
        Seq<RemoteSiteDescriptor> x$22 = descriptor2.copy$default$6();
        KeyStoreType x$23 = descriptor2.copy$default$7();
        return descriptor2.copy(x$18, x$17, x$19, x$20, x$21, x$22, x$23).toString();
    }

    private BouncyKeyStoreCollection$() {
        MODULE$ = this;
        Loggable.class.$init$((Loggable)this);
        this.provider = new BouncyCastleProvider();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        Security.addProvider((Provider)this.provider());
        this.descriptor = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.keyStore = None$.MODULE$;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.SHA256 = "SHA256withRSA";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }
}

