/*
 * Decompiled with CFR 0.152.
 */
package slick.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.Statement;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcBackend$;
import slick.jdbc.LoggingPreparedStatement;
import slick.jdbc.LoggingStatement;
import slick.jdbc.ResultSetConcurrency;
import slick.jdbc.ResultSetConcurrency$Auto$;
import slick.jdbc.ResultSetConcurrency$ReadOnly$;
import slick.jdbc.ResultSetHoldability;
import slick.jdbc.ResultSetHoldability$Auto$;
import slick.jdbc.ResultSetHoldability$Default$;
import slick.jdbc.ResultSetType;
import slick.jdbc.ResultSetType$Auto$;
import slick.jdbc.ResultSetType$ForwardOnly$;

public abstract class JdbcBackend$SessionDef$class {
    public static ResultSetType resultSetType(JdbcBackend.SessionDef $this) {
        return ResultSetType$Auto$.MODULE$;
    }

    public static ResultSetConcurrency resultSetConcurrency(JdbcBackend.SessionDef $this) {
        return ResultSetConcurrency$Auto$.MODULE$;
    }

    public static ResultSetHoldability resultSetHoldability(JdbcBackend.SessionDef $this) {
        return ResultSetHoldability$Auto$.MODULE$;
    }

    public static Statement decorateStatement(JdbcBackend.SessionDef $this, Statement statement) {
        return statement;
    }

    public static int fetchSize(JdbcBackend.SessionDef $this) {
        return 0;
    }

    public static final PreparedStatement prepareStatement(JdbcBackend.SessionDef $this, String sql, ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability) {
        PreparedStatement preparedStatement;
        JdbcBackend$.MODULE$.logStatement("Preparing statement", sql);
        ResultSetHoldability resultSetHoldability = $this.resultSetHoldability().withDefault(defaultHoldability);
        if (ResultSetHoldability$Default$.MODULE$.equals(resultSetHoldability)) {
            int rsType = $this.resultSetType().withDefault(defaultType).intValue();
            int rsConc = $this.resultSetConcurrency().withDefault(defaultConcurrency).intValue();
            preparedStatement = rsType == 1003 && rsConc == 1007 ? $this.conn().prepareStatement(sql) : $this.conn().prepareStatement(sql, rsType, rsConc);
        } else {
            preparedStatement = $this.conn().prepareStatement(sql, $this.resultSetType().withDefault(defaultType).intValue(), $this.resultSetConcurrency().withDefault(defaultConcurrency).intValue(), resultSetHoldability.intValue());
        }
        PreparedStatement s = $this.loggingPreparedStatement($this.decorateStatement(preparedStatement));
        if ($this.fetchSize() != 0) {
            s.setFetchSize($this.fetchSize());
        }
        return s;
    }

    public static final ResultSetType prepareStatement$default$2(JdbcBackend.SessionDef $this) {
        return ResultSetType$ForwardOnly$.MODULE$;
    }

    public static final ResultSetConcurrency prepareStatement$default$3(JdbcBackend.SessionDef $this) {
        return ResultSetConcurrency$ReadOnly$.MODULE$;
    }

    public static final ResultSetHoldability prepareStatement$default$4(JdbcBackend.SessionDef $this) {
        return ResultSetHoldability$Default$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public static final PreparedStatement prepareInsertStatement(JdbcBackend.SessionDef $this, String sql, String[] columnNames) {
        void var3_3;
        if (JdbcBackend$.MODULE$.statementLogger().isDebugEnabled()) {
            JdbcBackend$.MODULE$.logStatement(new StringBuilder().append((Object)"Preparing insert statement (returning: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])columnNames).mkString(",")).append((Object)")").toString(), sql);
        }
        PreparedStatement s = $this.loggingPreparedStatement($this.decorateStatement($this.conn().prepareStatement(sql, columnNames)));
        if ($this.fetchSize() != 0) {
            s.setFetchSize($this.fetchSize());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final PreparedStatement prepareInsertStatement(JdbcBackend.SessionDef $this, String sql, int[] columnIndexes2) {
        void var3_3;
        if (JdbcBackend$.MODULE$.statementLogger().isDebugEnabled()) {
            JdbcBackend$.MODULE$.logStatement(new StringBuilder().append((Object)"Preparing insert statement (returning indexes: ").append((Object)Predef$.MODULE$.intArrayOps(columnIndexes2).mkString(",")).append((Object)")").toString(), sql);
        }
        PreparedStatement s = $this.loggingPreparedStatement($this.decorateStatement($this.conn().prepareStatement(sql, columnIndexes2)));
        if ($this.fetchSize() != 0) {
            s.setFetchSize($this.fetchSize());
        }
        return var3_3;
    }

    public static final String[] prepareInsertStatement$default$2(JdbcBackend.SessionDef $this) {
        return new String[0];
    }

    public static final Statement createStatement(JdbcBackend.SessionDef $this, ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability) {
        ResultSetHoldability resultSetHoldability = $this.resultSetHoldability().withDefault(defaultHoldability);
        Statement statement = ResultSetHoldability$Default$.MODULE$.equals(resultSetHoldability) ? $this.conn().createStatement($this.resultSetType().withDefault(defaultType).intValue(), $this.resultSetConcurrency().withDefault(defaultConcurrency).intValue()) : $this.conn().createStatement($this.resultSetType().withDefault(defaultType).intValue(), $this.resultSetConcurrency().withDefault(defaultConcurrency).intValue(), resultSetHoldability.intValue());
        Statement s = $this.loggingStatement($this.decorateStatement(statement));
        if ($this.fetchSize() != 0) {
            s.setFetchSize($this.fetchSize());
        }
        return s;
    }

    public static final ResultSetType createStatement$default$1(JdbcBackend.SessionDef $this) {
        return ResultSetType$ForwardOnly$.MODULE$;
    }

    public static final ResultSetConcurrency createStatement$default$2(JdbcBackend.SessionDef $this) {
        return ResultSetConcurrency$ReadOnly$.MODULE$;
    }

    public static final ResultSetHoldability createStatement$default$3(JdbcBackend.SessionDef $this) {
        return ResultSetHoldability$Default$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object withPreparedStatement(JdbcBackend.SessionDef $this, String sql, ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability, Function1 f2) {
        Object object;
        PreparedStatement st = $this.prepareStatement(sql, defaultType, defaultConcurrency, defaultHoldability);
        try {
            object = f2.apply((Object)st);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        st.close();
        return object;
    }

    public static final ResultSetType withPreparedStatement$default$2(JdbcBackend.SessionDef $this) {
        return ResultSetType$ForwardOnly$.MODULE$;
    }

    public static final ResultSetConcurrency withPreparedStatement$default$3(JdbcBackend.SessionDef $this) {
        return ResultSetConcurrency$ReadOnly$.MODULE$;
    }

    public static final ResultSetHoldability withPreparedStatement$default$4(JdbcBackend.SessionDef $this) {
        return ResultSetHoldability$Default$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object withPreparedInsertStatement(JdbcBackend.SessionDef $this, String sql, String[] columnNames, Function1 f2) {
        Object object;
        PreparedStatement st = $this.prepareInsertStatement(sql, columnNames);
        try {
            object = f2.apply((Object)st);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        st.close();
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object withPreparedInsertStatement(JdbcBackend.SessionDef $this, String sql, int[] columnIndexes2, Function1 f2) {
        Object object;
        PreparedStatement st = $this.prepareInsertStatement(sql, columnIndexes2);
        try {
            object = f2.apply((Object)st);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
        st.close();
        return object;
    }

    public static final String[] withPreparedInsertStatement$default$2(JdbcBackend.SessionDef $this) {
        return new String[0];
    }

    /*
     * WARNING - void declaration
     */
    public static final Object withStatement(JdbcBackend.SessionDef $this, ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability, Function1 f2) {
        Object object;
        Statement st = $this.createStatement(defaultType, defaultConcurrency, defaultHoldability);
        try {
            object = f2.apply((Object)st);
        }
        catch (Throwable throwable) {
            void var5_5;
            var5_5.close();
            throw throwable;
        }
        st.close();
        return object;
    }

    public static final ResultSetType withStatement$default$1(JdbcBackend.SessionDef $this) {
        return ResultSetType$ForwardOnly$.MODULE$;
    }

    public static final ResultSetConcurrency withStatement$default$2(JdbcBackend.SessionDef $this) {
        return ResultSetConcurrency$ReadOnly$.MODULE$;
    }

    public static final ResultSetHoldability withStatement$default$3(JdbcBackend.SessionDef $this) {
        return ResultSetHoldability$Default$.MODULE$;
    }

    public static void force(JdbcBackend.SessionDef $this) {
        $this.conn();
    }

    public static final JdbcBackend.SessionDef internalForParameters(JdbcBackend.SessionDef $this, ResultSetType rsType, ResultSetConcurrency rsConcurrency, ResultSetHoldability rsHoldability, Function1 statementInit, int _fetchSize) {
        return new JdbcBackend.SessionDef($this, rsType, rsConcurrency, rsHoldability, statementInit, _fetchSize){
            private final /* synthetic */ JdbcBackend.SessionDef $outer;
            private final ResultSetType rsType$1;
            private final ResultSetConcurrency rsConcurrency$1;
            private final ResultSetHoldability rsHoldability$1;
            private final Function1 statementInit$1;
            private final int _fetchSize$1;

            public final PreparedStatement prepareStatement(String sql, ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability) {
                return JdbcBackend$SessionDef$class.prepareStatement(this, sql, defaultType, defaultConcurrency, defaultHoldability);
            }

            public final PreparedStatement prepareInsertStatement(String sql, String[] columnNames) {
                return JdbcBackend$SessionDef$class.prepareInsertStatement((JdbcBackend.SessionDef)this, sql, columnNames);
            }

            public final PreparedStatement prepareInsertStatement(String sql, int[] columnIndexes2) {
                return JdbcBackend$SessionDef$class.prepareInsertStatement((JdbcBackend.SessionDef)this, sql, columnIndexes2);
            }

            public final Statement createStatement(ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability) {
                return JdbcBackend$SessionDef$class.createStatement(this, defaultType, defaultConcurrency, defaultHoldability);
            }

            public final <T> T withPreparedStatement(String sql, ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability, Function1<PreparedStatement, T> f2) {
                return (T)JdbcBackend$SessionDef$class.withPreparedStatement(this, sql, defaultType, defaultConcurrency, defaultHoldability, f2);
            }

            public final <T> T withPreparedInsertStatement(String sql, String[] columnNames, Function1<PreparedStatement, T> f2) {
                return (T)JdbcBackend$SessionDef$class.withPreparedInsertStatement((JdbcBackend.SessionDef)this, sql, columnNames, f2);
            }

            public final <T> T withPreparedInsertStatement(String sql, int[] columnIndexes2, Function1<PreparedStatement, T> f2) {
                return (T)JdbcBackend$SessionDef$class.withPreparedInsertStatement((JdbcBackend.SessionDef)this, sql, columnIndexes2, f2);
            }

            public final <T> T withStatement(ResultSetType defaultType, ResultSetConcurrency defaultConcurrency, ResultSetHoldability defaultHoldability, Function1<Statement, T> f2) {
                return (T)JdbcBackend$SessionDef$class.withStatement(this, defaultType, defaultConcurrency, defaultHoldability, f2);
            }

            public void force() {
                JdbcBackend$SessionDef$class.force(this);
            }

            public final JdbcBackend.SessionDef internalForParameters(ResultSetType rsType, ResultSetConcurrency rsConcurrency, ResultSetHoldability rsHoldability, Function1<Statement, BoxedUnit> statementInit, int _fetchSize) {
                return JdbcBackend$SessionDef$class.internalForParameters(this, rsType, rsConcurrency, rsHoldability, statementInit, _fetchSize);
            }

            public Statement loggingStatement(Statement st) {
                return JdbcBackend$SessionDef$class.loggingStatement(this, st);
            }

            public PreparedStatement loggingPreparedStatement(PreparedStatement st) {
                return JdbcBackend$SessionDef$class.loggingPreparedStatement(this, st);
            }

            public final <T> ResultSetType withPreparedStatement$default$2() {
                return JdbcBackend$SessionDef$class.withPreparedStatement$default$2(this);
            }

            public final <T> ResultSetConcurrency withPreparedStatement$default$3() {
                return JdbcBackend$SessionDef$class.withPreparedStatement$default$3(this);
            }

            public final <T> ResultSetHoldability withPreparedStatement$default$4() {
                return JdbcBackend$SessionDef$class.withPreparedStatement$default$4(this);
            }

            public final <T> String[] withPreparedInsertStatement$default$2() {
                return JdbcBackend$SessionDef$class.withPreparedInsertStatement$default$2(this);
            }

            public final ResultSetType prepareStatement$default$2() {
                return JdbcBackend$SessionDef$class.prepareStatement$default$2(this);
            }

            public final ResultSetConcurrency prepareStatement$default$3() {
                return JdbcBackend$SessionDef$class.prepareStatement$default$3(this);
            }

            public final ResultSetHoldability prepareStatement$default$4() {
                return JdbcBackend$SessionDef$class.prepareStatement$default$4(this);
            }

            public final String[] prepareInsertStatement$default$2() {
                return JdbcBackend$SessionDef$class.prepareInsertStatement$default$2(this);
            }

            public final ResultSetType createStatement$default$1() {
                return JdbcBackend$SessionDef$class.createStatement$default$1(this);
            }

            public final ResultSetConcurrency createStatement$default$2() {
                return JdbcBackend$SessionDef$class.createStatement$default$2(this);
            }

            public final ResultSetHoldability createStatement$default$3() {
                return JdbcBackend$SessionDef$class.createStatement$default$3(this);
            }

            public final <T> ResultSetType withStatement$default$1() {
                return JdbcBackend$SessionDef$class.withStatement$default$1(this);
            }

            public final <T> ResultSetConcurrency withStatement$default$2() {
                return JdbcBackend$SessionDef$class.withStatement$default$2(this);
            }

            public final <T> ResultSetHoldability withStatement$default$3() {
                return JdbcBackend$SessionDef$class.withStatement$default$3(this);
            }

            public ResultSetType resultSetType() {
                return this.rsType$1;
            }

            public ResultSetConcurrency resultSetConcurrency() {
                return this.rsConcurrency$1;
            }

            public ResultSetHoldability resultSetHoldability() {
                return this.rsHoldability$1;
            }

            public int fetchSize() {
                return this._fetchSize$1;
            }

            public <S extends Statement> S decorateStatement(S statement) {
                Object object = this.statementInit$1 != null ? this.statementInit$1.apply(statement) : BoxedUnit.UNIT;
                return statement;
            }

            public JdbcBackend.DatabaseDef database() {
                return this.$outer.database();
            }

            public Connection conn() {
                return this.$outer.conn();
            }

            public DatabaseMetaData metaData() {
                return this.$outer.metaData();
            }

            public JdbcBackend.DatabaseCapabilities capabilities() {
                return this.$outer.capabilities();
            }

            public void close() {
                this.$outer.close();
            }

            public void startInTransaction() {
                this.$outer.startInTransaction();
            }

            public void endInTransaction(Function0<BoxedUnit> f2) {
                this.$outer.endInTransaction(f2);
            }

            public /* synthetic */ JdbcBackend slick$jdbc$JdbcBackend$SessionDef$$$outer() {
                return this.$outer.slick$jdbc$JdbcBackend$SessionDef$$$outer();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rsType$1 = rsType$1;
                this.rsConcurrency$1 = rsConcurrency$1;
                this.rsHoldability$1 = rsHoldability$1;
                this.statementInit$1 = statementInit$1;
                this._fetchSize$1 = _fetchSize$1;
                JdbcBackend$SessionDef$class.$init$(this);
            }
        };
    }

    public static Statement loggingStatement(JdbcBackend.SessionDef $this, Statement st) {
        return JdbcBackend$.MODULE$.statementLogger().isDebugEnabled() || JdbcBackend$.MODULE$.benchmarkLogger().isDebugEnabled() ? new LoggingStatement(st) : st;
    }

    public static PreparedStatement loggingPreparedStatement(JdbcBackend.SessionDef $this, PreparedStatement st) {
        return JdbcBackend$.MODULE$.statementLogger().isDebugEnabled() || JdbcBackend$.MODULE$.benchmarkLogger().isDebugEnabled() ? new LoggingPreparedStatement(st) : st;
    }

    public static void $init$(JdbcBackend.SessionDef $this) {
    }
}

