/*
 * Decompiled with CFR 0.152.
 */
package spray.httpx.marshalling;

import akka.util.ByteString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.xml.NodeSeq;
import spray.http.ContentType;
import spray.http.ContentType$;
import spray.http.ContentTypes$;
import spray.http.FormData;
import spray.http.HttpCharset;
import spray.http.HttpCharsets$;
import spray.http.HttpData;
import spray.http.HttpEntity;
import spray.http.HttpEntity$;
import spray.http.HttpHeader;
import spray.http.MediaTypes$;
import spray.http.Rendering;
import spray.http.StringRendering;
import spray.http.Uri;
import spray.httpx.marshalling.BasicMarshallers;
import spray.httpx.marshalling.Marshaller;
import spray.httpx.marshalling.Marshaller$;
import spray.httpx.marshalling.MarshallingContext;

public abstract class BasicMarshallers$class {
    public static Marshaller byteArrayMarshaller(BasicMarshallers $this, ContentType contentType) {
        return Marshaller$.MODULE$.of((Seq<ContentType>)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{contentType}), new Serializable($this, contentType){
            public static final long serialVersionUID = 0L;
            private final ContentType contentType$1;

            public final void apply(byte[] value, ContentType x$1, MarshallingContext ctx) {
                ctx.marshalTo(HttpEntity$.MODULE$.apply(this.contentType$1, value), (Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
            }
            {
                this.contentType$1 = contentType$1;
            }
        });
    }

    public static Marshaller byteStringMarshaller(BasicMarshallers $this, ContentType contentType) {
        return Marshaller$.MODULE$.of((Seq<ContentType>)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{contentType}), new Serializable($this, contentType){
            public static final long serialVersionUID = 0L;
            private final ContentType contentType$2;

            public final void apply(ByteString value, ContentType x$2, MarshallingContext ctx) {
                ctx.marshalTo(HttpEntity$.MODULE$.apply(this.contentType$2, value), (Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
            }
            {
                this.contentType$2 = contentType$2;
            }
        });
    }

    public static Marshaller httpDataMarshaller(BasicMarshallers $this, ContentType contentType) {
        return Marshaller$.MODULE$.of((Seq<ContentType>)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{contentType}), new Serializable($this, contentType){
            public static final long serialVersionUID = 0L;
            private final ContentType contentType$3;

            public final void apply(HttpData value, ContentType x$3, MarshallingContext ctx) {
                ctx.marshalTo(HttpEntity$.MODULE$.apply(this.contentType$3, value), (Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
            }
            {
                this.contentType$3 = contentType$3;
            }
        });
    }

    public static Marshaller stringMarshaller(BasicMarshallers $this, HttpCharset charset, Seq more) {
        return $this.stringMarshaller(ContentType$.MODULE$.apply(MediaTypes$.MODULE$.text$divplain(), charset), (Seq<ContentType>)((Seq)more.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ContentType apply(HttpCharset x$4) {
                return ContentType$.MODULE$.apply(MediaTypes$.MODULE$.text$divplain(), x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())));
    }

    public static Marshaller stringMarshaller(BasicMarshallers $this, ContentType contentType, Seq more) {
        ContentType contentType2 = contentType;
        return Marshaller$.MODULE$.of((Seq<ContentType>)((Seq)more.$plus$colon((Object)contentType2, Seq$.MODULE$.canBuildFrom())), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(String value, ContentType contentType, MarshallingContext ctx) {
                ctx.marshalTo(HttpEntity$.MODULE$.apply(contentType, value), (Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
            }
        });
    }

    public static void $init$(BasicMarshallers $this) {
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$ByteArrayMarshaller_$eq($this.byteArrayMarshaller(ContentTypes$.MODULE$.application$divoctet$minusstream()));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$ByteStringMarshaller_$eq($this.byteStringMarshaller(ContentTypes$.MODULE$.application$divoctet$minusstream()));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$HttpDataMarshaller_$eq($this.httpDataMarshaller(ContentTypes$.MODULE$.application$divoctet$minusstream()));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$CharArrayMarshaller_$eq(Marshaller$.MODULE$.of((Seq<ContentType>)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029()}), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(char[] value, ContentType contentType, MarshallingContext ctx) {
                HttpEntity.Empty$ empty$;
                if (value.length > 0) {
                    CharBuffer charBuffer = CharBuffer.wrap(value);
                    ByteBuffer byteBuffer = contentType.charset().nioCharset().encode(charBuffer);
                    byte[] array = new byte[byteBuffer.remaining()];
                    byteBuffer.get(array);
                    empty$ = HttpEntity$.MODULE$.apply(contentType, array);
                } else {
                    empty$ = HttpEntity.Empty$.MODULE$;
                }
                ctx.marshalTo((HttpEntity)empty$, (Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
            }
        }));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$StringMarshaller_$eq($this.stringMarshaller(ContentTypes$.MODULE$.text$divplain$u0028UTF$minus8$u0029(), (Seq<ContentType>)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{ContentTypes$.MODULE$.text$divplain()})));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$NodeSeqMarshaller_$eq(Marshaller$.MODULE$.delegate((Seq<ContentType>)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{ContentType$.MODULE$.apply(MediaTypes$.MODULE$.text$divxml()), ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divxml()), ContentType$.MODULE$.apply(MediaTypes$.MODULE$.text$divhtml()), ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divxhtml$plusxml())})).apply(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(NodeSeq x$6) {
                return x$6.toString();
            }
        }, $this.StringMarshaller()));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$FormDataMarshaller_$eq(Marshaller$.MODULE$.delegate((Seq<ContentType>)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{ContentType$.MODULE$.apply(MediaTypes$.MODULE$.application$divx$minuswww$minusform$minusurlencoded())})).apply(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(FormData formData, ContentType contentType) {
                HttpCharset charset = (HttpCharset)contentType.definedCharset().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final HttpCharset apply() {
                        return HttpCharsets$.MODULE$.UTF$minus8();
                    }
                });
                return ((StringRendering)Uri.Query$.MODULE$.asBodyData(formData.fields(), Uri.Query$.MODULE$.asBodyData$default$2()).render((Rendering)new StringRendering(), charset.nioCharset())).get();
            }
        }, $this.StringMarshaller()));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$ThrowableMarshaller_$eq(Marshaller$.MODULE$.apply(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(Throwable value, MarshallingContext ctx) {
                ctx.handleError(value);
            }
        }));
        $this.spray$httpx$marshalling$BasicMarshallers$_setter_$HttpEntityMarshaller_$eq(Marshaller$.MODULE$.apply(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final void apply(HttpEntity value, MarshallingContext ctx) {
                HttpEntity httpEntity;
                block4: {
                    Option<ContentType> option;
                    block7: {
                        block3: {
                            block6: {
                                ContentType contentType;
                                block5: {
                                    block2: {
                                        httpEntity = value;
                                        if (!HttpEntity.Empty$.MODULE$.equals(httpEntity)) break block2;
                                        ctx.marshalTo((HttpEntity)HttpEntity.Empty$.MODULE$, (Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block3;
                                    }
                                    if (!(httpEntity instanceof HttpEntity.NonEmpty)) break block4;
                                    HttpEntity.NonEmpty nonEmpty = (HttpEntity.NonEmpty)httpEntity;
                                    contentType = nonEmpty.contentType();
                                    ContentType contentType2 = contentType;
                                    option = ctx.tryAccept((Seq<ContentType>)Nil$.MODULE$.$colon$colon((Object)contentType2));
                                    if (!(option instanceof Some)) break block5;
                                    ctx.marshalTo((HttpEntity)nonEmpty, (Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[0]));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (!None$.MODULE$.equals(option)) break block7;
                                ctx.rejectMarshalling((Seq<ContentType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ContentType[]{contentType}))));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError((Object)httpEntity);
            }
        }));
    }
}

