/*
 * Decompiled with CFR 0.152.
 */
package net.shrine.dashboard.jwtauth;

import io.jsonwebtoken.ClaimJwtException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SigningKeyResolver;
import io.jsonwebtoken.impl.TextCodec;
import java.net.InetAddress;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import net.shrine.crypto.BouncyKeyStoreCollection;
import net.shrine.crypto.DownStreamCertCollection;
import net.shrine.crypto.HubCertCollection;
import net.shrine.crypto.KeyStoreEntry;
import net.shrine.crypto.PeerCertCollection;
import net.shrine.crypto.RemoteSite;
import net.shrine.dashboard.KeyStoreInfo$;
import net.shrine.dashboard.jwtauth.KeySource$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$authenticate$1$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$authenticate$1$$anonfun$apply$1$$anonfun$2$$anonfun$apply$3$$anonfun$apply$4$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$authenticate$1$$anonfun$apply$1$$anonfun$2$$anonfun$apply$3$$anonfun$apply$4$$anonfun$apply$6$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$authenticate$1$$anonfun$apply$1$$anonfun$2$$anonfun$apply$3$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$9$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$4$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$4$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$4$;
import net.shrine.dashboard.jwtauth.ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$4$;
import net.shrine.dashboard.jwtauth.ShrineJwtException;
import net.shrine.dashboard.jwtauth.ShrineJwtException$;
import net.shrine.dashboard.jwtauth.SigningKeyResolverBridge;
import net.shrine.i2b2.protocol.pm.User;
import net.shrine.log.Loggable;
import net.shrine.protocol.Credential;
import net.shrine.util.NonEmptySeq;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.UninitializedFieldError;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileObjectRef;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import spray.http.HttpChallenge;
import spray.http.HttpChallenge$;
import spray.http.HttpHeader;
import spray.http.HttpHeaders;
import spray.http.HttpRequest;
import spray.http.OAuth2BearerToken;
import spray.routing.AuthenticationFailedRejection;
import spray.routing.Rejection;
import spray.routing.RequestContext;

public final class ShrineJwtAuthenticator$
implements Loggable {
    public static final ShrineJwtAuthenticator$ MODULE$;
    private final BouncyKeyStoreCollection certCollection;
    private final String BearerAuthScheme;
    private final HttpHeaders.WWW.minusAuthenticate challengeHeader;
    private final Either<Rejection, User> missingCredentials;
    private final Either<Rejection, User> rejectedCredentials;
    private final Logger net$shrine$log$Loggable$$internalLogger;
    private volatile byte bitmap$init$0;
    private volatile boolean bitmap$0;

    static {
        new ShrineJwtAuthenticator$();
    }

    private Logger net$shrine$log$Loggable$$internalLogger$lzycompute() {
        ShrineJwtAuthenticator$ shrineJwtAuthenticator$ = this;
        synchronized (shrineJwtAuthenticator$) {
            if (!this.bitmap$0) {
                this.net$shrine$log$Loggable$$internalLogger = Loggable.class.net$shrine$log$Loggable$$internalLogger((Loggable)this);
                this.bitmap$0 = true;
            }
            return this.net$shrine$log$Loggable$$internalLogger;
        }
    }

    public Logger net$shrine$log$Loggable$$internalLogger() {
        return this.bitmap$0 ? this.net$shrine$log$Loggable$$internalLogger : this.net$shrine$log$Loggable$$internalLogger$lzycompute();
    }

    public Logger logger() {
        return Loggable.class.logger((Loggable)this);
    }

    public final boolean debugEnabled() {
        return Loggable.class.debugEnabled((Loggable)this);
    }

    public final boolean infoEnabled() {
        return Loggable.class.infoEnabled((Loggable)this);
    }

    public void debug(Function0<Object> s) {
        Loggable.class.debug((Loggable)this, s);
    }

    public final void debug(Function0<Object> s, Throwable e) {
        Loggable.class.debug((Loggable)this, s, (Throwable)e);
    }

    public void info(Function0<Object> s) {
        Loggable.class.info((Loggable)this, s);
    }

    public final void info(Function0<Object> s, Throwable e) {
        Loggable.class.info((Loggable)this, s, (Throwable)e);
    }

    public void warn(Function0<Object> s) {
        Loggable.class.warn((Loggable)this, s);
    }

    public final void warn(Function0<Object> s, Throwable e) {
        Loggable.class.warn((Loggable)this, s, (Throwable)e);
    }

    public void error(Function0<Object> s) {
        Loggable.class.error((Loggable)this, s);
    }

    public final void error(Function0<Object> s, Throwable e) {
        Loggable.class.error((Loggable)this, s, (Throwable)e);
    }

    public BouncyKeyStoreCollection certCollection() {
        if ((byte)(this.bitmap$init$0 & 1) != 0) {
            return this.certCollection;
        }
        throw new UninitializedFieldError("Uninitialized field: ShrineJwtAuthenticator.scala: 32");
    }

    public Function1<RequestContext, Future<Either<Rejection, User>>> authenticate(ExecutionContext ec) {
        return new Serializable(ec){
            public static final long serialVersionUID = 0L;
            private final ExecutionContext ec$1;

            public final Future<Either<Rejection, User>> apply(RequestContext ctx) {
                return Future$.MODULE$.apply((Function0)new Serializable(this, ctx){
                    public static final long serialVersionUID = 0L;
                    public final RequestContext ctx$1;

                    public final Either<Rejection, User> apply() {
                        Try try_;
                        block9: {
                            Either<Rejection, User> either;
                            block8: {
                                Either<Rejection, User> either2;
                                block7: {
                                    Either<Rejection, User> rightUser;
                                    Try attempt = ShrineJwtAuthenticator$.MODULE$.extractAuthorizationHeader(this.ctx$1.request()).withFilter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(HttpHeader check$ifrefutable$1) {
                                            HttpHeader httpHeader = check$ifrefutable$1;
                                            boolean bl = httpHeader != null;
                                            return bl;
                                        }
                                    }).flatMap((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Try<Right<Nothing$, User>> apply(HttpHeader header) {
                                            return ShrineJwtAuthenticator$.MODULE$.extractJwtsStringAndCheckScheme(header).withFilter((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final boolean apply(String check$ifrefutable$2) {
                                                    String string = check$ifrefutable$2;
                                                    boolean bl = string != null;
                                                    return bl;
                                                }
                                            }).flatMap((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final Try<Right<Nothing$, User>> apply(String jwtsString) {
                                                    return ShrineJwtAuthenticator$.MODULE$.extractJwtsClaims(jwtsString).flatMap((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final Try<Right<Nothing$, User>> apply(Jws<Claims> jwtsClaims) {
                                                            return ShrineJwtAuthenticator$.MODULE$.extractAndCheckCert(jwtsClaims).withFilter((Function1)new Serializable(this){
                                                                public static final long serialVersionUID = 0L;

                                                                public final boolean apply(X509Certificate check$ifrefutable$3) {
                                                                    X509Certificate x509Certificate = check$ifrefutable$3;
                                                                    boolean bl = x509Certificate != null;
                                                                    return bl;
                                                                }
                                                            }).flatMap((Function1)new Serializable(this, jwtsClaims){
                                                                public static final long serialVersionUID = 0L;
                                                                public final Jws jwtsClaims$2;

                                                                public final Try<Right<Nothing$, User>> apply(X509Certificate cert) {
                                                                    return Try$.MODULE$.apply((Function0)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final /* synthetic */ anonfun$authenticate$1$$anonfun$apply$1$$anonfun$2$$anonfun$apply$3$$anonfun$apply$4$$anonfun$apply$6 $outer;

                                                                        public final Claims apply() {
                                                                            return (Claims)this.$outer.jwtsClaims$2.getBody();
                                                                        }
                                                                        {
                                                                            if ($outer == null) {
                                                                                throw null;
                                                                            }
                                                                            this.$outer = $outer;
                                                                        }
                                                                    }).withFilter((Function1)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;

                                                                        public final boolean apply(Claims check$ifrefutable$4) {
                                                                            Claims claims = check$ifrefutable$4;
                                                                            boolean bl = claims != null;
                                                                            return bl;
                                                                        }
                                                                    }).flatMap((Function1)new Serializable(this, cert){
                                                                        public static final long serialVersionUID = 0L;
                                                                        public final X509Certificate cert$2;

                                                                        public final Try<Right<Nothing$, User>> apply(Claims jwtsBody) {
                                                                            return ShrineJwtAuthenticator$.MODULE$.failIfNull(jwtsBody.getSubject(), new ShrineJwtAuthenticator.MissingRequiredJwtsClaim("subject", this.cert$2.getSubjectDN())).flatMap((Function1)new Serializable(this, jwtsBody){
                                                                                public static final long serialVersionUID = 0L;
                                                                                private final /* synthetic */ anonfun$authenticate$1$$anonfun$apply$1$$anonfun$2$$anonfun$apply$3$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$9 $outer;
                                                                                private final Claims jwtsBody$1;

                                                                                public final Try<Right<Nothing$, User>> apply(String jwtsSubject) {
                                                                                    return ShrineJwtAuthenticator$.MODULE$.failIfNull(this.jwtsBody$1.getSubject(), new ShrineJwtAuthenticator.MissingRequiredJwtsClaim("issuer", this.$outer.cert$2.getSubjectDN())).map((Function1)new Serializable(this, jwtsSubject){
                                                                                        public static final long serialVersionUID = 0L;
                                                                                        private final /* synthetic */ anonfun$authenticate$1$$anonfun$apply$1$$anonfun$2$$anonfun$apply$3$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$9$$anonfun$apply$10 $outer;
                                                                                        private final String jwtsSubject$1;

                                                                                        public final Right<Nothing$, User> apply(String jwtsIssuer) {
                                                                                            User user = new User(this.$outer.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().cert$2.getSubjectDN().getName(), this.jwtsSubject$1, jwtsIssuer, new Credential(jwtsIssuer, false), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
                                                                                            return package$.MODULE$.Right().apply((Object)user);
                                                                                        }
                                                                                        {
                                                                                            if ($outer == null) {
                                                                                                throw null;
                                                                                            }
                                                                                            this.$outer = $outer;
                                                                                            this.jwtsSubject$1 = jwtsSubject$1;
                                                                                        }
                                                                                    });
                                                                                }

                                                                                public /* synthetic */ anonfun$authenticate$1$$anonfun$apply$1$$anonfun$2$$anonfun$apply$3$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$9 net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                                                    return this.$outer;
                                                                                }
                                                                                {
                                                                                    if ($outer == null) {
                                                                                        throw null;
                                                                                    }
                                                                                    this.$outer = $outer;
                                                                                    this.jwtsBody$1 = jwtsBody$1;
                                                                                }
                                                                            });
                                                                        }
                                                                        {
                                                                            this.cert$2 = cert$2;
                                                                        }
                                                                    });
                                                                }
                                                                {
                                                                    this.jwtsClaims$2 = jwtsClaims$2;
                                                                }
                                                            });
                                                        }
                                                    });
                                                }
                                            });
                                        }
                                    });
                                    try_ = attempt;
                                    if (!(try_ instanceof Success)) break block7;
                                    Success success = (Success)try_;
                                    either = rightUser = (Either<Rejection, User>)success.value();
                                    break block8;
                                }
                                if (!(try_ instanceof Failure)) break block9;
                                Failure failure = (Failure)try_;
                                Throwable x = failure.exception();
                                Throwable throwable = x;
                                if (throwable instanceof ShrineJwtException) {
                                    ShrineJwtException shrineJwtException = (ShrineJwtException)throwable;
                                    ShrineJwtAuthenticator$.MODULE$.info((Function0<Object>)new Serializable(this, shrineJwtException){
                                        public static final long serialVersionUID = 0L;
                                        private final ShrineJwtException x2$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to authenticate due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x2$1.toString()}));
                                        }
                                        {
                                            this.x2$1 = x2$1;
                                        }
                                    }, shrineJwtException);
                                    either2 = shrineJwtException.rejection();
                                } else if (throwable instanceof ClaimJwtException) {
                                    ClaimJwtException claimJwtException = (ClaimJwtException)throwable;
                                    ShrineJwtAuthenticator$.MODULE$.info((Function0<Object>)new Serializable(this, claimJwtException){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$authenticate$1$$anonfun$apply$1 $outer;
                                        private final ClaimJwtException x3$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to authenticate due to ", " while authenticating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x3$1.toString(), this.$outer.ctx$1.request()}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.x3$1 = x3$1;
                                        }
                                    }, (Throwable)claimJwtException);
                                    either2 = ShrineJwtAuthenticator$.MODULE$.rejectedCredentials();
                                } else {
                                    ShrineJwtAuthenticator$.MODULE$.warn((Function0<Object>)new Serializable(this, throwable){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$authenticate$1$$anonfun$apply$1 $outer;
                                        private final Throwable x1$1;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unanticipated ", " while authenticating ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1.toString(), this.$outer.ctx$1.request()}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.x1$1 = x1$1;
                                        }
                                    }, throwable);
                                    either2 = ShrineJwtAuthenticator$.MODULE$.rejectedCredentials();
                                }
                                either = either2;
                            }
                            return either;
                        }
                        throw new MatchError((Object)try_);
                    }
                    {
                        this.ctx$1 = ctx$1;
                    }
                }, this.ec$1);
            }
            {
                this.ec$1 = ec$1;
            }
        };
    }

    public OAuth2BearerToken createOAuthCredentials(User user, String dnsName) {
        BouncyKeyStoreCollection bouncyKeyStoreCollection;
        block5: {
            KeyStoreEntry keyStoreEntry;
            block3: {
                block4: {
                    KeyStoreEntry myEntry;
                    block2: {
                        KeyStoreEntry myEntry2;
                        bouncyKeyStoreCollection = this.certCollection();
                        if (!(bouncyKeyStoreCollection instanceof HubCertCollection)) break block2;
                        HubCertCollection hubCertCollection = (HubCertCollection)bouncyKeyStoreCollection;
                        keyStoreEntry = myEntry2 = hubCertCollection.myEntry();
                        break block3;
                    }
                    if (!(bouncyKeyStoreCollection instanceof DownStreamCertCollection)) break block4;
                    DownStreamCertCollection downStreamCertCollection = (DownStreamCertCollection)bouncyKeyStoreCollection;
                    keyStoreEntry = myEntry = downStreamCertCollection.myEntry();
                    break block3;
                }
                if (!(bouncyKeyStoreCollection instanceof PeerCertCollection)) break block5;
                PeerCertCollection peerCertCollection = (PeerCertCollection)bouncyKeyStoreCollection;
                Seq sites = peerCertCollection.remoteSites();
                keyStoreEntry = (KeyStoreEntry)((RemoteSite)sites.find((Function1)new Serializable(dnsName){
                    public static final long serialVersionUID = 0L;
                    private final String dnsName$1;

                    public final boolean apply(RemoteSite x$1) {
                        String string = x$1.url();
                        String string2 = this.dnsName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.dnsName$1 = dnsName$1;
                    }
                }).get()).entry().get();
            }
            KeyStoreEntry oauthEntry = keyStoreEntry;
            String base64Cert = TextCodec.BASE64URL.encode(oauthEntry.cert().getEncoded());
            PrivateKey key = (PrivateKey)this.certCollection().myEntry().privateKey().get();
            Date expiration = new Date(System.currentTimeMillis() + 30000L);
            String jwtsString = Jwts.builder().setHeaderParam("kid", (Object)base64Cert).setSubject(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{user.username(), user.domain()}))).setIssuer(InetAddress.getLocalHost().getHostName()).setExpiration(expiration).signWith(SignatureAlgorithm.RS512, (Key)key).compact();
            return new OAuth2BearerToken(jwtsString);
        }
        throw new MatchError((Object)bouncyKeyStoreCollection);
    }

    public Try<HttpHeader> extractAuthorizationHeader(HttpRequest request) {
        return Try$.MODULE$.apply((Function0)new Serializable(request){
            public static final long serialVersionUID = 0L;
            public final HttpRequest request$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$4$ net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$NoAuthorizationHeaderException$2$lzycompute(VolatileObjectRef x$1) {
                anonfun.extractAuthorizationHeader.1 var2_2 = this;
                synchronized (var2_2) {
                    if (x$1.elem != null) return (ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$4$)((Object)x$1.elem);
                    x$1.elem = new ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$4$(this);
                    return (ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$4$)((Object)x$1.elem);
                }
            }

            public final HttpHeader apply() {
                VolatileObjectRef NoAuthorizationHeaderException$module = VolatileObjectRef.zero();
                return (HttpHeader)this.request$1.headers().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(HttpHeader x$2) {
                        return x$2.name().equals(HttpHeaders.Authorization$.MODULE$.name());
                    }
                }).getOrElse((Function0)new Serializable(this, NoAuthorizationHeaderException$module){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.extractAuthorizationHeader.1 $outer;
                    private final VolatileObjectRef NoAuthorizationHeaderException$module$1;

                    public final Nothing$ apply() {
                        public class Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3
                        extends ShrineJwtException
                        implements Product,
                        Serializable {
                            private final HttpRequest request;
                            public final /* synthetic */ anonfun.extractAuthorizationHeader.1 $outer;

                            public HttpRequest request() {
                                return this.request;
                            }

                            public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3 copy(HttpRequest request) {
                                return new Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3(this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$NoAuthorizationHeaderException$$$outer(), request);
                            }

                            public HttpRequest copy$default$1() {
                                return this.request();
                            }

                            public String productPrefix() {
                                return "NoAuthorizationHeaderException";
                            }

                            public int productArity() {
                                return 1;
                            }

                            public Object productElement(int x$1) {
                                int n = x$1;
                                switch (n) {
                                    default: {
                                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                                    }
                                    case 0: 
                                }
                                return this.request();
                            }

                            public Iterator<Object> productIterator() {
                                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                            }

                            public boolean canEqual(Object x$1) {
                                return x$1 instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3;
                            }

                            public int hashCode() {
                                return ScalaRunTime$.MODULE$._hashCode((Product)this);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public boolean equals(Object x$1) {
                                if (this == x$1) return true;
                                Object object = x$1;
                                if (!(object instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3)) return false;
                                boolean bl = true;
                                if (!bl) return false;
                                Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3 var4_4 = (Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3)x$1;
                                HttpRequest httpRequest = this.request();
                                HttpRequest httpRequest2 = var4_4.request();
                                if (httpRequest == null) {
                                    if (httpRequest2 != null) {
                                        return false;
                                    }
                                } else if (!httpRequest.equals(httpRequest2)) return false;
                                if (!var4_4.canEqual(this)) return false;
                                return true;
                            }

                            public /* synthetic */ anonfun.extractAuthorizationHeader.1 net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$NoAuthorizationHeaderException$$$outer() {
                                return this.$outer;
                            }

                            public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$3(anonfun.extractAuthorizationHeader.1 $outer, HttpRequest request) {
                                this.request = request;
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No ", " header found in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HttpHeaders.Authorization$.MODULE$.name(), request})), ShrineJwtAuthenticator$.MODULE$.missingCredentials(), ShrineJwtException$.MODULE$.$lessinit$greater$default$3());
                                Product.class.$init$((Product)this);
                            }
                        }
                        throw this.$outer.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$NoAuthorizationHeaderException$2(this.NoAuthorizationHeaderException$module$1).apply(this.$outer.request$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.NoAuthorizationHeaderException$module$1 = NoAuthorizationHeaderException$module$1;
                    }
                });
            }

            public final ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$4$ net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$NoAuthorizationHeaderException$2(VolatileObjectRef NoAuthorizationHeaderException$module$1) {
                return NoAuthorizationHeaderException$module$1.elem == null ? this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$NoAuthorizationHeaderException$2$lzycompute(NoAuthorizationHeaderException$module$1) : (ShrineJwtAuthenticator$$anonfun$extractAuthorizationHeader$1$NoAuthorizationHeaderException$4$)((Object)NoAuthorizationHeaderException$module$1.elem);
            }
            {
                this.request$1 = request$1;
            }
        });
    }

    public Try<String> extractJwtsStringAndCheckScheme(HttpHeader httpHeader) {
        return Try$.MODULE$.apply((Function0)new Serializable(httpHeader){
            public static final long serialVersionUID = 0L;
            private final HttpHeader httpHeader$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$4$ WrongNumberOfSegmentsException$2$lzycompute(String[] x$1, VolatileObjectRef x$2) {
                anonfun.extractJwtsStringAndCheckScheme.1 var3_3 = this;
                synchronized (var3_3) {
                    if (x$2.elem != null) return (ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$4$)((Object)x$2.elem);
                    x$2.elem = new ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$4$(this, x$1);
                    return (ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$4$)((Object)x$2.elem);
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$4$ NotBearerAuthException$2$lzycompute(String[] x$1, VolatileObjectRef x$2) {
                anonfun.extractJwtsStringAndCheckScheme.1 var3_3 = this;
                synchronized (var3_3) {
                    if (x$2.elem != null) return (ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$4$)((Object)x$2.elem);
                    x$2.elem = new ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$4$(this, x$1);
                    return (ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$4$)((Object)x$2.elem);
                }
            }

            public final String apply() {
                String[] splitHeaderValue = this.httpHeader$1.value().trim().split(" ");
                if (splitHeaderValue.length != 2) {
                    VolatileObjectRef WrongNumberOfSegmentsException$module = VolatileObjectRef.zero();
                    public class Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3
                    extends ShrineJwtException
                    implements Product,
                    Serializable {
                        private final HttpHeader httpHeader;
                        public final /* synthetic */ anonfun.extractJwtsStringAndCheckScheme.1 $outer;
                        private final String[] splitHeaderValue$1;

                        public HttpHeader httpHeader() {
                            return this.httpHeader;
                        }

                        public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3 copy(HttpHeader httpHeader) {
                            return new Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3(this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$WrongNumberOfSegmentsException$$$outer(), httpHeader, this.splitHeaderValue$1);
                        }

                        public HttpHeader copy$default$1() {
                            return this.httpHeader();
                        }

                        public String productPrefix() {
                            return "WrongNumberOfSegmentsException";
                        }

                        public int productArity() {
                            return 1;
                        }

                        public Object productElement(int x$1) {
                            int n = x$1;
                            switch (n) {
                                default: {
                                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                                }
                                case 0: 
                            }
                            return this.httpHeader();
                        }

                        public Iterator<Object> productIterator() {
                            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                        }

                        public boolean canEqual(Object x$1) {
                            return x$1 instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3;
                        }

                        public int hashCode() {
                            return ScalaRunTime$.MODULE$._hashCode((Product)this);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public boolean equals(Object x$1) {
                            if (this == x$1) return true;
                            Object object = x$1;
                            if (!(object instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3)) return false;
                            boolean bl = true;
                            if (!bl) return false;
                            Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3 var4_4 = (Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3)x$1;
                            HttpHeader httpHeader = this.httpHeader();
                            HttpHeader httpHeader2 = var4_4.httpHeader();
                            if (httpHeader == null) {
                                if (httpHeader2 != null) {
                                    return false;
                                }
                            } else if (!httpHeader.equals(httpHeader2)) return false;
                            if (!var4_4.canEqual(this)) return false;
                            return true;
                        }

                        public /* synthetic */ anonfun.extractJwtsStringAndCheckScheme.1 net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$WrongNumberOfSegmentsException$$$outer() {
                            return this.$outer;
                        }

                        public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3(anonfun.extractJwtsStringAndCheckScheme.1 $outer, HttpHeader httpHeader, String[] splitHeaderValue$1) {
                            this.httpHeader = httpHeader;
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.splitHeaderValue$1 = splitHeaderValue$1;
                            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Header had ", " space-delimited segments, not 2, in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)splitHeaderValue$1.length), httpHeader})), ShrineJwtAuthenticator$.MODULE$.missingCredentials(), ShrineJwtException$.MODULE$.$lessinit$greater$default$3());
                            Product.class.$init$((Product)this);
                        }
                    }
                    throw new Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$3(this, this.httpHeader$1, splitHeaderValue);
                }
                String string = splitHeaderValue[0];
                String string2 = ShrineJwtAuthenticator$.MODULE$.BearerAuthScheme();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return splitHeaderValue[1];
                }
                VolatileObjectRef NotBearerAuthException$module = VolatileObjectRef.zero();
                public class Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3
                extends ShrineJwtException
                implements Product,
                Serializable {
                    private final HttpHeader httpHeader;
                    public final /* synthetic */ anonfun.extractJwtsStringAndCheckScheme.1 $outer;
                    private final String[] splitHeaderValue$1;

                    public HttpHeader httpHeader() {
                        return this.httpHeader;
                    }

                    public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3 copy(HttpHeader httpHeader) {
                        return new Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3(this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$NotBearerAuthException$$$outer(), httpHeader, this.splitHeaderValue$1);
                    }

                    public HttpHeader copy$default$1() {
                        return this.httpHeader();
                    }

                    public String productPrefix() {
                        return "NotBearerAuthException";
                    }

                    public int productArity() {
                        return 1;
                    }

                    public Object productElement(int x$1) {
                        int n = x$1;
                        switch (n) {
                            default: {
                                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                            }
                            case 0: 
                        }
                        return this.httpHeader();
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3;
                    }

                    public int hashCode() {
                        return ScalaRunTime$.MODULE$._hashCode((Product)this);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object x$1) {
                        if (this == x$1) return true;
                        Object object = x$1;
                        if (!(object instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3)) return false;
                        boolean bl = true;
                        if (!bl) return false;
                        Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3 var4_4 = (Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3)x$1;
                        HttpHeader httpHeader = this.httpHeader();
                        HttpHeader httpHeader2 = var4_4.httpHeader();
                        if (httpHeader == null) {
                            if (httpHeader2 != null) {
                                return false;
                            }
                        } else if (!httpHeader.equals(httpHeader2)) return false;
                        if (!var4_4.canEqual(this)) return false;
                        return true;
                    }

                    public /* synthetic */ anonfun.extractJwtsStringAndCheckScheme.1 net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$NotBearerAuthException$$$outer() {
                        return this.$outer;
                    }

                    public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3(anonfun.extractJwtsStringAndCheckScheme.1 $outer, HttpHeader httpHeader, String[] splitHeaderValue$1) {
                        this.httpHeader = httpHeader;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.splitHeaderValue$1 = splitHeaderValue$1;
                        super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected ", ", not ", " in ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ShrineJwtAuthenticator$.MODULE$.BearerAuthScheme(), splitHeaderValue$1[0], httpHeader})), ShrineJwtAuthenticator$.MODULE$.missingCredentials(), ShrineJwtException$.MODULE$.$lessinit$greater$default$3());
                        Product.class.$init$((Product)this);
                    }
                }
                throw new Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$3(this, this.httpHeader$1, splitHeaderValue);
            }

            private final ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$4$ WrongNumberOfSegmentsException$2(String[] splitHeaderValue$1, VolatileObjectRef WrongNumberOfSegmentsException$module$1) {
                return WrongNumberOfSegmentsException$module$1.elem == null ? this.WrongNumberOfSegmentsException$2$lzycompute(splitHeaderValue$1, WrongNumberOfSegmentsException$module$1) : (ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$WrongNumberOfSegmentsException$4$)((Object)WrongNumberOfSegmentsException$module$1.elem);
            }

            private final ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$4$ NotBearerAuthException$2(String[] splitHeaderValue$1, VolatileObjectRef NotBearerAuthException$module$1) {
                return NotBearerAuthException$module$1.elem == null ? this.NotBearerAuthException$2$lzycompute(splitHeaderValue$1, NotBearerAuthException$module$1) : (ShrineJwtAuthenticator$$anonfun$extractJwtsStringAndCheckScheme$1$NotBearerAuthException$4$)((Object)NotBearerAuthException$module$1.elem);
            }
            {
                this.httpHeader$1 = httpHeader$1;
            }
        });
    }

    public Try<Jws<Claims>> extractJwtsClaims(String jwtsString) {
        return Try$.MODULE$.apply((Function0)new Serializable(jwtsString){
            public static final long serialVersionUID = 0L;
            private final String jwtsString$1;

            public final Jws<Claims> apply() {
                return Jwts.parser().setSigningKeyResolver((SigningKeyResolver)new SigningKeyResolverBridge()).parseClaimsJws(this.jwtsString$1);
            }
            {
                this.jwtsString$1 = jwtsString$1;
            }
        });
    }

    public Try<X509Certificate> extractAndCheckCert(Jws<Claims> jwtsClaims) {
        return Try$.MODULE$.apply((Function0)new Serializable(jwtsClaims){
            public static final long serialVersionUID = 0L;
            private final Jws jwtsClaims$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$4$ net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$CertIssuerNotInCollectionException$2$lzycompute(VolatileObjectRef x$1) {
                anonfun.extractAndCheckCert.1 var2_2 = this;
                synchronized (var2_2) {
                    if (x$1.elem != null) return (ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$4$)((Object)x$1.elem);
                    x$1.elem = new ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$4$(this);
                    return (ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$4$)((Object)x$1.elem);
                }
            }

            /*
             * WARNING - void declaration
             */
            public final X509Certificate apply() {
                public class Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3
                extends ShrineJwtException
                implements Product,
                Serializable {
                    private final String issuingSite;
                    private final Principal issuer;
                    private final Iterable<String> aliases;
                    public final /* synthetic */ anonfun.extractAndCheckCert.1 $outer;

                    public String issuingSite() {
                        return this.issuingSite;
                    }

                    public Principal issuer() {
                        return this.issuer;
                    }

                    public Iterable<String> aliases() {
                        return this.aliases;
                    }

                    public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3 copy(String issuingSite, Principal issuer, Iterable<String> aliases) {
                        return new Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3(this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$CertIssuerNotInCollectionException$$$outer(), issuingSite, issuer, aliases);
                    }

                    public String copy$default$1() {
                        return this.issuingSite();
                    }

                    public Principal copy$default$2() {
                        return this.issuer();
                    }

                    public Iterable<String> copy$default$3() {
                        return this.aliases();
                    }

                    public String productPrefix() {
                        return "CertIssuerNotInCollectionException";
                    }

                    public int productArity() {
                        return 3;
                    }

                    public Object productElement(int x$1) {
                        Object object;
                        int n = x$1;
                        switch (n) {
                            default: {
                                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                            }
                            case 2: {
                                object = this.aliases();
                                break;
                            }
                            case 1: {
                                object = this.issuer();
                                break;
                            }
                            case 0: {
                                object = this.issuingSite();
                            }
                        }
                        return object;
                    }

                    public Iterator<Object> productIterator() {
                        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                    }

                    public boolean canEqual(Object x$1) {
                        return x$1 instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3;
                    }

                    public int hashCode() {
                        return ScalaRunTime$.MODULE$._hashCode((Product)this);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean equals(Object x$1) {
                        if (this == x$1) return true;
                        Object object = x$1;
                        if (!(object instanceof Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3)) return false;
                        boolean bl = true;
                        if (!bl) return false;
                        Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3 var4_4 = (Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3)x$1;
                        String string = this.issuingSite();
                        String string2 = var4_4.issuingSite();
                        if (string == null) {
                            if (string2 != null) {
                                return false;
                            }
                        } else if (!string.equals(string2)) return false;
                        Principal principal = this.issuer();
                        Principal principal2 = var4_4.issuer();
                        if (principal == null) {
                            if (principal2 != null) {
                                return false;
                            }
                        } else if (!((Object)principal).equals(principal2)) return false;
                        Iterable<String> iterable = this.aliases();
                        Iterable<String> iterable2 = var4_4.aliases();
                        if (iterable == null) {
                            if (iterable2 != null) {
                                return false;
                            }
                        } else if (!iterable.equals(iterable2)) return false;
                        if (!var4_4.canEqual(this)) return false;
                        return true;
                    }

                    public /* synthetic */ anonfun.extractAndCheckCert.1 net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$CertIssuerNotInCollectionException$$$outer() {
                        return this.$outer;
                    }

                    public Net_shrine_dashboard_jwtauth_ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$3(anonfun.extractAndCheckCert.1 $outer, String issuingSite, Principal issuer, Iterable<String> aliases) {
                        this.issuingSite = issuingSite;
                        this.issuer = issuer;
                        this.aliases = aliases;
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find a certificate with issuer DN ", ". Known cert aliases are ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{issuer, aliases.mkString(",")})), ShrineJwtException$.MODULE$.$lessinit$greater$default$2(), ShrineJwtException$.MODULE$.$lessinit$greater$default$3());
                        Product.class.$init$((Product)this);
                    }
                }
                void var2_2;
                void var3_3;
                void var1_1;
                BouncyKeyStoreCollection bouncyKeyStoreCollection;
                HubCertCollection hubCertCollection;
                boolean bl;
                DownStreamCertCollection downStreamCertCollection;
                boolean bl2;
                block9: {
                    X509Certificate x509Certificate;
                    block6: {
                        ObjectRef objectRef;
                        boolean bl3;
                        String issuingSite;
                        X509Certificate cert;
                        VolatileObjectRef CertIssuerNotInCollectionException$module;
                        block8: {
                            block7: {
                                block5: {
                                    CertIssuerNotInCollectionException$module = VolatileObjectRef.zero();
                                    cert = KeySource$.MODULE$.certForString(((JwsHeader)this.jwtsClaims$1.getHeader()).getKeyId());
                                    issuingSite = ((Claims)this.jwtsClaims$1.getBody()).getIssuer();
                                    bl2 = false;
                                    downStreamCertCollection = null;
                                    bl = false;
                                    hubCertCollection = null;
                                    bl3 = false;
                                    objectRef = ObjectRef.create(null);
                                    bouncyKeyStoreCollection = ShrineJwtAuthenticator$.MODULE$.certCollection();
                                    if (!(bouncyKeyStoreCollection instanceof DownStreamCertCollection)) break block5;
                                    bl2 = true;
                                    downStreamCertCollection = (DownStreamCertCollection)bouncyKeyStoreCollection;
                                    KeyStoreEntry caEntry = downStreamCertCollection.caEntry();
                                    if (!caEntry.signed(cert)) break block5;
                                    x509Certificate = cert;
                                    break block6;
                                }
                                if (!(bouncyKeyStoreCollection instanceof HubCertCollection)) break block7;
                                bl = true;
                                hubCertCollection = (HubCertCollection)bouncyKeyStoreCollection;
                                KeyStoreEntry ca = hubCertCollection.myEntry();
                                if (!ca.signed(cert)) break block7;
                                x509Certificate = cert;
                                break block6;
                            }
                            if (!(bouncyKeyStoreCollection instanceof PeerCertCollection)) break block8;
                            bl3 = true;
                            objectRef.elem = (PeerCertCollection)bouncyKeyStoreCollection;
                            Set entries = ((PeerCertCollection)objectRef.elem).entries();
                            if (!entries.exists((Function1)new Serializable(this, cert){
                                public static final long serialVersionUID = 0L;
                                private final X509Certificate cert$1;

                                public final boolean apply(KeyStoreEntry x$3) {
                                    return x$3.signed(this.cert$1);
                                }
                                {
                                    this.cert$1 = cert$1;
                                }
                            })) break block8;
                            x509Certificate = cert;
                            break block6;
                        }
                        if (!bl3) break block9;
                        x509Certificate = (X509Certificate)((PeerCertCollection)objectRef.elem).allEntries().find((Function1)new Serializable(this, cert){
                            public static final long serialVersionUID = 0L;
                            private final X509Certificate cert$1;

                            public final boolean apply(KeyStoreEntry x$4) {
                                return x$4.signed(this.cert$1);
                            }
                            {
                                this.cert$1 = cert$1;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final X509Certificate apply(KeyStoreEntry x$5) {
                                return x$5.cert();
                            }
                        }).getOrElse((Function0)new Serializable(this, cert, issuingSite, objectRef, CertIssuerNotInCollectionException$module){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.extractAndCheckCert.1 $outer;
                            private final X509Certificate cert$1;
                            private final String issuingSite$1;
                            private final ObjectRef x8$1;
                            private final VolatileObjectRef CertIssuerNotInCollectionException$module$1;

                            public final Nothing$ apply() {
                                throw this.$outer.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$CertIssuerNotInCollectionException$2(this.CertIssuerNotInCollectionException$module$1).apply(this.issuingSite$1, this.cert$1.getIssuerDN(), (Iterable<String>)((Iterable)((PeerCertCollection)this.x8$1.elem).allEntries().flatMap((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final NonEmptySeq<String> apply(KeyStoreEntry x$6) {
                                        return x$6.aliases();
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.cert$1 = cert$1;
                                this.issuingSite$1 = issuingSite$1;
                                this.x8$1 = x8$1;
                                this.CertIssuerNotInCollectionException$module$1 = CertIssuerNotInCollectionException$module$1;
                            }
                        });
                    }
                    return x509Certificate;
                }
                if (bl2) {
                    throw this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$CertIssuerNotInCollectionException$2((VolatileObjectRef)var1_1).apply((String)var3_3, var2_2.getIssuerDN(), (Iterable<String>)downStreamCertCollection.caEntry().aliases());
                }
                if (bl) {
                    throw this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$CertIssuerNotInCollectionException$2((VolatileObjectRef)var1_1).apply((String)var3_3, var2_2.getIssuerDN(), (Iterable<String>)hubCertCollection.caEntry().aliases());
                }
                throw new MatchError((Object)bouncyKeyStoreCollection);
            }

            public final ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$4$ net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$CertIssuerNotInCollectionException$2(VolatileObjectRef CertIssuerNotInCollectionException$module$1) {
                return CertIssuerNotInCollectionException$module$1.elem == null ? this.net$shrine$dashboard$jwtauth$ShrineJwtAuthenticator$$anonfun$$CertIssuerNotInCollectionException$2$lzycompute(CertIssuerNotInCollectionException$module$1) : (ShrineJwtAuthenticator$$anonfun$extractAndCheckCert$1$CertIssuerNotInCollectionException$4$)((Object)CertIssuerNotInCollectionException$module$1.elem);
            }
            {
                this.jwtsClaims$1 = jwtsClaims$1;
            }
        });
    }

    public <E> Try<E> failIfNull(E e, Throwable t) {
        return Try$.MODULE$.apply((Function0)new Serializable(e, t){
            public static final long serialVersionUID = 0L;
            private final Object e$1;
            private final Throwable t$1;

            public final E apply() {
                if (this.e$1 == null) {
                    throw this.t$1;
                }
                return (E)this.e$1;
            }
            {
                this.e$1 = e$1;
                this.t$1 = t$1;
            }
        });
    }

    public String BearerAuthScheme() {
        if ((byte)(this.bitmap$init$0 & 2) != 0) {
            return this.BearerAuthScheme;
        }
        throw new UninitializedFieldError("Uninitialized field: ShrineJwtAuthenticator.scala: 182");
    }

    public HttpHeaders.WWW.minusAuthenticate challengeHeader() {
        if ((byte)(this.bitmap$init$0 & 4) != 0) {
            return this.challengeHeader;
        }
        throw new UninitializedFieldError("Uninitialized field: ShrineJwtAuthenticator.scala: 183");
    }

    public Either<Rejection, User> missingCredentials() {
        if ((byte)(this.bitmap$init$0 & 8) != 0) {
            return this.missingCredentials;
        }
        throw new UninitializedFieldError("Uninitialized field: ShrineJwtAuthenticator.scala: 184");
    }

    public Either<Rejection, User> rejectedCredentials() {
        if ((byte)(this.bitmap$init$0 & 0x10) != 0) {
            return this.rejectedCredentials;
        }
        throw new UninitializedFieldError("Uninitialized field: ShrineJwtAuthenticator.scala: 185");
    }

    private ShrineJwtAuthenticator$() {
        MODULE$ = this;
        Loggable.class.$init$((Loggable)this);
        this.certCollection = KeyStoreInfo$.MODULE$.certCollection();
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.BearerAuthScheme = "Bearer";
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.challengeHeader = HttpHeaders.WWW$minusAuthenticate$.MODULE$.apply(new HttpChallenge(this.BearerAuthScheme(), "dashboard-to-dashboard", HttpChallenge$.MODULE$.apply$default$3()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpChallenge[0]));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.missingCredentials = package$.MODULE$.Left().apply((Object)new AuthenticationFailedRejection((AuthenticationFailedRejection.Cause)AuthenticationFailedRejection.CredentialsMissing$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeaders.WWW.minusAuthenticate[]{this.challengeHeader()}))));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
        this.rejectedCredentials = package$.MODULE$.Left().apply((Object)new AuthenticationFailedRejection((AuthenticationFailedRejection.Cause)AuthenticationFailedRejection.CredentialsRejected$.MODULE$, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeaders.WWW.minusAuthenticate[]{this.challengeHeader()}))));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 0x10);
    }
}

