/*
 * Decompiled with CFR 0.152.
 */
package cats.effect.unsafe;

import cats.effect.unsafe.Scheduler;
import cats.effect.unsafe.Scheduler$;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoField;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import scala.Function0;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005Y2q\u0001B\u0003\u0002\u0002\u0015Y1\u0007C\u0003\u0013\u0001\u0011\u0005A\u0003C\u0003\u0018\u0001\u0011\u0005\u0001\u0004C\u0003&\u0001\u0011\u0005aE\u0001\u000eTG\",G-\u001e7fe\u000e{W\u000e]1oS>t\u0007\u000b\\1uM>\u0014XN\u0003\u0002\u0007\u000f\u00051QO\\:bM\u0016T!\u0001C\u0005\u0002\r\u00154g-Z2u\u0015\u0005Q\u0011\u0001B2biN\u001c\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000b\u0011\u0005Y\u0001Q\"A\u0003\u0002-\r\u0014X-\u0019;f\t\u00164\u0017-\u001e7u'\u000eDW\rZ;mKJ$\u0012!\u0007\t\u0005\u001biar$\u0003\u0002\u001c\u001d\t1A+\u001e9mKJ\u0002\"AF\u000f\n\u0005y)!!C*dQ\u0016$W\u000f\\3s!\ri\u0001EI\u0005\u0003C9\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\u00055\u0019\u0013B\u0001\u0013\u000f\u0005\u0011)f.\u001b;\u0002+\u0019\u0014x.\\*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peR\u0011Ad\n\u0005\u0006Q\r\u0001\r!K\u0001\ng\u000eDW\rZ;mKJ\u0004\"AK\u0019\u000e\u0003-R!\u0001L\u0017\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002/_\u0005!Q\u000f^5m\u0015\u0005\u0001\u0014\u0001\u00026bm\u0006L!AM\u0016\u00031M\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'oU3sm&\u001cWM\u0004\u0002\u0017i%\u0011Q'B\u0001\n'\u000eDW\rZ;mKJ\u0004")
public abstract class SchedulerCompanionPlatform {
    public Tuple2<Scheduler, Function0<BoxedUnit>> createDefaultScheduler() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r);
            t.setName("io-scheduler");
            t.setDaemon(true);
            t.setPriority(10);
            return t;
        });
        return new Tuple2((Object)Scheduler$.MODULE$.fromScheduledExecutor(scheduler), (JFunction0.mcV.sp & Serializable)() -> scheduler.shutdown());
    }

    public Scheduler fromScheduledExecutor(ScheduledExecutorService scheduler) {
        return new Scheduler((Scheduler$)this, scheduler){
            private final ScheduledExecutorService scheduler$2;

            public Runnable sleep(FiniteDuration delay, Runnable task) {
                ScheduledFuture<?> future = this.scheduler$2.schedule(task, delay.length(), delay.unit());
                return () -> future.cancel(false);
            }

            public long nowMillis() {
                return System.currentTimeMillis();
            }

            public long nowMicros() {
                Instant now = Instant.now();
                return now.getEpochSecond() * 1000000L + now.getLong(ChronoField.MICRO_OF_SECOND);
            }

            public long monotonicNanos() {
                return System.nanoTime();
            }
            {
                this.scheduler$2 = scheduler$2;
                Scheduler.$init$(this);
            }
        };
    }
}

