/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Bytes;

public class ConsumerGroupHeartbeatResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    String memberId;
    int memberEpoch;
    boolean shouldComputeAssignment;
    int heartbeatIntervalMs;
    Assignment assignment;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The top-level error code, or 0 if there was no error"), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The top-level error message, or null if there was no error."), new Field("member_id", Type.COMPACT_NULLABLE_STRING, "The member id generated by the coordinator. Only provided when the member joins with MemberEpoch == 0."), new Field("member_epoch", Type.INT32, "The member epoch."), new Field("should_compute_assignment", Type.BOOLEAN, "True if the member should compute the assignment for the group."), new Field("heartbeat_interval_ms", Type.INT32, "The heartbeat interval in milliseconds."), new Field("assignment", Assignment.SCHEMA_0, "null if not provided; the assignment otherwise."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ConsumerGroupHeartbeatResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ConsumerGroupHeartbeatResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = null;
        this.memberId = null;
        this.memberEpoch = 0;
        this.shouldComputeAssignment = false;
        this.heartbeatIntervalMs = 0;
        this.assignment = null;
    }

    @Override
    public short apiKey() {
        return 68;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.memberId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
        }
        this.memberEpoch = _readable.readInt();
        this.shouldComputeAssignment = _readable.readByte() != 0;
        this.heartbeatIntervalMs = _readable.readInt();
        this.assignment = _readable.readByte() < 0 ? null : new Assignment(_readable, _version);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        if (this.memberId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue(this.memberId);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
        }
        _writable.writeInt(this.memberEpoch);
        _writable.writeByte(this.shouldComputeAssignment ? (byte)1 : 0);
        _writable.writeInt(this.heartbeatIntervalMs);
        if (this.assignment == null) {
            _writable.writeByte((byte)-1);
        } else {
            _writable.writeByte((byte)1);
            this.assignment.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        if (this.memberId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
        }
        _size.addBytes(4);
        _size.addBytes(1);
        _size.addBytes(4);
        if (this.assignment == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(1);
            this.assignment.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConsumerGroupHeartbeatResponseData)) {
            return false;
        }
        ConsumerGroupHeartbeatResponseData other = (ConsumerGroupHeartbeatResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
            return false;
        }
        if (this.memberEpoch != other.memberEpoch) {
            return false;
        }
        if (this.shouldComputeAssignment != other.shouldComputeAssignment) {
            return false;
        }
        if (this.heartbeatIntervalMs != other.heartbeatIntervalMs) {
            return false;
        }
        if (this.assignment == null ? other.assignment != null : !this.assignment.equals(other.assignment)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
        hashCode = 31 * hashCode + this.memberEpoch;
        hashCode = 31 * hashCode + (this.shouldComputeAssignment ? 1231 : 1237);
        hashCode = 31 * hashCode + this.heartbeatIntervalMs;
        hashCode = 31 * hashCode + (this.assignment == null ? 0 : this.assignment.hashCode());
        return hashCode;
    }

    @Override
    public ConsumerGroupHeartbeatResponseData duplicate() {
        ConsumerGroupHeartbeatResponseData _duplicate = new ConsumerGroupHeartbeatResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.memberId = this.memberId == null ? null : this.memberId;
        _duplicate.memberEpoch = this.memberEpoch;
        _duplicate.shouldComputeAssignment = this.shouldComputeAssignment;
        _duplicate.heartbeatIntervalMs = this.heartbeatIntervalMs;
        _duplicate.assignment = this.assignment == null ? null : this.assignment.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "ConsumerGroupHeartbeatResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", memberEpoch=" + this.memberEpoch + ", shouldComputeAssignment=" + (this.shouldComputeAssignment ? "true" : "false") + ", heartbeatIntervalMs=" + this.heartbeatIntervalMs + ", assignment=" + (this.assignment == null ? "null" : this.assignment.toString()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String memberId() {
        return this.memberId;
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public boolean shouldComputeAssignment() {
        return this.shouldComputeAssignment;
    }

    public int heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public Assignment assignment() {
        return this.assignment;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ConsumerGroupHeartbeatResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ConsumerGroupHeartbeatResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ConsumerGroupHeartbeatResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public ConsumerGroupHeartbeatResponseData setMemberId(String v) {
        this.memberId = v;
        return this;
    }

    public ConsumerGroupHeartbeatResponseData setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }

    public ConsumerGroupHeartbeatResponseData setShouldComputeAssignment(boolean v) {
        this.shouldComputeAssignment = v;
        return this;
    }

    public ConsumerGroupHeartbeatResponseData setHeartbeatIntervalMs(int v) {
        this.heartbeatIntervalMs = v;
        return this;
    }

    public ConsumerGroupHeartbeatResponseData setAssignment(Assignment v) {
        this.assignment = v;
        return this;
    }

    public static class TopicPartitions
    implements Message {
        Uuid topicId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("topic_id", Type.UUID, "The topic ID."), new Field("partitions", new CompactArrayOf(Type.INT32), "The partitions."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicPartitions(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicPartitions() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<Integer>(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        @Override
        public void read(Readable _readable, short _version) {
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (Integer partitionsElement : this.partitions) {
                _writable.writeInt(partitionsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitions.size() + 1));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            if (!this.topicId.equals(other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        @Override
        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topicId = this.topicId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartitions(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartitions setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicPartitions setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }

    public static class Assignment
    implements Message {
        byte error;
        List<TopicPartitions> assignedTopicPartitions;
        List<TopicPartitions> pendingTopicPartitions;
        short metadataVersion;
        byte[] metadataBytes;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field("error", Type.INT8, "The assigned error."), new Field("assigned_topic_partitions", new CompactArrayOf(TopicPartitions.SCHEMA_0), "The partitions assigned to the member that can be used immediately."), new Field("pending_topic_partitions", new CompactArrayOf(TopicPartitions.SCHEMA_0), "The partitions assigned to the member that cannot be used because they are not released by their former owners yet."), new Field("metadata_version", Type.INT16, "The version of the metadata."), new Field("metadata_bytes", Type.COMPACT_BYTES, "The assigned metadata."), Field.TaggedFieldsSection.of(new Object[0]));
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Assignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public Assignment() {
            this.error = 0;
            this.assignedTopicPartitions = new ArrayList<TopicPartitions>(0);
            this.pendingTopicPartitions = new ArrayList<TopicPartitions>(0);
            this.metadataVersion = 0;
            this.metadataBytes = Bytes.EMPTY;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 0;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of Assignment");
            }
            this.error = _readable.readByte();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field assignedTopicPartitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<TopicPartitions> newCollection = new ArrayList<TopicPartitions>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicPartitions(_readable, _version));
            }
            this.assignedTopicPartitions = newCollection;
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field pendingTopicPartitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicPartitions(_readable, _version));
            }
            this.pendingTopicPartitions = newCollection;
            this.metadataVersion = _readable.readShort();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field metadataBytes was serialized as null");
            }
            byte[] newBytes = _readable.readArray(length);
            this.metadataBytes = newBytes;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeByte(this.error);
            _writable.writeUnsignedVarint(this.assignedTopicPartitions.size() + 1);
            for (TopicPartitions assignedTopicPartitionsElement : this.assignedTopicPartitions) {
                assignedTopicPartitionsElement.write(_writable, _cache, _version);
            }
            _writable.writeUnsignedVarint(this.pendingTopicPartitions.size() + 1);
            for (TopicPartitions pendingTopicPartitionsElement : this.pendingTopicPartitions) {
                pendingTopicPartitionsElement.write(_writable, _cache, _version);
            }
            _writable.writeShort(this.metadataVersion);
            _writable.writeUnsignedVarint(this.metadataBytes.length + 1);
            _writable.writeByteArray(this.metadataBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of Assignment");
            }
            _size.addBytes(1);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.assignedTopicPartitions.size() + 1));
            for (TopicPartitions assignedTopicPartitionsElement : this.assignedTopicPartitions) {
                assignedTopicPartitionsElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.pendingTopicPartitions.size() + 1));
            for (TopicPartitions pendingTopicPartitionsElement : this.pendingTopicPartitions) {
                pendingTopicPartitionsElement.addSize(_size, _cache, _version);
            }
            _size.addBytes(2);
            _size.addBytes(this.metadataBytes.length);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.metadataBytes.length + 1));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Assignment)) {
                return false;
            }
            Assignment other = (Assignment)obj;
            if (this.error != other.error) {
                return false;
            }
            if (this.assignedTopicPartitions == null ? other.assignedTopicPartitions != null : !this.assignedTopicPartitions.equals(other.assignedTopicPartitions)) {
                return false;
            }
            if (this.pendingTopicPartitions == null ? other.pendingTopicPartitions != null : !this.pendingTopicPartitions.equals(other.pendingTopicPartitions)) {
                return false;
            }
            if (this.metadataVersion != other.metadataVersion) {
                return false;
            }
            if (!Arrays.equals(this.metadataBytes, other.metadataBytes)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.error;
            hashCode = 31 * hashCode + (this.assignedTopicPartitions == null ? 0 : this.assignedTopicPartitions.hashCode());
            hashCode = 31 * hashCode + (this.pendingTopicPartitions == null ? 0 : this.pendingTopicPartitions.hashCode());
            hashCode = 31 * hashCode + this.metadataVersion;
            hashCode = 31 * hashCode + Arrays.hashCode(this.metadataBytes);
            return hashCode;
        }

        @Override
        public Assignment duplicate() {
            Assignment _duplicate = new Assignment();
            _duplicate.error = this.error;
            ArrayList<TopicPartitions> newAssignedTopicPartitions = new ArrayList<TopicPartitions>(this.assignedTopicPartitions.size());
            for (TopicPartitions _element : this.assignedTopicPartitions) {
                newAssignedTopicPartitions.add(_element.duplicate());
            }
            _duplicate.assignedTopicPartitions = newAssignedTopicPartitions;
            ArrayList<TopicPartitions> newPendingTopicPartitions = new ArrayList<TopicPartitions>(this.pendingTopicPartitions.size());
            for (TopicPartitions _element : this.pendingTopicPartitions) {
                newPendingTopicPartitions.add(_element.duplicate());
            }
            _duplicate.pendingTopicPartitions = newPendingTopicPartitions;
            _duplicate.metadataVersion = this.metadataVersion;
            _duplicate.metadataBytes = MessageUtil.duplicate(this.metadataBytes);
            return _duplicate;
        }

        public String toString() {
            return "Assignment(error=" + this.error + ", assignedTopicPartitions=" + MessageUtil.deepToString(this.assignedTopicPartitions.iterator()) + ", pendingTopicPartitions=" + MessageUtil.deepToString(this.pendingTopicPartitions.iterator()) + ", metadataVersion=" + this.metadataVersion + ", metadataBytes=" + Arrays.toString(this.metadataBytes) + ")";
        }

        public byte error() {
            return this.error;
        }

        public List<TopicPartitions> assignedTopicPartitions() {
            return this.assignedTopicPartitions;
        }

        public List<TopicPartitions> pendingTopicPartitions() {
            return this.pendingTopicPartitions;
        }

        public short metadataVersion() {
            return this.metadataVersion;
        }

        public byte[] metadataBytes() {
            return this.metadataBytes;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Assignment setError(byte v) {
            this.error = v;
            return this;
        }

        public Assignment setAssignedTopicPartitions(List<TopicPartitions> v) {
            this.assignedTopicPartitions = v;
            return this;
        }

        public Assignment setPendingTopicPartitions(List<TopicPartitions> v) {
            this.pendingTopicPartitions = v;
            return this;
        }

        public Assignment setMetadataVersion(short v) {
            this.metadataVersion = v;
            return this;
        }

        public Assignment setMetadataBytes(byte[] v) {
            this.metadataBytes = v;
            return this;
        }
    }
}

