/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListPolicyTagsPublisher
implements SdkPublisher<ListPolicyTagsResponse> {
    private final IamAsyncClient client;
    private final ListPolicyTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPolicyTagsPublisher(IamAsyncClient client, ListPolicyTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPolicyTagsPublisher(IamAsyncClient client, ListPolicyTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPolicyTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPolicyTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        Function<ListPolicyTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPolicyTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPolicyTagsResponseFetcher
    implements AsyncPageFetcher<ListPolicyTagsResponse> {
        private ListPolicyTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListPolicyTagsResponse> nextPage(ListPolicyTagsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyTagsPublisher.this.client.listPolicyTags(ListPolicyTagsPublisher.this.firstRequest);
            }
            return ListPolicyTagsPublisher.this.client.listPolicyTags((ListPolicyTagsRequest)((Object)ListPolicyTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

