/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyGroupListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyRoleListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyUser;
import software.amazon.awssdk.services.iam.model.PolicyUserListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesForPolicyResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
    private static final SdkField<List<PolicyGroup>> POLICY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyGroups").getter(ListEntitiesForPolicyResponse.getter(ListEntitiesForPolicyResponse::policyGroups)).setter(ListEntitiesForPolicyResponse.setter(Builder::policyGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PolicyUser>> POLICY_USERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyUsers").getter(ListEntitiesForPolicyResponse.getter(ListEntitiesForPolicyResponse::policyUsers)).setter(ListEntitiesForPolicyResponse.setter(Builder::policyUsers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyUsers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PolicyRole>> POLICY_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PolicyRoles").getter(ListEntitiesForPolicyResponse.getter(ListEntitiesForPolicyResponse::policyRoles)).setter(ListEntitiesForPolicyResponse.setter(Builder::policyRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRoles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListEntitiesForPolicyResponse.getter(ListEntitiesForPolicyResponse::isTruncated)).setter(ListEntitiesForPolicyResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListEntitiesForPolicyResponse.getter(ListEntitiesForPolicyResponse::marker)).setter(ListEntitiesForPolicyResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_GROUPS_FIELD, POLICY_USERS_FIELD, POLICY_ROLES_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<PolicyGroup> policyGroups;
    private final List<PolicyUser> policyUsers;
    private final List<PolicyRole> policyRoles;
    private final Boolean isTruncated;
    private final String marker;

    private ListEntitiesForPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyGroups = builder.policyGroups;
        this.policyUsers = builder.policyUsers;
        this.policyRoles = builder.policyRoles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public final boolean hasPolicyGroups() {
        return this.policyGroups != null && !(this.policyGroups instanceof SdkAutoConstructList);
    }

    public final List<PolicyGroup> policyGroups() {
        return this.policyGroups;
    }

    public final boolean hasPolicyUsers() {
        return this.policyUsers != null && !(this.policyUsers instanceof SdkAutoConstructList);
    }

    public final List<PolicyUser> policyUsers() {
        return this.policyUsers;
    }

    public final boolean hasPolicyRoles() {
        return this.policyRoles != null && !(this.policyRoles instanceof SdkAutoConstructList);
    }

    public final List<PolicyRole> policyRoles() {
        return this.policyRoles;
    }

    public final Boolean isTruncated() {
        return this.isTruncated;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyGroups() ? this.policyGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyUsers() ? this.policyUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyRoles() ? this.policyRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyResponse)) {
            return false;
        }
        ListEntitiesForPolicyResponse other = (ListEntitiesForPolicyResponse)((Object)obj);
        return this.hasPolicyGroups() == other.hasPolicyGroups() && Objects.equals(this.policyGroups(), other.policyGroups()) && this.hasPolicyUsers() == other.hasPolicyUsers() && Objects.equals(this.policyUsers(), other.policyUsers()) && this.hasPolicyRoles() == other.hasPolicyRoles() && Objects.equals(this.policyRoles(), other.policyRoles()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitiesForPolicyResponse").add("PolicyGroups", this.hasPolicyGroups() ? this.policyGroups() : null).add("PolicyUsers", this.hasPolicyUsers() ? this.policyUsers() : null).add("PolicyRoles", this.hasPolicyRoles() ? this.policyRoles() : null).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyGroups": {
                return Optional.ofNullable(clazz.cast(this.policyGroups()));
            }
            case "PolicyUsers": {
                return Optional.ofNullable(clazz.cast(this.policyUsers()));
            }
            case "PolicyRoles": {
                return Optional.ofNullable(clazz.cast(this.policyRoles()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesForPolicyResponse, T> g) {
        return obj -> g.apply((ListEntitiesForPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<PolicyGroup> policyGroups = DefaultSdkAutoConstructList.getInstance();
        private List<PolicyUser> policyUsers = DefaultSdkAutoConstructList.getInstance();
        private List<PolicyRole> policyRoles = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesForPolicyResponse model) {
            super(model);
            this.policyGroups(model.policyGroups);
            this.policyUsers(model.policyUsers);
            this.policyRoles(model.policyRoles);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final List<PolicyGroup.Builder> getPolicyGroups() {
            List<PolicyGroup.Builder> result = PolicyGroupListTypeCopier.copyToBuilder(this.policyGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyGroups(Collection<PolicyGroup.BuilderImpl> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copyFromBuilder(policyGroups);
        }

        @Override
        public final Builder policyGroups(Collection<PolicyGroup> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copy(policyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(PolicyGroup ... policyGroups) {
            this.policyGroups(Arrays.asList(policyGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(Consumer<PolicyGroup.Builder> ... policyGroups) {
            this.policyGroups(Stream.of(policyGroups).map(c -> (PolicyGroup)((PolicyGroup.Builder)PolicyGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PolicyUser.Builder> getPolicyUsers() {
            List<PolicyUser.Builder> result = PolicyUserListTypeCopier.copyToBuilder(this.policyUsers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyUsers(Collection<PolicyUser.BuilderImpl> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copyFromBuilder(policyUsers);
        }

        @Override
        public final Builder policyUsers(Collection<PolicyUser> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copy(policyUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(PolicyUser ... policyUsers) {
            this.policyUsers(Arrays.asList(policyUsers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(Consumer<PolicyUser.Builder> ... policyUsers) {
            this.policyUsers(Stream.of(policyUsers).map(c -> (PolicyUser)((PolicyUser.Builder)PolicyUser.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PolicyRole.Builder> getPolicyRoles() {
            List<PolicyRole.Builder> result = PolicyRoleListTypeCopier.copyToBuilder(this.policyRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicyRoles(Collection<PolicyRole.BuilderImpl> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copyFromBuilder(policyRoles);
        }

        @Override
        public final Builder policyRoles(Collection<PolicyRole> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copy(policyRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(PolicyRole ... policyRoles) {
            this.policyRoles(Arrays.asList(policyRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(Consumer<PolicyRole.Builder> ... policyRoles) {
            this.policyRoles(Stream.of(policyRoles).map(c -> (PolicyRole)((PolicyRole.Builder)PolicyRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListEntitiesForPolicyResponse build() {
            return new ListEntitiesForPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
        public Builder policyGroups(Collection<PolicyGroup> var1);

        public Builder policyGroups(PolicyGroup ... var1);

        public Builder policyGroups(Consumer<PolicyGroup.Builder> ... var1);

        public Builder policyUsers(Collection<PolicyUser> var1);

        public Builder policyUsers(PolicyUser ... var1);

        public Builder policyUsers(Consumer<PolicyUser.Builder> ... var1);

        public Builder policyRoles(Collection<PolicyRole> var1);

        public Builder policyRoles(PolicyRole ... var1);

        public Builder policyRoles(Consumer<PolicyRole.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

